/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.portal.restclient;

import de.cuioss.portal.configuration.connections.impl.ConnectionMetadata;
import de.cuioss.portal.restclient.BasicAuthenticationFilter;
import de.cuioss.portal.restclient.BearerTokenAuthFilter;
import de.cuioss.portal.restclient.LogClientRequestFilter;
import de.cuioss.portal.restclient.LogClientResponseFilter;
import de.cuioss.portal.restclient.LogReaderInterceptor;
import de.cuioss.portal.restclient.TokenFilter;
import de.cuioss.tools.logging.CuiLogger;
import de.cuioss.tools.string.MoreStrings;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Response;
import java.io.Closeable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.ext.QueryParamStyle;
import org.eclipse.microprofile.rest.client.ext.ResponseExceptionMapper;

public class CuiRestClientBuilder {
    private static final CuiLogger log = new CuiLogger(CuiRestClientBuilder.class);
    private static final String DISABLE_DEFAULT_MAPPER_PROPERTY_KEY = "microprofile.rest.client.disable.default.mapper";
    public static final String RESPONSE_EXCEPTION_MAPPER = "org.jboss.resteasy.microprofile.client.DefaultResponseExceptionMapper";
    private final RestClientBuilder mpRestClientBuilder = RestClientBuilder.newBuilder();
    private boolean traceLogEnabled;
    private final CuiLogger logger;

    public CuiRestClientBuilder(CuiLogger logger) {
        this.logger = logger;
        this.traceLogEnabled = logger.isTraceEnabled() || log.isTraceEnabled();
        this.disableDefaultExceptionHandler();
    }

    public static void debugResponse(Response response, CuiLogger log) {
        log.debug("-- Client response filter --\nStatus: {}\nStatusInfo: {}\nAllowed Methods: {}\nEntityTag: {}\nCookies: {}\nDate: {}\nHeaders: {}\nLanguage: {}\nLastModified: {}\nLinks: {}\nLocation: {}\nMediaType: {}\n", new Object[]{response.getStatus(), response.getStatusInfo(), response.getAllowedMethods(), response.getEntityTag(), response.getCookies(), response.getDate(), response.getHeaders(), response.getLanguage(), response.getLastModified(), response.getLinks(), response.getLocation(), response.getMediaType()});
    }

    public CuiRestClientBuilder connectionMetadata(ConnectionMetadata connectionMeta) {
        this.url(connectionMeta.getServiceUrl());
        this.sslContext(connectionMeta.resolveSSLContext());
        switch (connectionMeta.getAuthenticationType()) {
            case BASIC: {
                this.basicAuth(connectionMeta.getLoginCredentials().getUsername(), connectionMeta.getLoginCredentials().getPassword());
                break;
            }
            case TOKEN_FROM_USER: 
            case TOKEN_APPLICATION: {
                this.mpRestClientBuilder.register((Object)new TokenFilter(connectionMeta.getTokenResolver()));
                break;
            }
        }
        for (Map.Entry entry : connectionMeta.getContextMap().entrySet()) {
            this.mpRestClientBuilder.property(String.valueOf(entry.getKey()), (Object)String.valueOf(entry.getValue()));
        }
        if (connectionMeta.isDisableHostNameVerification()) {
            this.hostnameVerifier((hostname, sslSession) -> true);
        }
        if (connectionMeta.getConnectionTimeout() > 0L) {
            this.connectTimeout(connectionMeta.getConnectionTimeout(), connectionMeta.getConnectionTimeoutUnit());
        }
        if (connectionMeta.getReadTimeout() > 0L) {
            this.readTimeout(connectionMeta.getReadTimeout(), connectionMeta.getReadTimeoutUnit());
        }
        if (!MoreStrings.isBlank((CharSequence)connectionMeta.getProxyHost()) && null != connectionMeta.getProxyPort() && connectionMeta.getProxyPort() > 0) {
            this.proxyAddress(connectionMeta.getProxyHost(), connectionMeta.getProxyPort());
        }
        return this;
    }

    public CuiRestClientBuilder traceLogEnabled(boolean value) {
        this.traceLogEnabled = value;
        return this;
    }

    public CuiRestClientBuilder register(Object component) {
        this.mpRestClientBuilder.register(component);
        return this;
    }

    public CuiRestClientBuilder register(Object component, int priority) {
        this.mpRestClientBuilder.register(component, priority);
        return this;
    }

    public CuiRestClientBuilder property(String key, Object value) {
        this.mpRestClientBuilder.property(key, value);
        return this;
    }

    public CuiRestClientBuilder enableDefaultExceptionHandler() {
        try {
            Class<?> defaultResponseExceptionMapper = Class.forName(RESPONSE_EXCEPTION_MAPPER, false, CuiRestClientBuilder.class.getClassLoader());
            this.register(defaultResponseExceptionMapper.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), Integer.MIN_VALUE);
            this.disableDefaultExceptionHandler();
        }
        catch (Exception e) {
            log.error("Portal-541: Could not load org.jboss.resteasy.microprofile.client.DefaultResponseExceptionMapper", (Throwable)e);
        }
        return this;
    }

    public CuiRestClientBuilder disableDefaultExceptionHandler() {
        this.property(DISABLE_DEFAULT_MAPPER_PROPERTY_KEY, true);
        return this;
    }

    public CuiRestClientBuilder url(String url) {
        try {
            this.mpRestClientBuilder.baseUrl(new URL(url));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("The URL '" + url + "' could not be parsed!", e);
        }
        return this;
    }

    public CuiRestClientBuilder url(URL url) {
        this.mpRestClientBuilder.baseUrl(url);
        return this;
    }

    public CuiRestClientBuilder uri(URI uri) {
        this.mpRestClientBuilder.baseUri(uri);
        return this;
    }

    public CuiRestClientBuilder basicAuth(String username, String password) {
        this.mpRestClientBuilder.register((Object)new BasicAuthenticationFilter(username, password));
        return this;
    }

    public CuiRestClientBuilder bearerAuthToken(String token) {
        this.mpRestClientBuilder.register((Object)new BearerTokenAuthFilter(token));
        return this;
    }

    public CuiRestClientBuilder registerExceptionMapper(ResponseExceptionMapper<?> mapper) {
        this.mpRestClientBuilder.register(mapper);
        return this;
    }

    public CuiRestClientBuilder sslContext(SSLContext sslContext) {
        this.mpRestClientBuilder.sslContext(sslContext);
        return this;
    }

    public CuiRestClientBuilder connectTimeout(long amount, TimeUnit timeUnit) {
        this.mpRestClientBuilder.connectTimeout(amount, timeUnit);
        return this;
    }

    public CuiRestClientBuilder readTimeout(long amount, TimeUnit timeUnit) {
        this.mpRestClientBuilder.readTimeout(amount, timeUnit);
        return this;
    }

    public CuiRestClientBuilder queryParamStyle(QueryParamStyle queryParamStyle) {
        this.mpRestClientBuilder.queryParamStyle(queryParamStyle);
        return this;
    }

    public CuiRestClientBuilder proxyAddress(String host, int port) {
        this.mpRestClientBuilder.proxyAddress(host, port);
        return this;
    }

    public CuiRestClientBuilder followRedirects(boolean followRedirects) {
        this.mpRestClientBuilder.followRedirects(followRedirects);
        return this;
    }

    public CuiRestClientBuilder hostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.mpRestClientBuilder.hostnameVerifier(hostnameVerifier);
        return this;
    }

    public Configuration getConfiguration() {
        return this.mpRestClientBuilder.getConfiguration();
    }

    public <T extends Closeable> T build(Class<T> clazz) {
        if (this.traceLogEnabled) {
            log.debug("trace logging engaged");
            this.register(new LogClientRequestFilter(this.logger));
            this.register(new LogClientResponseFilter(this.logger, "First ClientResponseFilter"){}, Integer.MAX_VALUE);
            this.register(new LogClientResponseFilter(this.logger, "Last ClientResponseFilter"){}, Integer.MIN_VALUE);
            this.register(new LogReaderInterceptor(this.logger));
        }
        return (T)((Closeable)this.mpRestClientBuilder.build(clazz));
    }
}

