/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.portal.restclient;

import de.cuioss.portal.configuration.connections.impl.ConnectionMetadata;
import de.cuioss.portal.configuration.impl.producer.ConnectionMetadataProducer;
import de.cuioss.portal.configuration.util.ConfigurationHelper;
import de.cuioss.portal.restclient.CuiRestClientBuilder;
import de.cuioss.portal.restclient.PortalRestClient;
import de.cuioss.portal.restclient.RestClientHolder;
import de.cuioss.tools.base.Preconditions;
import de.cuioss.tools.collect.CollectionLiterals;
import de.cuioss.tools.lang.MoreObjects;
import de.cuioss.tools.logging.CuiLogger;
import de.cuioss.tools.string.MoreStrings;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.io.Closeable;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import java.util.Optional;

@ApplicationScoped
public class RestClientProducer {
    private static final CuiLogger log = new CuiLogger(RestClientProducer.class);

    @Produces
    @Dependent
    @PortalRestClient(baseName="unused")
    <T extends Closeable> RestClientHolder<T> produceRestClient(InjectionPoint injectionPoint) {
        PortalRestClient annotationMetaData = (PortalRestClient)ConfigurationHelper.resolveAnnotation((InjectionPoint)injectionPoint, PortalRestClient.class).orElseThrow(() -> new IllegalArgumentException("Expected injectionPoint annotated with @PortalRestClient, but was not:" + injectionPoint));
        ParameterizedType type = (ParameterizedType)MoreObjects.requireType((Object)injectionPoint.getType(), ParameterizedType.class);
        List arguments = CollectionLiterals.mutableList((Object[])type.getActualTypeArguments());
        Preconditions.checkArgument((!arguments.isEmpty() ? 1 : 0) != 0);
        Class serviceInterface = (Class)arguments.get(0);
        String baseName = RestClientProducer.suffixNameWithDot(MoreStrings.requireNotEmpty((String)annotationMetaData.baseName(), (String)"Portal-117: Configuration setting for baseName is missing."));
        log.debug("Producing DsmlClient for baseName ='{}'", new Object[]{baseName});
        boolean failOnInvalidConfiguration = annotationMetaData.failOnInvalidConfiguration();
        try {
            ConnectionMetadata connectionMetadata = ConnectionMetadataProducer.createConnectionMetadata((String)baseName, (boolean)failOnInvalidConfiguration);
            return new RestClientHolder(new CuiRestClientBuilder(this.resolveCuiLogger(injectionPoint, serviceInterface)).connectionMetadata(connectionMetadata).build(serviceInterface));
        }
        catch (IllegalArgumentException e) {
            log.error("Initialization of RestClientHolder failed", (Throwable)e);
            return new RestClientHolder<Object>(null);
        }
    }

    public static String suffixNameWithDot(String name) {
        return name.endsWith(".") ? name : name + ".";
    }

    private Optional<Class<?>> resolveCallerClass(InjectionPoint ip) {
        if (null != ip && null != ip.getMember() && null != ip.getMember().getDeclaringClass()) {
            Class<?> clazz = ip.getMember().getDeclaringClass();
            if (clazz.getName().contains("$Proxy$")) {
                log.debug("not using class {} as it seems to be a Weld CDI proxy", new Object[]{clazz.getName()});
                return Optional.empty();
            }
            return Optional.of(clazz);
        }
        return Optional.empty();
    }

    private CuiLogger resolveCuiLogger(InjectionPoint ip, Class<?> fallback) {
        Class<?> clazz = this.resolveCallerClass(ip).orElse(fallback);
        log.debug("Using logger class: {}", new Object[]{clazz.getName()});
        return new CuiLogger(clazz);
    }
}

