/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.portal.restclient;

import de.cuioss.tools.io.IOStreams;
import de.cuioss.tools.logging.CuiLogger;
import jakarta.annotation.Priority;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.ReaderInterceptorContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;

@Priority(value=-2147483648)
class LogReaderInterceptor
implements ReaderInterceptor {
    private static final String LINE_BREAK = "\n";
    private final CuiLogger log;

    public LogReaderInterceptor(CuiLogger logger) {
        this.log = logger;
    }

    public Object aroundReadFrom(ReaderInterceptorContext context) throws IOException, WebApplicationException {
        try {
            StringBuilder logMsg = new StringBuilder();
            logMsg.append("-- Client response info --").append(LINE_BREAK);
            logMsg.append("MediaType: ").append(context.getMediaType()).append(LINE_BREAK);
            logMsg.append("GenericType: ").append(context.getGenericType()).append(LINE_BREAK);
            this.logProperties(logMsg, context);
            this.logHeaders(logMsg, context);
            this.logBody(logMsg, context);
            this.log.info(logMsg.toString());
        }
        catch (Exception e) {
            this.log.error("Portal-529: Could not trace-log response data", (Throwable)e);
        }
        return context.proceed();
    }

    private void logBody(StringBuilder logMsg, ReaderInterceptorContext context) throws IOException {
        String body;
        try (InputStream inputStream = context.getInputStream();){
            body = IOStreams.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
        }
        logMsg.append("Body:").append(LINE_BREAK).append(body);
        context.setInputStream((InputStream)new ByteArrayInputStream(body.getBytes(StandardCharsets.UTF_8)));
    }

    private void logHeaders(StringBuilder logMsg, ReaderInterceptorContext context) {
        logMsg.append("Headers:").append(LINE_BREAK);
        context.getHeaders().forEach((key, value) -> this.logHeader(logMsg, (String)key, (List<String>)value));
    }

    private void logHeader(StringBuilder logMsg, String key, List<String> value) {
        logMsg.append(key).append(": ").append(value).append(LINE_BREAK);
    }

    private void logProperties(StringBuilder logMsg, ReaderInterceptorContext context) {
        logMsg.append("Properties:").append(LINE_BREAK);
        for (String name : context.getPropertyNames()) {
            logMsg.append(name).append(": ").append(context.getProperty(name)).append(LINE_BREAK);
        }
    }
}

