/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.portal.restclient;

import de.cuioss.tools.logging.CuiLogger;
import de.cuioss.tools.string.MoreStrings;
import jakarta.annotation.Priority;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.core.Form;
import java.io.IOException;

@Priority(value=0x7FFFFFFF)
class LogClientRequestFilter
implements ClientRequestFilter {
    private static final String PATTERN = "-- Client request info --\nRequest URI: {}\nMethod: {}\nHeaders: {}\nBody: {}\n";
    private final CuiLogger log;

    public LogClientRequestFilter(CuiLogger logger) {
        this.log = logger;
    }

    public void filter(ClientRequestContext reqContext) throws IOException {
        try {
            StringBuilder headers = new StringBuilder();
            reqContext.getStringHeaders().forEach((key, value) -> headers.append((String)key).append(": ").append(value).append("\n"));
            String body = "";
            if (reqContext.hasEntity()) {
                Object object = reqContext.getEntity();
                if (object instanceof Form) {
                    Form form = (Form)object;
                    body = form.asMap().toString();
                } else {
                    body = reqContext.getEntity().toString();
                }
            }
            this.log.info(PATTERN, new Object[]{reqContext.getUri(), MoreStrings.nullToEmpty((String)reqContext.getMethod()), headers.toString(), body});
        }
        catch (Exception e) {
            this.log.error("Portal-529: Could not trace-log request data", (Throwable)e);
        }
    }
}

