/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.portal.restclient;

import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import lombok.NonNull;

public class BasicAuthenticationFilter
implements ClientRequestFilter {
    private final String headerValue;

    public BasicAuthenticationFilter(@NonNull String username, @NonNull String password) {
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        if (password == null) {
            throw new NullPointerException("password is marked non-null but is null");
        }
        this.headerValue = "Basic " + Base64.getEncoder().encodeToString((username + ":" + password).getBytes(StandardCharsets.US_ASCII));
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        requestContext.getHeaders().putSingle((Object)"Authorization", (Object)this.headerValue);
    }
}

