/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.portal.authentication.oauth.impl;

import de.cuioss.portal.authentication.oauth.Oauth2Configuration;
import de.cuioss.portal.authentication.oauth.impl.Oauth2ConfigurationImpl;
import de.cuioss.portal.restclient.CuiRestClientBuilder;
import de.cuioss.tools.logging.CuiLogger;
import de.cuioss.tools.net.UrlHelper;
import de.cuioss.tools.string.MoreStrings;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.ws.rs.GET;
import java.io.Closeable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class Oauth2DiscoveryConfigurationProducer {
    private static final CuiLogger LOGGER = new CuiLogger(Oauth2DiscoveryConfigurationProducer.class);
    @Produces
    @Dependent
    private Oauth2Configuration configuration;
    @Inject
    @ConfigProperty(name="authentication.oidc.client.id")
    private Provider<Optional<String>> oauth2clientId;
    @Inject
    @ConfigProperty(name="authentication.oidc.client.password")
    private Provider<Optional<String>> oauth2clientSecret;
    @Inject
    @ConfigProperty(name="authentication.oidc.server.url")
    private Provider<Optional<String>> serverBaseUrl;
    @Inject
    @ConfigProperty(name="authentication.oidc.server.discovery_path")
    private Provider<Optional<String>> oauth2discoveryUri;
    @Inject
    @ConfigProperty(name="authentication.externalHostname")
    private Provider<Optional<String>> externalContextPath;
    @Inject
    @ConfigProperty(name="authentication.oidc.client.default_scopes")
    private Provider<Optional<String>> oauth2initialScopes;
    @Inject
    @ConfigProperty(name="authentication.oidc.client.role_mapper_claim")
    private Provider<Optional<List<String>>> roleMapperClaim;
    @Inject
    @ConfigProperty(name="authentication.oidc.client.logout_redirect_parameter")
    private Provider<Optional<String>> logoutRedirectParameter;
    @Inject
    @ConfigProperty(name="authentication.oidc.client.logout.params.add_id_token_hint")
    private Provider<Optional<Boolean>> logoutWithIdTokenHintProvider;
    @Inject
    @ConfigProperty(name="authentication.oidc.client.logout.redirect_uri")
    private Provider<Optional<String>> postLogoutRedirectUri;
    @Inject
    @ConfigProperty(name="authentication.oidc.server.token_endpoint_url")
    private Provider<Optional<String>> internalTokenUrl;
    @Inject
    @ConfigProperty(name="authentication.oidc.server.userinfo_endpoint_url")
    private Provider<Optional<String>> internalUserInfoUrl;
    @Inject
    @ConfigProperty(name="authentication.oidc.validation.enabled")
    private Provider<Boolean> configValidationEnabled;

    @PostConstruct
    public void init() {
        this.configuration = null;
        String settingServerBaseUrl = ((Optional)this.serverBaseUrl.get()).orElse(null);
        String settingOauth2discoveryUri = ((Optional)this.oauth2discoveryUri.get()).orElse(null);
        if (!MoreStrings.isBlank((CharSequence)settingServerBaseUrl) && !MoreStrings.isBlank((CharSequence)settingOauth2discoveryUri)) {
            CuiRestClientBuilder builder = new CuiRestClientBuilder(LOGGER);
            String discoveryURI = UrlHelper.addTrailingSlashToUrl((String)settingServerBaseUrl) + settingOauth2discoveryUri;
            LOGGER.debug("Using discoveryURI {}", new Object[]{discoveryURI});
            builder.url(discoveryURI);
            try (RequestDiscovery discoveryEndpoint = (RequestDiscovery)builder.build(RequestDiscovery.class);){
                Map<String, Object> discovery = discoveryEndpoint.getDiscovery();
                this.configuration = this.createConfiguration(discovery);
            }
            catch (Exception e) {
                LOGGER.error((Throwable)e, "Auto discovery of oauth config failed, using URI: {}", new Object[]{discoveryURI});
            }
        } else {
            LOGGER.warn("Oauth config key '{}' and/or '{}' not set, trying fallback", new Object[]{"authentication.oidc.server.url", "authentication.oidc.server.discovery_path"});
        }
        LOGGER.debug("oauth config: {}", new Object[]{this.configuration});
        if (null != this.configuration && ((Boolean)this.configValidationEnabled.get()).booleanValue()) {
            this.configuration.validate();
        }
    }

    private Oauth2Configuration createConfiguration(Map<String, Object> discovery) {
        Oauth2ConfigurationImpl newConfiguration = new Oauth2ConfigurationImpl();
        ((Optional)this.oauth2clientId.get()).ifPresent(newConfiguration::setClientId);
        ((Optional)this.oauth2clientSecret.get()).ifPresent(newConfiguration::setClientSecret);
        ((Optional)this.externalContextPath.get()).ifPresent(newConfiguration::setExternalContextPath);
        ((Optional)this.oauth2initialScopes.get()).ifPresent(newConfiguration::setInitialScopes);
        ((Optional)this.logoutRedirectParameter.get()).ifPresent(newConfiguration::setLogoutRedirectParamName);
        ((Optional)this.postLogoutRedirectUri.get()).ifPresent(newConfiguration::setPostLogoutRedirectUri);
        Optional roleMapperClaims = (Optional)this.roleMapperClaim.get();
        if (roleMapperClaims.isPresent()) {
            newConfiguration.setRoleMapperClaims((List)roleMapperClaims.get());
        } else {
            newConfiguration.setRoleMapperClaims(Collections.emptyList());
        }
        ((Optional)this.logoutWithIdTokenHintProvider.get()).ifPresent(newConfiguration::setLogoutWithIdTokenHintEnabled);
        for (Map.Entry<String, Object> entry : discovery.entrySet()) {
            switch (entry.getKey()) {
                case "authorization_endpoint": {
                    newConfiguration.setAuthorizeUri((String)entry.getValue());
                    break;
                }
                case "userinfo_endpoint": {
                    newConfiguration.setUserInfoUri((String)entry.getValue());
                    break;
                }
                case "token_endpoint": {
                    newConfiguration.setTokenUri((String)entry.getValue());
                    break;
                }
                case "end_session_endpoint": {
                    newConfiguration.setLogoutUri((String)entry.getValue());
                    break;
                }
            }
        }
        ((Optional)this.internalTokenUrl.get()).ifPresent(url -> {
            LOGGER.debug("overwrite well-known token-url '{}' with: {}", new Object[]{newConfiguration.getTokenUri(), url});
            newConfiguration.setTokenUri((String)url);
        });
        ((Optional)this.internalUserInfoUrl.get()).ifPresent(url -> {
            LOGGER.debug("overwrite well-known userinfo-url '{}' with: {}", new Object[]{newConfiguration.getUserInfoUri(), url});
            newConfiguration.setUserInfoUri((String)url);
        });
        return newConfiguration;
    }

    @Generated
    public Oauth2Configuration getConfiguration() {
        return this.configuration;
    }

    public static interface RequestDiscovery
    extends Closeable {
        @GET
        public Map<String, Object> getDiscovery();
    }
}

