/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.portal.authentication.oauth.impl;

import de.cuioss.portal.authentication.AuthenticatedUserInfo;
import de.cuioss.portal.authentication.model.BaseAuthenticatedUserInfo;
import de.cuioss.portal.authentication.oauth.Oauth2Configuration;
import de.cuioss.portal.authentication.oauth.Oauth2Service;
import de.cuioss.portal.authentication.oauth.Token;
import de.cuioss.portal.authentication.oauth.impl.OauthAuthenticatedUserInfo;
import de.cuioss.portal.restclient.CuiRestClientBuilder;
import de.cuioss.tools.base.Preconditions;
import de.cuioss.tools.logging.CuiLogger;
import de.cuioss.tools.net.UrlParameter;
import de.cuioss.tools.string.MoreStrings;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.core.Response;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApplicationScoped
public class Oauth2ServiceImpl
implements Serializable,
Oauth2Service {
    private static final CuiLogger log = new CuiLogger(Oauth2ServiceImpl.class);
    private static final long serialVersionUID = 470127601291147747L;
    private static final String RETRIEVE_CLIENT_TOKEN_FAILED_MSG = "Portal-135: Retrieving client token failed";
    @Inject
    private Provider<Oauth2Configuration> configurationProvider;

    @Override
    public AuthenticatedUserInfo createAuthenticatedUserInfo(HttpServletRequest servletRequest, UrlParameter code, UrlParameter state, String scopes, String codeVerifier) {
        Token token;
        Objects.requireNonNull(servletRequest);
        Objects.requireNonNull(code);
        Objects.requireNonNull(state);
        Objects.requireNonNull(MoreStrings.emptyToNull((String)scopes));
        Oauth2Configuration configuration = (Oauth2Configuration)this.configurationProvider.get();
        CuiRestClientBuilder builder = new CuiRestClientBuilder(log).basicAuth(configuration.getClientId(), configuration.getClientSecret()).register((Object)new AcceptJsonHeaderFilter());
        String tokenUri = configuration.getTokenUri().trim();
        String redirectUri = configuration.getExternalContextPath().trim() + servletRequest.getRequestURI();
        log.debug("creating auth user info with scopes='{}', tokenUri='{}', redirectUri='{}'", new Object[]{scopes, tokenUri, redirectUri});
        try (RequestToken requestToken = (RequestToken)builder.url(tokenUri).build(RequestToken.class);){
            token = requestToken.requestToken("authorization_code", code.getValue(), state.getValue(), codeVerifier, redirectUri);
            log.trace("received token='{}' for scopes='{}', requestUri={}", new Object[]{token, scopes, servletRequest.getRequestURI()});
        }
        catch (IllegalArgumentException e) {
            log.warn("Portal-106: Retrieving request token failed", (Throwable)e);
            return null;
        }
        catch (WebApplicationException e) {
            log.warn("Portal-106: Retrieving request token failed", (Throwable)e);
            CuiRestClientBuilder.debugResponse((Response)e.getResponse(), (CuiLogger)log);
            return null;
        }
        catch (IOException e) {
            log.error("Portal-540: IO Exception during request", (Throwable)e);
            return null;
        }
        return this.retrieveAuthenticatedUser(scopes, configuration, token, (int)(System.currentTimeMillis() / 1000L));
    }

    @Override
    public AuthenticatedUserInfo retrieveAuthenticatedUser(String scopes, Token token, int tokenTimestamp) {
        return this.retrieveAuthenticatedUser(scopes, (Oauth2Configuration)this.configurationProvider.get(), token, tokenTimestamp);
    }

    private AuthenticatedUserInfo retrieveAuthenticatedUser(String scopes, Oauth2Configuration configuration, Token token, int tokenTimestamp) {
        BaseAuthenticatedUserInfo baseAuthenticatedUserInfo;
        block14: {
            String userInfoUri = configuration.getUserInfoUri().trim();
            CuiRestClientBuilder builder = new CuiRestClientBuilder(log).register((Object)new AcceptJsonHeaderFilter()).bearerAuthToken(token.getAccess_token());
            log.trace("retrieving userinfo for authenticated user. userInfoUri={}, access_token={}", new Object[]{userInfoUri, token.getAccess_token()});
            RequestUserInfo client = (RequestUserInfo)builder.url(userInfoUri).build(RequestUserInfo.class);
            try {
                Map<String, Object> userInfo = client.getUserInfo();
                log.debug("successfully retrieved userinfo");
                log.trace("userinfo: {}", new Object[]{userInfo});
                BaseAuthenticatedUserInfo.BaseAuthenticatedUserInfoBuilder baseAuthenticatedUserInfoBuilder = BaseAuthenticatedUserInfo.builder().authenticated(true).contextMapElement((Serializable)((Object)"tokenScopes"), (Serializable)((Object)scopes)).contextMapElement((Serializable)((Object)"token"), (Serializable)token).contextMapElement((Serializable)((Object)"tokenTimestamp"), (Serializable)Integer.valueOf(tokenTimestamp));
                for (Map.Entry<String, Object> entry : userInfo.entrySet()) {
                    if ("preferred_username".equals(entry.getKey())) {
                        baseAuthenticatedUserInfoBuilder.displayName(entry.getValue().toString());
                        continue;
                    }
                    if ("sub".equals(entry.getKey())) {
                        baseAuthenticatedUserInfoBuilder.identifier(entry.getValue().toString());
                        continue;
                    }
                    if ("email".equals(entry.getKey())) {
                        baseAuthenticatedUserInfoBuilder.contextMapElement((Serializable)((Object)"email"), (Serializable)((Object)entry.getValue().toString()));
                        continue;
                    }
                    if (configuration.getRoleMapperClaims().contains(entry.getKey())) {
                        baseAuthenticatedUserInfoBuilder.roles(Oauth2ServiceImpl.asStringList(entry.getValue()));
                        continue;
                    }
                    baseAuthenticatedUserInfoBuilder.contextMapElement((Serializable)((Object)("userinfo_" + entry.getKey())), (Serializable)((Object)entry.getValue().toString()));
                }
                baseAuthenticatedUserInfo = baseAuthenticatedUserInfoBuilder.build();
                if (client == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (WebApplicationException e) {
                    log.warn("Portal-107: Get userinfo failed", (Throwable)e);
                    CuiRestClientBuilder.debugResponse((Response)e.getResponse(), (CuiLogger)log);
                    return null;
                }
                catch (Exception e) {
                    log.warn("Portal-107: Get userinfo failed", (Throwable)e);
                    return null;
                }
            }
            client.close();
        }
        return baseAuthenticatedUserInfo;
    }

    private static List<String> asStringList(Object value) {
        if (null == value) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        if (value instanceof Iterable) {
            Iterable iterable = (Iterable)value;
            iterable.forEach(item -> result.addAll(Oauth2ServiceImpl.asStringList(item)));
        } else {
            result.add(value.toString());
        }
        return result;
    }

    @Override
    public String retrieveClientToken(String scopes) {
        String string;
        block9: {
            Oauth2Configuration configuration = (Oauth2Configuration)this.configurationProvider.get();
            Preconditions.checkState((null != configuration.getTokenUri() ? 1 : 0) != 0, (String)"tokenUri must not be null");
            CuiRestClientBuilder builder = new CuiRestClientBuilder(log).basicAuth(configuration.getClientId(), configuration.getClientSecret()).register((Object)new AcceptJsonHeaderFilter());
            RequestClientToken requestToken = (RequestClientToken)builder.url(configuration.getTokenUri().trim()).build(RequestClientToken.class);
            try {
                Token token = requestToken.requestToken("client_credentials");
                string = token.getAccess_token();
                if (requestToken == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (requestToken != null) {
                        try {
                            requestToken.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (WebApplicationException e) {
                    log.warn((Throwable)e, RETRIEVE_CLIENT_TOKEN_FAILED_MSG, new Object[0]);
                    CuiRestClientBuilder.debugResponse((Response)e.getResponse(), (CuiLogger)log);
                    return null;
                }
                catch (Exception e) {
                    log.warn((Throwable)e, RETRIEVE_CLIENT_TOKEN_FAILED_MSG, new Object[0]);
                    return null;
                }
            }
            requestToken.close();
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String refreshToken(OauthAuthenticatedUserInfo currentUser) {
        Oauth2Configuration configuration = (Oauth2Configuration)this.configurationProvider.get();
        CuiRestClientBuilder builder = new CuiRestClientBuilder(log).basicAuth(configuration.getClientId(), configuration.getClientSecret()).register((Object)new AcceptJsonHeaderFilter());
        try (RequestRefreshToken requestToken = (RequestRefreshToken)builder.url(configuration.getTokenUri().trim()).build(RequestRefreshToken.class);){
            Token token = requestToken.requestToken("refresh_token", currentUser.getToken().getRefresh_token());
            if (null != token) {
                log.debug("successfully retrieved new token");
                log.trace("new token: {}", new Object[]{token});
                currentUser.getContextMap().put((Serializable)((Object)"token"), token);
                currentUser.getContextMap().put((Serializable)((Object)"tokenTimestamp"), Integer.valueOf((int)(System.currentTimeMillis() / 1000L)));
                String string2 = token.getAccess_token();
                return string2;
            }
            log.debug("no token received");
            String string = null;
            return string;
        }
        catch (WebApplicationException e) {
            log.warn((Throwable)e, RETRIEVE_CLIENT_TOKEN_FAILED_MSG, new Object[0]);
            CuiRestClientBuilder.debugResponse((Response)e.getResponse(), (CuiLogger)log);
            return null;
        }
        catch (Exception e) {
            log.warn((Throwable)e, RETRIEVE_CLIENT_TOKEN_FAILED_MSG, new Object[0]);
            return null;
        }
    }

    @Override
    public String calcEncodedRedirectUrl(String url) {
        Objects.requireNonNull(url);
        return URLEncoder.encode(((Oauth2Configuration)this.configurationProvider.get()).getExternalContextPath().trim() + url, StandardCharsets.UTF_8);
    }

    public static class AcceptJsonHeaderFilter
    implements ClientRequestFilter {
        public void filter(ClientRequestContext requestContext) {
            requestContext.getHeaders().putSingle((Object)"Accept", (Object)"application/json");
        }
    }

    public static interface RequestToken
    extends Closeable {
        @POST
        @Produces(value={"application/x-www-form-urlencoded"})
        public Token requestToken(@FormParam(value="grant_type") String var1, @FormParam(value="code") String var2, @FormParam(value="state") String var3, @FormParam(value="code_verifier") String var4, @FormParam(value="redirect_uri") String var5);
    }

    public static interface RequestUserInfo
    extends Closeable {
        @GET
        public Map<String, Object> getUserInfo();
    }

    public static interface RequestClientToken
    extends Closeable {
        @POST
        @Produces(value={"application/x-www-form-urlencoded"})
        public Token requestToken(@FormParam(value="grant_type") String var1);
    }

    public static interface RequestRefreshToken
    extends Closeable {
        @POST
        @Produces(value={"application/x-www-form-urlencoded"})
        public Token requestToken(@FormParam(value="grant_type") String var1, @FormParam(value="refresh_token") String var2);
    }
}

