/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.portal.authentication.oauth.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import de.cuioss.portal.authentication.AuthenticatedUserInfo;
import de.cuioss.portal.authentication.facade.AuthenticationSource;
import de.cuioss.portal.authentication.facade.BaseAuthenticationFacade;
import de.cuioss.portal.authentication.facade.PortalAuthenticationFacade;
import de.cuioss.portal.authentication.model.BaseAuthenticatedUserInfo;
import de.cuioss.portal.authentication.oauth.LoginPagePath;
import de.cuioss.portal.authentication.oauth.Oauth2AuthenticationFacade;
import de.cuioss.portal.authentication.oauth.Oauth2Configuration;
import de.cuioss.portal.authentication.oauth.Oauth2Service;
import de.cuioss.portal.authentication.oauth.OauthAuthenticationException;
import de.cuioss.portal.authentication.oauth.OauthRedirector;
import de.cuioss.portal.authentication.oauth.OidcRpInitiatedLogoutParams;
import de.cuioss.portal.authentication.oauth.Token;
import de.cuioss.portal.authentication.oauth.impl.OauthAuthenticatedUserInfo;
import de.cuioss.tools.collect.CollectionBuilder;
import de.cuioss.tools.logging.CuiLogger;
import de.cuioss.tools.net.UrlParameter;
import de.cuioss.tools.string.MoreStrings;
import de.cuioss.tools.string.Splitter;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@PortalAuthenticationFacade
@ApplicationScoped
public class Oauth2AuthenticationFacadeImpl
extends BaseAuthenticationFacade
implements Serializable,
Oauth2AuthenticationFacade {
    private static final CuiLogger LOGGER = new CuiLogger(Oauth2AuthenticationFacadeImpl.class);
    private static final String ERROR_ACCESS_DENIED = "access_denied";
    private static final String ERROR_INVALID_SCOPE = "invalid_scope";
    private static final long serialVersionUID = -7635870199193359039L;
    private static final String AUTHENTICATED_USER_INFO_KEY = "AuthenticatedUserInfo";
    private static final String STATE_KEY = "State";
    private static final String NONCE_KEY = "Nonce";
    private static final String SCOPES_KEY = "Scopes";
    private static final String PKCE_CODE_KEY = "PKCE_CODE";
    private final transient Object codeLock = new Object();
    private static final AuthenticatedUserInfo NOT_LOGGED_IN = BaseAuthenticatedUserInfo.builder().authenticated(false).build();
    @Inject
    private Oauth2Service oauth2ServiceImpl;
    @Inject
    private Provider<Oauth2Configuration> configurationProvider;
    @Inject
    @LoginPagePath
    private Provider<String> loginUrl;
    @Inject
    private Provider<OauthRedirector> oauthRedirector;
    @Inject
    private Provider<HttpServletRequest> servletRequestProvider;
    private final SecureRandom random = new SecureRandom();

    public boolean logout(HttpServletRequest servletRequest) {
        HttpSession currentSession = servletRequest.getSession(false);
        if (null != currentSession) {
            currentSession.invalidate();
        }
        return true;
    }

    public AuthenticatedUserInfo retrieveCurrentAuthenticationContext(HttpServletRequest servletRequest) {
        Optional<OauthAuthenticatedUserInfo> currentUser = Oauth2AuthenticationFacadeImpl.retrieveCurrentUserIfPresent(servletRequest);
        return currentUser.orElse(new OauthAuthenticatedUserInfo(NOT_LOGGED_IN));
    }

    @Override
    public AuthenticatedUserInfo testLogin(List<UrlParameter> parameters, String scopes) {
        Optional<AuthenticatedUserInfo> result = this.triggerAuthenticate(parameters, scopes);
        return result.orElse(NOT_LOGGED_IN);
    }

    @Override
    public void invalidateToken() {
        Optional<OauthAuthenticatedUserInfo> currentUser = Oauth2AuthenticationFacadeImpl.retrieveCurrentUserIfPresent((HttpServletRequest)this.servletRequestProvider.get());
        currentUser.ifPresent(oauthAuthenticatedUserInfo -> oauthAuthenticatedUserInfo.getToken().setAccess_token(null));
    }

    @Override
    public void sendRedirect(String scopes) {
        Objects.requireNonNull(MoreStrings.emptyToNull((String)scopes));
        this.sendRedirect(scopes, null);
    }

    @Override
    public void sendRedirect() {
        this.sendRedirect((String)((HttpServletRequest)this.servletRequestProvider.get()).getSession().getAttribute(SCOPES_KEY), null);
    }

    private void sendRedirect(String scopes, String idToken) {
        try {
            String retrieveUrl = this.retrieveOauth2RedirectUrl(scopes, idToken);
            LOGGER.debug("Calling redirect to %s", new Object[]{retrieveUrl});
            ((OauthRedirector)this.oauthRedirector.get()).sendRedirect(retrieveUrl);
        }
        catch (IllegalStateException e) {
            LOGGER.warn("Portal-146: Oauth2 sendRedirect failed", (Throwable)e);
        }
    }

    private Optional<AuthenticatedUserInfo> triggerAuthenticate(List<UrlParameter> parameters, String scopes) {
        Optional<UrlParameter> code = parameters.stream().filter(parameter -> "code".equals(parameter.getName())).findAny();
        Optional<UrlParameter> state = parameters.stream().filter(parameter -> "state".equals(parameter.getName())).findAny();
        Optional<UrlParameter> error = parameters.stream().filter(parameter -> "error".equals(parameter.getName())).findAny();
        if (state.isPresent()) {
            if (code.isPresent()) {
                return this.handleTriggerAuthenticate(scopes, code.get(), state.get());
            }
            if (error.isPresent()) {
                LOGGER.debug("state and error {} parameter are present", new Object[]{error.get().getValue()});
                if (ERROR_ACCESS_DENIED.equals(error.get().getValue())) {
                    throw new OauthAuthenticationException("system.exception.oauth.consent");
                }
                if (ERROR_INVALID_SCOPE.equals(error.get().getValue())) {
                    LOGGER.warn("invalid_scope: {}", new Object[]{parameters});
                    throw new OauthAuthenticationException("system.exception.oauth.invalidScope");
                }
                LOGGER.warn("Portal-147: Oauth2 login error: {}", new Object[]{parameters});
                throw new OauthAuthenticationException("system.exception.oauth.login");
            }
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<AuthenticatedUserInfo> handleTriggerAuthenticate(String scopes, UrlParameter code, UrlParameter state) {
        String codeVerifier;
        AuthenticatedUserInfo sessionUser;
        HttpServletRequest servletRequest = (HttpServletRequest)this.servletRequestProvider.get();
        LOGGER.debug("code and state parameter are present");
        Object object = this.codeLock;
        synchronized (object) {
            if (null == servletRequest.getSession().getAttribute(STATE_KEY)) {
                LOGGER.warn("Portal-148: Oauth2 unexpected login call with unknown state {}, redirecting to login", new Object[]{state.getValue()});
                return Optional.empty();
            }
            if (state.getValue().equals(servletRequest.getSession().getAttribute(STATE_KEY))) {
                LOGGER.debug("state parameter matches stored value");
                sessionUser = (AuthenticatedUserInfo)servletRequest.getSession().getAttribute(AUTHENTICATED_USER_INFO_KEY);
            } else {
                LOGGER.debug("state parameter {} differs from stored value {}", new Object[]{state.getValue(), servletRequest.getSession().getAttribute(STATE_KEY)});
                sessionUser = null;
            }
            servletRequest.getSession().removeAttribute(STATE_KEY);
        }
        String retrievedScoped = (String)servletRequest.getSession().getAttribute(SCOPES_KEY);
        if (null == retrievedScoped) {
            retrievedScoped = scopes;
        }
        Object object2 = this.codeLock;
        synchronized (object2) {
            codeVerifier = (String)servletRequest.getSession().getAttribute(PKCE_CODE_KEY);
            servletRequest.getSession().removeAttribute(PKCE_CODE_KEY);
        }
        LOGGER.trace("handleTriggerAuthenticate codeVerifier: {}", new Object[]{codeVerifier});
        AuthenticatedUserInfo oauthUser = this.oauth2ServiceImpl.createAuthenticatedUserInfo(servletRequest, code, state, retrievedScoped, codeVerifier);
        if (null != oauthUser) {
            LOGGER.debug("authenticated oauth user info was retrieved: {}", new Object[]{oauthUser});
            if (null == sessionUser || !sessionUser.isAuthenticated()) {
                LOGGER.debug("session user missing or not authenticated. invalidating session! (change session after login)");
                servletRequest.getSession().invalidate();
            }
            oauthUser = this.enrich(oauthUser);
            LOGGER.debug("adding oauth user to (new) session.");
            servletRequest.getSession().setAttribute(AUTHENTICATED_USER_INFO_KEY, (Object)oauthUser);
            return Optional.of(oauthUser);
        }
        LOGGER.debug("unable to retrieve authenticated user info");
        throw new OauthAuthenticationException("system.exception.oauth.login");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String retrieveOauth2RedirectUrl(String scopes, String idToken) {
        MessageDigest digest;
        HttpServletRequest servletRequest = (HttpServletRequest)this.servletRequestProvider.get();
        Objects.requireNonNull(MoreStrings.emptyToNull((String)scopes));
        Object object = this.codeLock;
        synchronized (object) {
            if (null == servletRequest.getSession().getAttribute(STATE_KEY)) {
                servletRequest.getSession().setAttribute(STATE_KEY, (Object)new BigInteger(130, this.random).toString(32));
            }
        }
        String state = (String)servletRequest.getSession().getAttribute(STATE_KEY);
        String nonce = new BigInteger(130, this.random).toString(32);
        servletRequest.getSession().setAttribute(NONCE_KEY, (Object)nonce);
        servletRequest.getSession().setAttribute(SCOPES_KEY, (Object)scopes);
        Object object2 = this.codeLock;
        synchronized (object2) {
            if (null == servletRequest.getSession().getAttribute(PKCE_CODE_KEY)) {
                servletRequest.getSession().setAttribute(PKCE_CODE_KEY, (Object)new BigInteger(260, this.random).toString(32));
                LOGGER.trace("retrieveOauth2RedirectUrl ---- NEW CODE");
            }
        }
        String code = (String)servletRequest.getSession().getAttribute(PKCE_CODE_KEY);
        LOGGER.trace("retrieveOauth2RedirectUrl code: {}", new Object[]{code});
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error((Throwable)e, "Cannot generate code_challenge", new Object[0]);
            throw new IllegalStateException(e);
        }
        String code_challenge = Base64.getUrlEncoder().withoutPadding().encodeToString(digest.digest(code.getBytes(StandardCharsets.US_ASCII)));
        LOGGER.trace("retrieveOauth2RedirectUrl code_challenge: {}", new Object[]{code_challenge});
        String scopesParameter = URLEncoder.encode(scopes, StandardCharsets.UTF_8);
        Oauth2Configuration configuration = (Oauth2Configuration)this.configurationProvider.get();
        String url = configuration.getAuthorizeUri().trim() + UrlParameter.createParameterString((boolean)false, (UrlParameter[])new UrlParameter[]{new UrlParameter("response_type", "code", false), new UrlParameter("scope", scopesParameter, false), new UrlParameter("client_id", configuration.getClientId().trim(), false), new UrlParameter("state", state, false), new UrlParameter("nonce", nonce, false), new UrlParameter("code_challenge", code_challenge, false), new UrlParameter("code_challenge_method", "S256", false), new UrlParameter("id_token_hint", idToken, false), new UrlParameter("redirect_uri", this.oauth2ServiceImpl.calcEncodedRedirectUrl(servletRequest.getContextPath() + (String)this.loginUrl.get()), false)});
        LOGGER.debug("redirect url = {}", new Object[]{url});
        return url;
    }

    @Override
    public String retrieveOauth2RenewUrl() {
        HttpServletRequest servletRequest = (HttpServletRequest)this.servletRequestProvider.get();
        Optional<OauthAuthenticatedUserInfo> currentUser = Oauth2AuthenticationFacadeImpl.retrieveCurrentUserIfPresent(servletRequest);
        if (currentUser.isPresent()) {
            Token token = currentUser.get().getToken();
            String scopes = (String)servletRequest.getSession().getAttribute(SCOPES_KEY);
            if (MoreStrings.isEmpty((CharSequence)scopes)) {
                scopes = currentUser.get().getScopes();
            }
            if (MoreStrings.isEmpty((CharSequence)scopes)) {
                return null;
            }
            if (token != null && Oauth2AuthenticationFacadeImpl.checkToken(token, currentUser.get().getTokenTimestamp())) {
                return this.retrieveOauth2RedirectUrl(scopes, token.getId_token()) + "&prompt=none&response_mode=cors";
            }
            return this.retrieveOauth2RedirectUrl(scopes, null);
        }
        return null;
    }

    @Override
    public String retrieveToken(String scopes) {
        Objects.requireNonNull(MoreStrings.emptyToNull((String)((String)this.loginUrl.get())));
        Objects.requireNonNull(MoreStrings.emptyToNull((String)scopes));
        LOGGER.trace("retrieveToken for scopes: {}", new Object[]{scopes});
        Optional<OauthAuthenticatedUserInfo> currentUser = Oauth2AuthenticationFacadeImpl.retrieveCurrentUserIfPresent((HttpServletRequest)this.servletRequestProvider.get());
        String idToken = null;
        if (currentUser.isPresent()) {
            LOGGER.debug("we have a user");
            String accessToken = this.checkAndRetrieveToken(currentUser.get(), scopes);
            if (null != accessToken) {
                LOGGER.debug("accessToken present. returning accessToken.");
                return accessToken;
            }
            Token token = currentUser.get().getToken();
            if (token != null) {
                LOGGER.debug("CUI Token present. extracting idToken.");
                idToken = token.getId_token();
            } else {
                LOGGER.debug("No CUI Token available. Cannot set idToken.");
            }
        }
        LOGGER.debug("accessToken not present, redirecting to oauth server using idToken={}.", new Object[]{null != idToken});
        LOGGER.trace("using idToken: {}", new Object[]{idToken});
        this.sendRedirect(scopes, idToken);
        return null;
    }

    @Override
    public String retrieveClientToken(String scopes) {
        return this.oauth2ServiceImpl.retrieveClientToken(scopes);
    }

    @Override
    public String retrieveToken(AuthenticatedUserInfo currentUser, String scopes) {
        Objects.requireNonNull(currentUser);
        Objects.requireNonNull(MoreStrings.emptyToNull((String)scopes));
        OauthAuthenticatedUserInfo oauthAuthenticatedUser = new OauthAuthenticatedUserInfo(currentUser);
        return this.checkAndRetrieveToken(oauthAuthenticatedUser, scopes);
    }

    @Override
    public Map<String, Object> retrieveIdToken(AuthenticatedUserInfo currentUser) {
        Token token = new OauthAuthenticatedUserInfo(currentUser).getToken();
        if (null == token || MoreStrings.isEmpty((CharSequence)token.getId_token())) {
            return Collections.emptyMap();
        }
        String[] tokenParts = token.getId_token().split("\\.");
        if (tokenParts.length != 3) {
            LOGGER.info("idToken can not be splitted: {}", new Object[]{token.getId_token()});
            return Collections.emptyMap();
        }
        ObjectReader objectReader = new ObjectMapper().reader().forType((TypeReference)new TypeReference<Map<String, Object>>(){});
        try {
            return (Map)objectReader.readValue(Base64.getDecoder().decode(tokenParts[1]));
        }
        catch (IOException e) {
            LOGGER.info((Throwable)e, "idToken {} can not be parsed", new Object[]{tokenParts[1]});
            return Collections.emptyMap();
        }
    }

    private static Optional<OauthAuthenticatedUserInfo> retrieveCurrentUserIfPresent(HttpServletRequest servletRequest) {
        HttpSession session = servletRequest.getSession(false);
        if (null != session) {
            try {
                return Optional.ofNullable(OauthAuthenticatedUserInfo.createOf((AuthenticatedUserInfo)session.getAttribute(AUTHENTICATED_USER_INFO_KEY)));
            }
            catch (IllegalStateException e) {
                LOGGER.debug("getAttribute failed: ", (Throwable)e);
            }
        }
        return Optional.empty();
    }

    @Override
    public String retrieveRenewInterval() {
        Optional<OauthAuthenticatedUserInfo> currentUser = Oauth2AuthenticationFacadeImpl.retrieveCurrentUserIfPresent((HttpServletRequest)this.servletRequestProvider.get());
        if (currentUser.isPresent()) {
            try {
                int interval = currentUser.get().getTokenTimestamp() - (int)(System.currentTimeMillis() / 1000L) + Integer.parseInt(currentUser.get().getToken().getExpires_in()) - 10;
                return String.valueOf(interval);
            }
            catch (NumberFormatException e) {
                LOGGER.debug("token.expires_in not a valid number", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public AuthenticatedUserInfo refreshUserinfo() {
        Token token;
        Optional<OauthAuthenticatedUserInfo> currentUser = Oauth2AuthenticationFacadeImpl.retrieveCurrentUserIfPresent((HttpServletRequest)this.servletRequestProvider.get());
        if (currentUser.isPresent() && null != (token = currentUser.get().getToken())) {
            return this.oauth2ServiceImpl.retrieveAuthenticatedUser(currentUser.get().getScopes(), token, currentUser.get().getTokenTimestamp());
        }
        return null;
    }

    @Override
    public String getLoginUrl() {
        return (String)this.loginUrl.get();
    }

    @Override
    public String retrieveClientLogoutUrl(Set<UrlParameter> additionalUrlParams) {
        Oauth2Configuration config = (Oauth2Configuration)this.configurationProvider.get();
        if (MoreStrings.isEmpty((CharSequence)config.getLogoutUri())) {
            String errMsg = "Portal-160: Missing config for logout URI. Check the end_session_endpoint property from userinfo endpoint.".formatted(new Object[0]);
            LOGGER.warn(errMsg);
            throw new IllegalStateException(errMsg);
        }
        CollectionBuilder queryParams = CollectionBuilder.copyFrom(additionalUrlParams);
        if (config.isLogoutWithIdTokenHintEnabled() && queryParams.stream().map(UrlParameter::getName).noneMatch("id_token_hint"::equals)) {
            LOGGER.debug("Adding id-token-hint as recommended by spec.");
            this.getIdTokenFromCurrentUser().map(OidcRpInitiatedLogoutParams::getIdTokenHintUrlParam).ifPresent(arg_0 -> ((CollectionBuilder)queryParams).add(arg_0));
        }
        String logoutUrl = config.getLogoutUri() + UrlParameter.createParameterString((UrlParameter[])((UrlParameter[])queryParams.toArray(UrlParameter.class)));
        LOGGER.trace("logoutUrl: {}", new Object[]{logoutUrl});
        return logoutUrl;
    }

    private Optional<String> getIdTokenFromCurrentUser() {
        Optional<OauthAuthenticatedUserInfo> currentUser = Oauth2AuthenticationFacadeImpl.retrieveCurrentUserIfPresent((HttpServletRequest)this.servletRequestProvider.get());
        if (currentUser.isPresent()) {
            return currentUser.get().getIdToken();
        }
        LOGGER.warn("could not get id-token. no user context available.");
        return Optional.empty();
    }

    private String checkAndRetrieveToken(OauthAuthenticatedUserInfo currentUser, String scopes) {
        Token token = currentUser.getToken();
        if (Oauth2AuthenticationFacadeImpl.checkToken(token, currentUser.getTokenTimestamp())) {
            LOGGER.debug("token is valid.");
            boolean allFound = true;
            List existing = Splitter.on((char)' ').omitEmptyStrings().splitToList(currentUser.getScopes());
            for (String requested : Splitter.on((char)' ').omitEmptyStrings().splitToList(scopes)) {
                if (existing.contains(requested)) continue;
                allFound = false;
                LOGGER.debug("Missing scope: {}", new Object[]{requested});
                break;
            }
            if (allFound) {
                return token.getAccess_token();
            }
        } else if (!MoreStrings.isEmpty((CharSequence)token.getRefresh_token())) {
            LOGGER.debug("AccessToken expired, but RefreshToken present; trying to use it to get a new access token");
            return this.oauth2ServiceImpl.refreshToken(currentUser);
        }
        return null;
    }

    private static boolean checkToken(Token token, Integer timestamp) {
        if (null == token) {
            return false;
        }
        if (MoreStrings.isEmpty((CharSequence)token.getExpires_in())) {
            LOGGER.trace("token has no expiration. token is valid!");
            return true;
        }
        try {
            int expires = timestamp + Integer.parseInt(token.getExpires_in()) - 10;
            boolean valid = expires > (int)(System.currentTimeMillis() / 1000L);
            LOGGER.trace("checked expire time. token valid?: {}", new Object[]{valid});
            return valid;
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Portal-149: Oauth2 token.expires_in not a valid number", (Throwable)e);
            return false;
        }
    }

    public AuthenticationSource getAuthenticationSource() {
        return AuthenticationSource.OPEN_ID_CONNECT;
    }
}

