/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.portal.authentication.dummy;

import de.cuioss.portal.authentication.AuthenticatedUserInfo;
import de.cuioss.portal.authentication.facade.AuthenticationResults;
import de.cuioss.portal.authentication.facade.AuthenticationSource;
import de.cuioss.portal.authentication.facade.FormBasedAuthenticationFacade;
import de.cuioss.portal.authentication.facade.PortalAuthenticationFacade;
import de.cuioss.portal.authentication.model.BaseAuthenticatedUserInfo;
import de.cuioss.portal.authentication.model.UserStore;
import de.cuioss.tools.logging.CuiLogger;
import de.cuioss.uimodel.application.LoginCredentials;
import de.cuioss.uimodel.result.ResultObject;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

@PortalAuthenticationFacade
@ApplicationScoped
public class DummyAuthenticationFacade
implements FormBasedAuthenticationFacade {
    private static final String DUMMY = "dummy";
    private static final CuiLogger log = new CuiLogger(DummyAuthenticationFacade.class);
    static final AuthenticatedUserInfo NOT_LOGGED_IN = new BaseAuthenticatedUserInfo(false, "dummy", "dummy", "dummy", "dummy");
    private AuthenticationSource authenticationSource = AuthenticationSource.DUMMY;

    public ResultObject<AuthenticatedUserInfo> login(HttpServletRequest servletRequest, LoginCredentials loginCredentials) {
        log.debug("Login called");
        return AuthenticationResults.validResult((AuthenticatedUserInfo)NOT_LOGGED_IN);
    }

    public boolean logout(HttpServletRequest servletRequest) {
        log.debug("Logout called");
        return false;
    }

    public AuthenticatedUserInfo retrieveCurrentAuthenticationContext(HttpServletRequest servletRequest) {
        log.debug("retrieveCurrentAuthenticationContext called");
        return NOT_LOGGED_IN;
    }

    public List<UserStore> getAvailableUserStores() {
        log.debug("getAvailableUserStores called");
        return Collections.emptyList();
    }

    @Generated
    public AuthenticationSource getAuthenticationSource() {
        return this.authenticationSource;
    }

    @Generated
    public void setAuthenticationSource(AuthenticationSource authenticationSource) {
        this.authenticationSource = authenticationSource;
    }
}

