/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.tools.reflect;

import de.cuioss.tools.base.Preconditions;
import de.cuioss.tools.collect.CollectionBuilder;
import de.cuioss.tools.collect.MoreCollections;
import de.cuioss.tools.logging.CuiLogger;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.WeakHashMap;
import lombok.Generated;

public final class MoreReflection {
    @Generated
    private static final Object $LOCK = new Object[0];
    private static final String IGNORING_METHOD_ON_CLASS = "Ignoring method '{}' on class '{}'";
    private static final CuiLogger LOGGER = new CuiLogger(MoreReflection.class);
    private static final Map<Class<?>, List<Method>> publicObjectMethodCache = new WeakHashMap();
    private static final Map<Class<?>, Map<String, Field>> fieldCache = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<Field> accessField(Class<?> type, String fieldName) {
        Object object = $LOCK;
        synchronized (object) {
            Map<String, Field> typeMap;
            Objects.requireNonNull(type);
            Objects.requireNonNull(fieldName);
            if (!fieldCache.containsKey(type)) {
                fieldCache.put(type, new HashMap());
            }
            if (!(typeMap = fieldCache.get(type)).containsKey(fieldName)) {
                typeMap.put(fieldName, MoreReflection.resolveField(type, fieldName).orElse(null));
            }
            return Optional.ofNullable(typeMap.get(fieldName));
        }
    }

    private static Optional<Field> resolveField(Class<?> type, String fieldName) {
        try {
            return Optional.of(type.getDeclaredField(fieldName));
        }
        catch (NoSuchFieldException | SecurityException e) {
            LOGGER.debug("No field found for name '%s' on class '%s'", fieldName, type);
            if (Object.class.equals(type.getClass()) || null == type.getSuperclass()) {
                return Optional.empty();
            }
            return MoreReflection.resolveField(type.getSuperclass(), fieldName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Method> retrievePublicObjectMethods(Class<?> clazz) {
        Object object = $LOCK;
        synchronized (object) {
            Objects.requireNonNull(clazz);
            if (!publicObjectMethodCache.containsKey(clazz)) {
                ArrayList<Method> found = new ArrayList<Method>();
                for (Method method : clazz.getMethods()) {
                    int modifiers = method.getModifiers();
                    if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers) || "getClass".equals(method.getName())) continue;
                    found.add(method);
                }
                publicObjectMethodCache.put(clazz, found);
                return found;
            }
            return publicObjectMethodCache.get(clazz);
        }
    }

    public static List<Method> retrieveAccessMethods(Class<?> clazz) {
        ArrayList<Method> found = new ArrayList<Method>();
        for (Method method : MoreReflection.retrievePublicObjectMethods(clazz)) {
            if (0 == method.getParameterCount()) {
                String name = method.getName();
                if (!name.startsWith("get") && !name.startsWith("is")) continue;
                LOGGER.debug("Adding found method '{}' on class '{}'", name, clazz);
                found.add(method);
                continue;
            }
            LOGGER.trace(IGNORING_METHOD_ON_CLASS, method.getName(), clazz);
        }
        return found;
    }

    public static List<Method> retrieveAccessMethods(Class<?> clazz, Collection<String> ignoreProperties) {
        ArrayList<Method> found = new ArrayList<Method>();
        for (Method method : MoreReflection.retrieveAccessMethods(clazz)) {
            String propertyName = MoreReflection.computePropertyNameFromMethodName(method.getName());
            if (ignoreProperties.contains(propertyName)) continue;
            found.add(method);
        }
        return found;
    }

    public static Optional<Method> retrieveWriteMethod(Class<?> clazz, String propertyName, Class<?> parameterType) {
        Objects.requireNonNull(parameterType);
        for (Method method : MoreReflection.retrieveWriteMethodCandidates(clazz, propertyName)) {
            if (MoreReflection.checkWhetherParameterIsAssignable(method.getParameterTypes()[0], parameterType)) {
                return Optional.of(method);
            }
            LOGGER.trace(IGNORING_METHOD_ON_CLASS, method.getName(), clazz);
        }
        return Optional.empty();
    }

    public static boolean checkWhetherParameterIsAssignable(Class<?> assignableSource, Class<?> queryType) {
        Class<?> boxedQuery;
        Objects.requireNonNull(assignableSource);
        Objects.requireNonNull(queryType);
        if (assignableSource.equals(queryType)) {
            LOGGER.trace("Parameter-type matches exactly '%s'", assignableSource);
            return true;
        }
        if (assignableSource.isAssignableFrom(queryType)) {
            LOGGER.trace("Parameter '%s' is assignable from '%s'", assignableSource, queryType);
            return true;
        }
        Class<?> boxedSource = MoreReflection.resolveWrapperTypeForPrimitive(assignableSource);
        if (boxedSource.equals(boxedQuery = MoreReflection.resolveWrapperTypeForPrimitive(queryType))) {
            LOGGER.trace("Parameter-type matches exactly after autoboxing '%s'", assignableSource);
            return true;
        }
        return boxedSource.isAssignableFrom(boxedQuery);
    }

    static Class<?> resolveWrapperTypeForPrimitive(Class<?> check) {
        if (!check.isPrimitive()) {
            return check;
        }
        return switch (check.getName()) {
            case "boolean" -> Boolean.class;
            case "byte" -> Byte.class;
            case "char" -> Character.class;
            case "short" -> Short.class;
            case "int" -> Integer.class;
            case "long" -> Long.class;
            case "double" -> Double.class;
            case "float" -> Float.class;
            default -> {
                LOGGER.warn("Unable to determine wrapper type for '{}', ", check);
                yield check;
            }
        };
    }

    public static Collection<Method> retrieveWriteMethodCandidates(Class<?> clazz, String propertyName) {
        MoreCollections.requireNotEmpty(propertyName);
        CollectionBuilder<Method> builder = new CollectionBuilder<Method>();
        for (Method method : MoreReflection.retrievePublicObjectMethods(clazz)) {
            if (1 == method.getParameterCount()) {
                String name = method.getName();
                if (propertyName.equals(name)) {
                    LOGGER.debug("Returning found method '{}' on class '{}'", name, clazz);
                    builder.add(method);
                }
                if (!name.startsWith("set") || !MoreReflection.computePropertyNameFromMethodName(name).equalsIgnoreCase(propertyName)) continue;
                LOGGER.debug("Returning found method '{}' on class '{}'", name, clazz);
                builder.add(method);
                continue;
            }
            LOGGER.trace(IGNORING_METHOD_ON_CLASS, method.getName(), clazz);
        }
        return builder.toImmutableList();
    }

    public static Optional<Method> retrieveAccessMethod(Class<?> clazz, String propertyName) {
        MoreCollections.requireNotEmpty(propertyName);
        for (Method method : MoreReflection.retrieveAccessMethods(clazz)) {
            if (!MoreReflection.computePropertyNameFromMethodName(method.getName()).equalsIgnoreCase(propertyName)) continue;
            return Optional.of(method);
        }
        return Optional.empty();
    }

    public static String computePropertyNameFromMethodName(String methodName) {
        MoreCollections.requireNotEmpty(methodName);
        if (methodName.startsWith("get") || methodName.startsWith("set")) {
            if (methodName.length() > 3) {
                return methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
            }
            LOGGER.debug("Name to short for extracting attributeName '{}'", methodName);
        }
        if (methodName.startsWith("is")) {
            if (methodName.length() > 2) {
                return methodName.substring(2, 3).toLowerCase() + methodName.substring(3);
            }
            LOGGER.debug("Name to short for extracting attributeName '{}'", methodName);
        }
        return methodName;
    }

    public static <A extends Annotation> List<A> extractAllAnnotations(Class<?> annotatedType, Class<A> annotation) {
        if (null == annotatedType || Object.class.equals(annotatedType.getClass())) {
            return Collections.emptyList();
        }
        CollectionBuilder<Annotation> builder = new CollectionBuilder<Annotation>();
        builder.add(annotatedType.getAnnotationsByType(annotation));
        builder.add((Collection<Annotation>)MoreReflection.extractAllAnnotations(annotatedType.getSuperclass(), annotation));
        return builder.toImmutableList();
    }

    public static <A extends Annotation> Optional<A> extractAnnotation(Class<?> annotatedType, Class<A> annotation) {
        Objects.requireNonNull(annotation);
        List<A> extracted = MoreReflection.extractAllAnnotations(annotatedType, annotation);
        if (extracted.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((Annotation)extracted.iterator().next());
    }

    public static <T> Class<T> extractFirstGenericTypeArgument(Class<?> typeToBeExtractedFrom) {
        ParameterizedType parameterizedType = MoreReflection.extractParameterizedType(typeToBeExtractedFrom).orElseThrow(() -> new IllegalArgumentException("Given type defines no generic KeyStoreType: " + String.valueOf(typeToBeExtractedFrom)));
        MoreCollections.requireNotEmpty(parameterizedType.getActualTypeArguments(), "No type argument found for " + typeToBeExtractedFrom.getName());
        Class<?> firstType = MoreReflection.extractGenericTypeCovariantly(parameterizedType.getActualTypeArguments()[0]).orElseThrow(() -> new IllegalArgumentException("Unable to determine genric type for " + String.valueOf(typeToBeExtractedFrom)));
        try {
            return firstType;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("No type argument can be extracted from " + typeToBeExtractedFrom.getName(), e);
        }
    }

    public static Optional<Class<?>> extractGenericTypeCovariantly(Type type) {
        if (null == type) {
            LOGGER.trace("No KeyStoreType given, returning empty");
            return Optional.empty();
        }
        if (type instanceof Class) {
            Class class1 = (Class)type;
            LOGGER.debug("Found actual class returning as result {}", type);
            return Optional.of(class1);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            LOGGER.debug("found Parameterized type, for {}, calling recursively", type);
            return MoreReflection.extractGenericTypeCovariantly(parameterizedType.getRawType());
        }
        LOGGER.warn("Unable to determines generic-type for {}", type);
        return Optional.empty();
    }

    public static Optional<ParameterizedType> extractParameterizedType(Class<?> typeToBeExtractedFrom) {
        LOGGER.debug("Extracting ParameterizedType from {}", typeToBeExtractedFrom);
        if (null == typeToBeExtractedFrom) {
            return Optional.empty();
        }
        if (Object.class.equals(typeToBeExtractedFrom)) {
            LOGGER.debug("java.lang.Object is not a ParameterizedType");
            return Optional.empty();
        }
        Type genericSuperclass = typeToBeExtractedFrom.getGenericSuperclass();
        if (genericSuperclass instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)genericSuperclass;
            return Optional.of(type);
        }
        return MoreReflection.extractParameterizedType(typeToBeExtractedFrom.getSuperclass());
    }

    public static String getPackageName(Class<?> clazz) {
        String className = clazz.getName();
        int lastDotIndex = className.lastIndexOf(46);
        return lastDotIndex != -1 ? className.substring(0, lastDotIndex) : "";
    }

    public static <T> T newProxy(Class<T> interfaceType, InvocationHandler handler) {
        Objects.requireNonNull(handler);
        Preconditions.checkArgument(interfaceType.isInterface(), "%s is not an interface", interfaceType);
        Object object = Proxy.newProxyInstance(interfaceType.getClassLoader(), new Class[]{interfaceType}, handler);
        return interfaceType.cast(object);
    }

    public static Optional<String> findCaller(Collection<String> markerClasses) {
        Optional<StackTraceElement> callerElement = MoreReflection.findCallerElement(null, markerClasses);
        return callerElement.map(StackTraceElement::getClassName);
    }

    public static Optional<StackTraceElement> findCallerElement(Throwable throwable, Collection<String> markerClasses) {
        Objects.requireNonNull(markerClasses, "Marker class names are missing");
        StackTraceElement[] stackTraceElements = null == throwable ? Thread.currentThread().getStackTrace() : throwable.getStackTrace();
        if (null == stackTraceElements || stackTraceElements.length < 5) {
            return Optional.empty();
        }
        for (int index = 2; index < stackTraceElements.length; ++index) {
            StackTraceElement element = stackTraceElements[index];
            if (!markerClasses.contains(element.getClassName())) continue;
            if (stackTraceElements.length > index + 1) {
                return Optional.of(stackTraceElements[index + 1]);
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    @Generated
    private MoreReflection() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

