/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.tools.property;

import de.cuioss.tools.lang.MoreObjects;
import de.cuioss.tools.logging.CuiLogger;
import de.cuioss.tools.reflect.MoreReflection;
import java.beans.PropertyDescriptor;
import java.util.Objects;
import lombok.Generated;

public enum PropertyReadWrite {
    READ_ONLY(true, false),
    READ_WRITE(true, true),
    WRITE_ONLY(false, true),
    NONE(false, false);

    private static final CuiLogger LOGGER;
    private final boolean readable;
    private final boolean writeable;

    public static PropertyReadWrite resolveForBean(Class<?> beanType, String propertyName) {
        boolean writeable;
        boolean readable = MoreReflection.retrieveAccessMethod(beanType, propertyName).isPresent();
        boolean bl = writeable = !MoreReflection.retrieveWriteMethodCandidates(beanType, propertyName).isEmpty();
        if (readable && writeable) {
            return READ_WRITE;
        }
        if (readable) {
            return READ_ONLY;
        }
        if (writeable) {
            return WRITE_ONLY;
        }
        return NONE;
    }

    public static PropertyReadWrite fromPropertyDescriptor(PropertyDescriptor descriptor, Class<?> beanType, String propertyName) {
        Objects.requireNonNull(descriptor);
        if (MoreObjects.allNonNull(descriptor.getReadMethod(), descriptor.getWriteMethod())) {
            return READ_WRITE;
        }
        LOGGER.debug("PropertyDescriptor '%s' does not describe a standard bean-structure for property '%s' on type '%s', switching to reflection", descriptor, propertyName, beanType);
        return PropertyReadWrite.resolveForBean(beanType, propertyName);
    }

    @Generated
    private PropertyReadWrite(boolean readable, boolean writeable) {
        this.readable = readable;
        this.writeable = writeable;
    }

    @Generated
    public boolean isReadable() {
        return this.readable;
    }

    @Generated
    public boolean isWriteable() {
        return this.writeable;
    }

    static {
        LOGGER = new CuiLogger(PropertyReadWrite.class);
    }
}

