/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.tools.net.http;

import de.cuioss.tools.collect.CollectionLiterals;
import de.cuioss.tools.logging.CuiLogger;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import lombok.Generated;

public class SecureSSLContextProvider {
    private static final CuiLogger LOGGER = new CuiLogger(SecureSSLContextProvider.class);
    public static final String TLS_V1_2 = "TLSv1.2";
    public static final String TLS_V1_3 = "TLSv1.3";
    public static final String TLS = "TLS";
    public static final String DEFAULT_TLS_VERSION = "TLSv1.2";
    public static final String TLS_V1_0 = "TLSv1.0";
    public static final String TLS_V1_1 = "TLSv1.1";
    public static final String SSL_V3 = "SSLv3";
    public static final Set<String> ALLOWED_TLS_VERSIONS = CollectionLiterals.immutableSet("TLSv1.2", "TLSv1.3", "TLS");
    public static final Set<String> FORBIDDEN_TLS_VERSIONS = CollectionLiterals.immutableSet("TLSv1.0", "TLSv1.1", "SSLv3");
    private final String minimumTlsVersion;
    private static final String DEBUG_SSL_CONTEXT_PROTOCOL = "Provided SSL context uses protocol: %s";
    private static final String DEBUG_USING_SSL_CONTEXT = "Using provided SSL context with protocol: %s";
    private static final String WARN_INSECURE_SSL_PROTOCOL = "Provided SSL context uses insecure protocol: %s. Creating a secure context instead.";
    private static final String DEBUG_CREATED_SECURE_CONTEXT = "Created secure SSL context with %s";
    private static final String DEBUG_NO_SSL_CONTEXT = "No SSL context provided, created secure SSL context with %s";

    public SecureSSLContextProvider() {
        this("TLSv1.2");
    }

    public SecureSSLContextProvider(String minimumTlsVersion) {
        if (!ALLOWED_TLS_VERSIONS.contains(minimumTlsVersion)) {
            throw new IllegalArgumentException("Minimum TLS version must be one of the allowed versions: " + String.valueOf(ALLOWED_TLS_VERSIONS));
        }
        this.minimumTlsVersion = minimumTlsVersion;
    }

    public boolean isSecureTlsVersion(String protocol) {
        if (protocol == null) {
            return false;
        }
        if (!ALLOWED_TLS_VERSIONS.contains(protocol)) {
            return false;
        }
        if (TLS_V1_3.equals(this.minimumTlsVersion)) {
            return TLS_V1_3.equals(protocol) || TLS.equals(protocol);
        }
        return true;
    }

    public SSLContext createSecureSSLContext() throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        SSLContext secureContext = SSLContext.getInstance(this.minimumTlsVersion);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)null);
        TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
        secureContext.init(null, trustManagers, new SecureRandom());
        return secureContext;
    }

    public SSLContext getOrCreateSecureSSLContext(SSLContext sslContext) {
        try {
            if (sslContext != null) {
                String protocol = sslContext.getProtocol();
                LOGGER.debug(DEBUG_SSL_CONTEXT_PROTOCOL, protocol);
                if (this.isSecureTlsVersion(protocol)) {
                    LOGGER.debug(DEBUG_USING_SSL_CONTEXT, protocol);
                    return sslContext;
                }
                LOGGER.warn(WARN_INSECURE_SSL_PROTOCOL, protocol);
                SSLContext secureContext = this.createSecureSSLContext();
                LOGGER.debug(DEBUG_CREATED_SECURE_CONTEXT, this.minimumTlsVersion);
                return secureContext;
            }
            SSLContext secureContext = this.createSecureSSLContext();
            LOGGER.debug(DEBUG_NO_SSL_CONTEXT, this.minimumTlsVersion);
            return secureContext;
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            try {
                return sslContext != null ? sslContext : SSLContext.getDefault();
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to create SSL context", ex);
            }
        }
    }

    @Generated
    public String getMinimumTlsVersion() {
        return this.minimumTlsVersion;
    }
}

