/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.tools.net.http;

import lombok.Generated;

public enum HttpStatusFamily {
    INFORMATIONAL(100, 199, "Informational"),
    SUCCESS(200, 299, "Success"),
    REDIRECTION(300, 399, "Redirection"),
    CLIENT_ERROR(400, 499, "Client Error"),
    SERVER_ERROR(500, 599, "Server Error"),
    UNKNOWN(-1, -1, "Unknown");

    private final int minCode;
    private final int maxCode;
    private final String description;

    public boolean contains(int statusCode) {
        if (this == UNKNOWN) {
            return statusCode < 100 || statusCode > 599;
        }
        return statusCode >= this.minCode && statusCode <= this.maxCode;
    }

    public static HttpStatusFamily fromStatusCode(int statusCode) {
        for (HttpStatusFamily family : HttpStatusFamily.values()) {
            if (!family.contains(statusCode)) continue;
            return family;
        }
        return UNKNOWN;
    }

    public static boolean isSuccess(int statusCode) {
        return SUCCESS.contains(statusCode);
    }

    public static boolean isClientError(int statusCode) {
        return CLIENT_ERROR.contains(statusCode);
    }

    public static boolean isServerError(int statusCode) {
        return SERVER_ERROR.contains(statusCode);
    }

    public static boolean isRedirection(int statusCode) {
        return REDIRECTION.contains(statusCode);
    }

    public static boolean isInformational(int statusCode) {
        return INFORMATIONAL.contains(statusCode);
    }

    public static boolean isValid(int statusCode) {
        return statusCode >= 100 && statusCode <= 599;
    }

    public String toString() {
        if (this == UNKNOWN) {
            return this.description;
        }
        return "%s (%d-%d)".formatted(this.description, this.minCode, this.maxCode);
    }

    @Generated
    private HttpStatusFamily(int minCode, int maxCode, String description) {
        this.minCode = minCode;
        this.maxCode = maxCode;
        this.description = description;
    }

    @Generated
    public int getMinCode() {
        return this.minCode;
    }

    @Generated
    public int getMaxCode() {
        return this.maxCode;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

