/**
 * Copyright © 2025 CUI-OpenSource-Software (info@cuioss.de)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Provides classes for template-based text formatting.
 *
 * <h2>Overview</h2>
 * This package contains the core components for template-based formatting:
 * <ul>
 *   <li>{@link de.cuioss.tools.formatting.template.FormatterSupport} - Interface for objects that can be formatted</li>
 *   <li>{@link de.cuioss.tools.formatting.template.TemplateFormatter} - Interface for formatting objects using templates</li>
 *   <li>{@link de.cuioss.tools.formatting.template.TemplateManager} - Manages templates and formatting operations</li>
 * </ul>
 * 
 * <h2>Template Syntax</h2>
 * The template syntax uses square brackets to denote property placeholders:
 * <pre>{@code
 * [propertyName]
 * }</pre>
 * 
 * <h2>Usage Example</h2>
 * <pre>{@code
 * // Example code here
 * }</pre>
 * 
 * @see de.cuioss.tools.formatting.template.FormatterSupport
 * @see de.cuioss.tools.formatting.template.TemplateFormatter
 */
package de.cuioss.tools.formatting.template;
