/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.tools.logging;

import de.cuioss.tools.logging.CuiLogger;
import de.cuioss.tools.logging.LogRecord;
import de.cuioss.tools.string.MoreStrings;
import java.util.function.Supplier;
import lombok.Generated;
import lombok.NonNull;

public class LogRecordModel
implements LogRecord {
    private static final String PREFIX_IDENTIFIER_TEMPLATE = "%s-%s";
    private static final String AFTER_PREFIX = ": ";
    @NonNull
    private final String prefix;
    @NonNull
    private final Integer identifier;
    @NonNull
    private final String template;
    private String parsedMessageTemplate;
    private String parsedIdentifier;

    protected String getParsedMessageTemplate() {
        if (null == this.parsedMessageTemplate) {
            this.parsedMessageTemplate = CuiLogger.SLF4J_PATTERN.matcher(MoreStrings.nullToEmpty(this.getTemplate())).replaceAll("%s");
        }
        return this.parsedMessageTemplate;
    }

    @Override
    public String format(Object ... parameter) {
        return this.resolveIdentifierString() + AFTER_PREFIX + MoreStrings.lenientFormat(this.getParsedMessageTemplate(), parameter);
    }

    @Override
    public Supplier<String> supplier(Object ... parameter) {
        return () -> this.format(parameter);
    }

    @Override
    public String resolveIdentifierString() {
        if (null == this.parsedIdentifier) {
            this.parsedIdentifier = String.format(PREFIX_IDENTIFIER_TEMPLATE, this.getPrefix(), this.getIdentifier());
        }
        return this.parsedIdentifier;
    }

    private LogRecordModel(@NonNull String prefix, @NonNull Integer identifier, @NonNull String template) {
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        if (identifier == null) {
            throw new NullPointerException("identifier is marked non-null but is null");
        }
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        this.prefix = prefix;
        this.identifier = identifier;
        this.template = template;
    }

    @Generated
    public static LogRecordModelBuilder builder() {
        return new LogRecordModelBuilder();
    }

    @Override
    @NonNull
    @Generated
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    @NonNull
    @Generated
    public Integer getIdentifier() {
        return this.identifier;
    }

    @Override
    @NonNull
    @Generated
    public String getTemplate() {
        return this.template;
    }

    @Generated
    public static class LogRecordModelBuilder {
        @Generated
        private String prefix;
        @Generated
        private Integer identifier;
        @Generated
        private String template;

        @Generated
        LogRecordModelBuilder() {
        }

        @Generated
        public LogRecordModelBuilder prefix(@NonNull String prefix) {
            if (prefix == null) {
                throw new NullPointerException("prefix is marked non-null but is null");
            }
            this.prefix = prefix;
            return this;
        }

        @Generated
        public LogRecordModelBuilder identifier(@NonNull Integer identifier) {
            if (identifier == null) {
                throw new NullPointerException("identifier is marked non-null but is null");
            }
            this.identifier = identifier;
            return this;
        }

        @Generated
        public LogRecordModelBuilder template(@NonNull String template) {
            if (template == null) {
                throw new NullPointerException("template is marked non-null but is null");
            }
            this.template = template;
            return this;
        }

        @Generated
        public LogRecordModel build() {
            return new LogRecordModel(this.prefix, this.identifier, this.template);
        }

        @Generated
        public String toString() {
            return "LogRecordModel.LogRecordModelBuilder(prefix=" + this.prefix + ", identifier=" + this.identifier + ", template=" + this.template + ")";
        }
    }
}

