/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.tools.lang;

import de.cuioss.tools.base.Preconditions;
import de.cuioss.tools.collect.MoreCollections;
import java.util.function.Supplier;
import lombok.Generated;

public final class MoreObjects {
    public static <T> T requireType(Object underCheck, Class<T> expectedType) {
        Preconditions.checkArgument(null != underCheck, "Object to be checked must not be null");
        Preconditions.checkArgument(null != expectedType, "expectedType must not be null");
        if (expectedType.isInstance(underCheck)) {
            return (T)underCheck;
        }
        throw new IllegalArgumentException(String.format("Object to be checked '%s' is not assignable to '%s'", underCheck.getClass().getName(), expectedType.getName()));
    }

    public static boolean allNonNull(Object ... objects) {
        if (MoreCollections.isEmpty(objects)) {
            return true;
        }
        for (Object object : objects) {
            if (null != object) continue;
            return false;
        }
        return true;
    }

    public static boolean allNull(Object ... objects) {
        if (MoreCollections.isEmpty(objects)) {
            return true;
        }
        for (Object object : objects) {
            if (null == object) continue;
            return false;
        }
        return true;
    }

    @SafeVarargs
    public static <T> T firstNonNull(T ... values) {
        if (values != null) {
            for (T val : values) {
                if (val == null) continue;
                return val;
            }
        }
        return null;
    }

    @SafeVarargs
    public static <T> T getFirstNonNull(Supplier<T> ... suppliers) {
        if (suppliers != null) {
            for (Supplier<T> supplier : suppliers) {
                T value;
                if (supplier == null || (value = supplier.get()) == null) continue;
                return value;
            }
        }
        return null;
    }

    @Generated
    private MoreObjects() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

