/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.validation;

import de.cuioss.http.security.config.SecurityConfiguration;
import de.cuioss.http.security.config.SecurityDefaults;
import de.cuioss.http.security.core.HttpSecurityValidator;
import de.cuioss.http.security.core.UrlSecurityFailureType;
import de.cuioss.http.security.core.ValidationType;
import de.cuioss.http.security.exceptions.UrlSecurityException;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;

public record PatternMatchingStage(SecurityConfiguration config, ValidationType validationType) implements HttpSecurityValidator
{
    private static final Pattern ENCODED_TRAVERSAL_PATTERN = Pattern.compile("%2e%2e(%2f|%5c|/|\\\\)|\\.%2e(%2f|%5c|/|\\\\)|%2e\\.(%2f|%5c|/|\\\\)|%252e%252e(%252f|%255c)|\\.\\.(%252f|%255c)|%c0%ae%c0%ae(%c0%af|%c1%9c|/|\\\\)|%c1%9c%c1%9c|%c1%8s|%c0%ae%c0%ae%c0%af|%c0%ae%c0%af|%c1%9c|%2e%2e//|%2e%2e\\\\\\\\", 2);
    private static final Pattern DOT_SEPARATOR_PATTERN = Pattern.compile("\\.\\.(/|\\\\)|\\.\\.%2f|\\.\\.%5c|\\.\\.\\.(/|\\\\)|\\.\\.\\.%2f|\\.\\.\\.%5c|\\.\\.\\.\\.(/|\\\\)|\\.\\.\\.\\.%2f|\\.\\.\\.\\.%5c|\\.\\.\\.\\.\\.(/|\\\\)|\\.\\.\\.\\.\\.%2f|\\.\\.\\.\\.\\.%5c", 2);

    @Override
    public Optional<String> validate(@Nullable String value) throws UrlSecurityException {
        String testValue;
        if (value == null) {
            return Optional.empty();
        }
        if (value.isEmpty()) {
            return Optional.of(value);
        }
        String string = testValue = this.config.caseSensitiveComparison() ? value : value.toLowerCase();
        if (this.validationType == ValidationType.URL_PATH || this.validationType == ValidationType.PARAMETER_VALUE || this.validationType == ValidationType.PARAMETER_NAME) {
            this.checkPathTraversalPatterns(value, testValue);
        }
        if (this.validationType == ValidationType.URL_PATH || this.validationType == ValidationType.PARAMETER_VALUE) {
            this.checkSuspiciousPathPatterns(value, testValue);
        }
        if (this.validationType == ValidationType.PARAMETER_NAME) {
            this.checkSuspiciousParameterNames(value, testValue);
        }
        return Optional.of(value);
    }

    private void checkPathTraversalPatterns(String originalValue, String testValue) {
        for (String pattern : SecurityDefaults.PATH_TRAVERSAL_PATTERNS) {
            String checkPattern = this.config.caseSensitiveComparison() ? pattern : pattern.toLowerCase();
            if (!testValue.contains(checkPattern)) continue;
            throw UrlSecurityException.builder().failureType(UrlSecurityFailureType.PATH_TRAVERSAL_DETECTED).validationType(this.validationType).originalInput(originalValue).detail("Path traversal pattern detected: " + pattern).build();
        }
        if (ENCODED_TRAVERSAL_PATTERN.matcher(originalValue).find()) {
            throw UrlSecurityException.builder().failureType(UrlSecurityFailureType.PATH_TRAVERSAL_DETECTED).validationType(this.validationType).originalInput(originalValue).detail("Encoded path traversal pattern detected via regex").build();
        }
        if (DOT_SEPARATOR_PATTERN.matcher(originalValue).find()) {
            throw UrlSecurityException.builder().failureType(UrlSecurityFailureType.PATH_TRAVERSAL_DETECTED).validationType(this.validationType).originalInput(originalValue).detail("Path traversal pattern detected: multiple dots with separators").build();
        }
    }

    private void checkSuspiciousPathPatterns(String originalValue, String testValue) {
        for (String pattern : SecurityDefaults.SUSPICIOUS_PATH_PATTERNS) {
            String checkPattern = this.config.caseSensitiveComparison() ? pattern : pattern.toLowerCase();
            if (!testValue.contains(checkPattern) || !this.config.failOnSuspiciousPatterns()) continue;
            throw UrlSecurityException.builder().failureType(UrlSecurityFailureType.SUSPICIOUS_PATTERN_DETECTED).validationType(this.validationType).originalInput(originalValue).detail("Suspicious path pattern detected: " + pattern).build();
        }
    }

    private void checkSuspiciousParameterNames(String originalValue, String testValue) {
        for (String suspiciousName : SecurityDefaults.SUSPICIOUS_PARAMETER_NAMES) {
            String checkName;
            String string = checkName = this.config.caseSensitiveComparison() ? suspiciousName : suspiciousName.toLowerCase();
            if (!testValue.equals(checkName) && !testValue.contains(checkName) || !this.config.failOnSuspiciousPatterns()) continue;
            throw UrlSecurityException.builder().failureType(UrlSecurityFailureType.SUSPICIOUS_PARAMETER_NAME).validationType(this.validationType).originalInput(originalValue).detail("Suspicious parameter name detected: " + suspiciousName).build();
        }
    }

    @Override
    public HttpSecurityValidator when(Predicate<String> condition) {
        return input -> {
            if (input == null || !condition.test(input)) {
                return Optional.ofNullable(input);
            }
            return this.validate(input);
        };
    }
}

