/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.validation;

import de.cuioss.http.security.config.SecurityConfiguration;
import de.cuioss.http.security.core.HttpSecurityValidator;
import de.cuioss.http.security.core.UrlSecurityFailureType;
import de.cuioss.http.security.core.ValidationType;
import de.cuioss.http.security.exceptions.UrlSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;

public record NormalizationStage(SecurityConfiguration config, ValidationType validationType) implements HttpSecurityValidator
{
    private static final int MAX_PATH_SEGMENTS = 1000;
    private static final int MAX_DIRECTORY_DEPTH = 100;
    private static final Pattern URL_WITH_PROTOCOL_PATTERN = Pattern.compile("^[a-zA-Z][a-zA-Z0-9+.-]*://.*");
    static final Pattern SINGLE_COMPONENT_TRAVERSAL_PATTERN = Pattern.compile("^(?!\\.\\./)[^/\\\\]+/\\.\\./[^/\\\\]+$");
    static final Pattern MULTIPLE_DOTS_WITH_SEPARATOR_PATTERN = Pattern.compile("\\.{3,}[/\\\\]");
    static final Pattern PATH_SEPARATOR_PATTERN = Pattern.compile("[/\\\\]");
    static final Pattern ENDS_WITH_SLASH_DOTDOT_PATTERN = Pattern.compile(".*/\\.\\.$");
    static final Pattern STARTS_WITH_DOTDOT_SLASH_PATTERN = Pattern.compile("^\\.\\./.*");
    static final Pattern STARTS_WITH_DOTDOT_BACKSLASH_PATTERN = Pattern.compile("^\\.\\.\\\\..*");
    static final Pattern CONTAINS_SLASH_DOTDOT_PATTERN = Pattern.compile("/\\.\\.(?:/|$)");
    static final Pattern CONTAINS_DOTDOT_BACKSLASH_PATTERN = Pattern.compile("\\.\\.\\\\");

    @Override
    public Optional<String> validate(@Nullable String value) throws UrlSecurityException {
        if (value == null) {
            return Optional.empty();
        }
        if (value.isEmpty()) {
            return Optional.of(value);
        }
        String original = value;
        if (this.containsDirectoryTraversalIntent(original)) {
            throw UrlSecurityException.builder().failureType(UrlSecurityFailureType.PATH_TRAVERSAL_DETECTED).validationType(this.validationType).originalInput(original).detail("Directory traversal pattern detected in input").build();
        }
        String normalized = this.normalizeUriComponent(value);
        if (this.escapesRoot(normalized)) {
            throw UrlSecurityException.builder().failureType(UrlSecurityFailureType.DIRECTORY_ESCAPE_ATTEMPT).validationType(this.validationType).originalInput(original).sanitizedInput(normalized).detail("Path attempts to escape root directory").build();
        }
        if (this.containsInternalPathTraversal(normalized)) {
            throw UrlSecurityException.builder().failureType(UrlSecurityFailureType.PATH_TRAVERSAL_DETECTED).validationType(this.validationType).originalInput(original).sanitizedInput(normalized).detail("Path normalization revealed traversal attempt").build();
        }
        return Optional.of(normalized);
    }

    private String normalizeUriComponent(String uriComponent) {
        if (URL_WITH_PROTOCOL_PATTERN.matcher(uriComponent).matches()) {
            return uriComponent;
        }
        String[] segments = uriComponent.split("/", -1);
        ArrayList<String> outputSegments = new ArrayList<String>();
        boolean isAbsolute = uriComponent.startsWith("/");
        this.validateSegmentCount(segments.length, uriComponent);
        for (String segment : segments) {
            this.processPathSegment(segment, outputSegments, isAbsolute, uriComponent);
        }
        return this.buildNormalizedPath(outputSegments, isAbsolute, uriComponent);
    }

    private void validateSegmentCount(int segmentCount, String originalInput) {
        if (segmentCount > 1000) {
            throw UrlSecurityException.builder().failureType(UrlSecurityFailureType.EXCESSIVE_NESTING).validationType(this.validationType).originalInput(originalInput).detail("Path contains too many segments: " + segmentCount + " (max: 1000)").build();
        }
    }

    private void processPathSegment(String segment, List<String> outputSegments, boolean isAbsolute, String originalInput) {
        switch (segment) {
            case ".": {
                break;
            }
            case "..": {
                if (!outputSegments.isEmpty() && !"..".equals(outputSegments.getLast())) {
                    outputSegments.removeLast();
                    break;
                }
                if (isAbsolute) break;
                outputSegments.add("..");
                break;
            }
            case "": {
                break;
            }
            default: {
                outputSegments.add(segment);
                this.validateDirectoryDepth(outputSegments.size(), originalInput);
            }
        }
    }

    private void validateDirectoryDepth(int currentDepth, String originalInput) {
        if (currentDepth > 100) {
            throw UrlSecurityException.builder().failureType(UrlSecurityFailureType.EXCESSIVE_NESTING).validationType(this.validationType).originalInput(originalInput).detail("Path depth " + currentDepth + " exceeds maximum 100").build();
        }
    }

    private String buildNormalizedPath(List<String> outputSegments, boolean isAbsolute, String originalInput) {
        StringBuilder result = new StringBuilder();
        if (isAbsolute) {
            result.append("/");
        }
        for (int i = 0; i < outputSegments.size(); ++i) {
            if (i > 0) {
                result.append("/");
            }
            result.append(outputSegments.get(i));
        }
        if (originalInput.endsWith("/") && !result.toString().endsWith("/") && (!outputSegments.isEmpty() || isAbsolute)) {
            result.append("/");
        }
        return result.toString();
    }

    private boolean containsDirectoryTraversalIntent(String input) {
        if (SINGLE_COMPONENT_TRAVERSAL_PATTERN.matcher(input).matches()) {
            return true;
        }
        if (input.contains("..%") || input.contains("%2e%2e") || input.contains("%2E%2E")) {
            return true;
        }
        if (MULTIPLE_DOTS_WITH_SEPARATOR_PATTERN.matcher(input).find()) {
            return true;
        }
        return CONTAINS_DOTDOT_BACKSLASH_PATTERN.matcher(input).find() && !STARTS_WITH_DOTDOT_BACKSLASH_PATTERN.matcher(input).matches();
    }

    private boolean containsInternalPathTraversal(String path) {
        if (CONTAINS_SLASH_DOTDOT_PATTERN.matcher(path).find()) {
            return true;
        }
        if (CONTAINS_DOTDOT_BACKSLASH_PATTERN.matcher(path).find() && !STARTS_WITH_DOTDOT_BACKSLASH_PATTERN.matcher(path).matches()) {
            return true;
        }
        if (ENDS_WITH_SLASH_DOTDOT_PATTERN.matcher(path).matches() && !STARTS_WITH_DOTDOT_SLASH_PATTERN.matcher(path).matches()) {
            return true;
        }
        if ("..".equals(path)) {
            return true;
        }
        if (path.contains("..")) {
            String[] segments;
            for (String segment : segments = PATH_SEPARATOR_PATTERN.split(path)) {
                if (!"..".equals(segment)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean escapesRoot(String path) {
        return STARTS_WITH_DOTDOT_SLASH_PATTERN.matcher(path).matches() || STARTS_WITH_DOTDOT_BACKSLASH_PATTERN.matcher(path).matches();
    }

    @Override
    public HttpSecurityValidator when(Predicate<String> condition) {
        return input -> {
            if (input == null || !condition.test(input)) {
                return Optional.ofNullable(input);
            }
            return this.validate(input);
        };
    }
}

