/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.validation;

import de.cuioss.http.security.config.SecurityConfiguration;
import de.cuioss.http.security.core.HttpSecurityValidator;
import de.cuioss.http.security.core.UrlSecurityFailureType;
import de.cuioss.http.security.core.ValidationType;
import de.cuioss.http.security.exceptions.UrlSecurityException;
import java.util.Optional;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;

public record LengthValidationStage(SecurityConfiguration config, ValidationType validationType) implements HttpSecurityValidator
{
    @Override
    public Optional<String> validate(@Nullable String value) throws UrlSecurityException {
        if (value == null) {
            return Optional.empty();
        }
        int inputLength = value.length();
        int limit = this.getMaxLength();
        UrlSecurityFailureType failureType = this.getFailureType();
        String componentName = this.getComponentName();
        if (inputLength > limit) {
            throw UrlSecurityException.builder().failureType(failureType).validationType(this.validationType).originalInput(value).detail(componentName + " length " + inputLength + " exceeds maximum " + limit).build();
        }
        return Optional.of(value);
    }

    private int getMaxLength() {
        return switch (this.validationType) {
            default -> throw new MatchException(null, null);
            case ValidationType.URL_PATH -> this.config.maxPathLength();
            case ValidationType.PARAMETER_NAME -> this.config.maxParameterNameLength();
            case ValidationType.PARAMETER_VALUE -> this.config.maxParameterValueLength();
            case ValidationType.HEADER_NAME -> this.config.maxHeaderNameLength();
            case ValidationType.HEADER_VALUE -> this.config.maxHeaderValueLength();
            case ValidationType.COOKIE_NAME -> this.config.maxCookieNameLength();
            case ValidationType.COOKIE_VALUE -> this.config.maxCookieValueLength();
            case ValidationType.BODY -> (int)Math.min(this.config.maxBodySize(), Integer.MAX_VALUE);
        };
    }

    private UrlSecurityFailureType getFailureType() {
        return switch (this.validationType) {
            default -> throw new MatchException(null, null);
            case ValidationType.URL_PATH -> UrlSecurityFailureType.PATH_TOO_LONG;
            case ValidationType.PARAMETER_NAME, ValidationType.PARAMETER_VALUE, ValidationType.HEADER_NAME, ValidationType.HEADER_VALUE, ValidationType.COOKIE_NAME, ValidationType.COOKIE_VALUE, ValidationType.BODY -> UrlSecurityFailureType.INPUT_TOO_LONG;
        };
    }

    private String getComponentName() {
        return switch (this.validationType) {
            default -> throw new MatchException(null, null);
            case ValidationType.URL_PATH -> "URL path";
            case ValidationType.PARAMETER_NAME -> "Parameter name";
            case ValidationType.PARAMETER_VALUE -> "Parameter value";
            case ValidationType.HEADER_NAME -> "Header name";
            case ValidationType.HEADER_VALUE -> "Header value";
            case ValidationType.COOKIE_NAME -> "Cookie name";
            case ValidationType.COOKIE_VALUE -> "Cookie value";
            case ValidationType.BODY -> "Request body";
        };
    }

    @Override
    public HttpSecurityValidator when(Predicate<String> condition) {
        return input -> {
            if (input != null && condition.test(input)) {
                return this.validate(input);
            }
            return Optional.ofNullable(input);
        };
    }
}

