/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.validation;

import de.cuioss.http.security.config.SecurityConfiguration;
import de.cuioss.http.security.core.HttpSecurityValidator;
import de.cuioss.http.security.core.UrlSecurityFailureType;
import de.cuioss.http.security.core.ValidationType;
import de.cuioss.http.security.exceptions.UrlSecurityException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.text.Normalizer;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;

public record DecodingStage(SecurityConfiguration config, ValidationType validationType) implements HttpSecurityValidator
{
    private static final Pattern DOUBLE_ENCODING_PATTERN = Pattern.compile("%25[0-9a-fA-F]{2}");
    private static final Pattern UTF8_OVERLONG_PATTERN = Pattern.compile("%c[0-1][0-9a-f]|%e0%[89][0-9a-f]%[89a-f]|%f0%80%[89][0-9a-f]%[89a-f]|%c0%[a-f][0-9a-f]|%c1%[0-9a-f]|%c0%ae|%c0%af|%c1%9c|%c1%81", 2);

    @Override
    public Optional<String> validate(@Nullable String value) throws UrlSecurityException {
        String decoded;
        if (value == null) {
            return Optional.empty();
        }
        if (!this.config.allowDoubleEncoding() && DOUBLE_ENCODING_PATTERN.matcher(value).find()) {
            throw UrlSecurityException.builder().failureType(UrlSecurityFailureType.DOUBLE_ENCODING).validationType(this.validationType).originalInput(value).detail("Double encoding pattern %25XX detected in input").build();
        }
        if (UTF8_OVERLONG_PATTERN.matcher(value).find()) {
            throw UrlSecurityException.builder().failureType(UrlSecurityFailureType.INVALID_ENCODING).validationType(this.validationType).originalInput(value).detail("UTF-8 overlong encoding attack detected").build();
        }
        try {
            decoded = URLDecoder.decode(value, StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException e) {
            throw UrlSecurityException.builder().failureType(UrlSecurityFailureType.INVALID_ENCODING).validationType(this.validationType).originalInput(value).detail("URL decoding failed: " + e.getMessage()).cause(e).build();
        }
        if (this.config.normalizeUnicode()) {
            String normalized = Normalizer.normalize(decoded, Normalizer.Form.NFC);
            if (!decoded.equals(normalized)) {
                throw UrlSecurityException.builder().failureType(UrlSecurityFailureType.UNICODE_NORMALIZATION_CHANGED).validationType(this.validationType).originalInput(value).sanitizedInput(normalized).detail("Unicode normalization changed string content").build();
            }
            decoded = normalized;
        }
        return Optional.of(decoded);
    }

    @Override
    public HttpSecurityValidator when(Predicate<String> condition) {
        return input -> {
            if (input == null || !condition.test(input)) {
                return Optional.ofNullable(input);
            }
            return this.validate(input);
        };
    }
}

