/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.validation;

import de.cuioss.http.security.core.HttpSecurityValidator;
import de.cuioss.http.security.core.UrlSecurityFailureType;
import de.cuioss.http.security.core.ValidationType;
import de.cuioss.http.security.data.Cookie;
import de.cuioss.http.security.exceptions.UrlSecurityException;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

public record CookiePrefixValidationStage() implements HttpSecurityValidator
{
    private static final String HOST_PREFIX = "__Host-";
    private static final String SECURE_PREFIX = "__Secure-";

    @Override
    public Optional<String> validate(@Nullable String cookieName) throws UrlSecurityException {
        if (cookieName == null) {
            return Optional.empty();
        }
        if (!cookieName.equals(cookieName.trim())) {
            throw UrlSecurityException.builder().failureType(UrlSecurityFailureType.INVALID_CHARACTER).validationType(ValidationType.COOKIE_NAME).originalInput(cookieName).detail("Cookie name must not have leading or trailing whitespace").build();
        }
        return Optional.of(cookieName);
    }

    public void validateCookie(Cookie cookie) throws UrlSecurityException {
        if (!cookie.hasName()) {
            throw UrlSecurityException.builder().failureType(UrlSecurityFailureType.INVALID_INPUT).validationType(ValidationType.COOKIE_NAME).originalInput(cookie.name()).detail("Cookie must have a name").build();
        }
        String cookieName = cookie.name();
        this.validate(cookieName);
        if (cookieName.startsWith(HOST_PREFIX)) {
            this.validateHostPrefix(cookie);
            return;
        }
        if (cookieName.startsWith(SECURE_PREFIX)) {
            this.validateSecurePrefix(cookie);
        }
    }

    private void validateHostPrefix(Cookie cookie) throws UrlSecurityException {
        String cookieName = cookie.name();
        if (!cookie.isSecure()) {
            throw UrlSecurityException.builder().failureType(UrlSecurityFailureType.COOKIE_PREFIX_VIOLATION).validationType(ValidationType.COOKIE_NAME).originalInput(cookieName).detail("__Host- prefix requires Secure attribute").build();
        }
        if (cookie.getDomain().isPresent()) {
            throw UrlSecurityException.builder().failureType(UrlSecurityFailureType.COOKIE_PREFIX_VIOLATION).validationType(ValidationType.COOKIE_NAME).originalInput(cookieName).detail("__Host- prefix must not have Domain attribute (found: " + cookie.getDomain().get() + ")").build();
        }
        Optional<String> path = cookie.getPath();
        if (path.isEmpty() || !"/".equals(path.get())) {
            throw UrlSecurityException.builder().failureType(UrlSecurityFailureType.COOKIE_PREFIX_VIOLATION).validationType(ValidationType.COOKIE_NAME).originalInput(cookieName).detail("__Host- prefix requires Path=/ (found: " + path.orElse("none") + ")").build();
        }
    }

    private void validateSecurePrefix(Cookie cookie) throws UrlSecurityException {
        String cookieName = cookie.name();
        if (!cookie.isSecure()) {
            throw UrlSecurityException.builder().failureType(UrlSecurityFailureType.COOKIE_PREFIX_VIOLATION).validationType(ValidationType.COOKIE_NAME).originalInput(cookieName).detail("__Secure- prefix requires Secure attribute").build();
        }
    }

    public static boolean hasSecurityPrefix(@Nullable String cookieName) {
        return cookieName != null && (cookieName.startsWith(HOST_PREFIX) || cookieName.startsWith(SECURE_PREFIX));
    }

    public static boolean hasHostPrefix(@Nullable String cookieName) {
        return cookieName != null && cookieName.startsWith(HOST_PREFIX);
    }

    public static boolean hasSecurePrefix(@Nullable String cookieName) {
        return cookieName != null && cookieName.startsWith(SECURE_PREFIX);
    }
}

