/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.validation;

import de.cuioss.http.security.config.SecurityConfiguration;
import de.cuioss.http.security.core.HttpSecurityValidator;
import de.cuioss.http.security.core.UrlSecurityFailureType;
import de.cuioss.http.security.core.ValidationType;
import de.cuioss.http.security.exceptions.UrlSecurityException;
import de.cuioss.http.security.validation.CharacterValidationConstants;
import java.util.BitSet;
import java.util.Optional;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public final class CharacterValidationStage
implements HttpSecurityValidator {
    private final BitSet allowedChars;
    private final ValidationType validationType;
    private final boolean allowPercentEncoding;
    private final boolean allowNullBytes;
    private final boolean allowControlCharacters;
    private final boolean allowExtendedAscii;

    public CharacterValidationStage(SecurityConfiguration config, ValidationType type) {
        this.validationType = type;
        this.allowNullBytes = config.allowNullBytes();
        this.allowControlCharacters = config.allowControlCharacters();
        this.allowExtendedAscii = config.allowExtendedAscii();
        this.allowedChars = CharacterValidationConstants.getCharacterSet(type);
        this.allowPercentEncoding = switch (type) {
            case ValidationType.URL_PATH, ValidationType.PARAMETER_NAME, ValidationType.PARAMETER_VALUE -> true;
            default -> false;
        };
    }

    @Override
    public Optional<String> validate(@Nullable String value) throws UrlSecurityException {
        if (value == null) {
            return Optional.empty();
        }
        if (value.isEmpty()) {
            return Optional.of(value);
        }
        this.validateCharacters(value);
        return Optional.of(value);
    }

    private void validateCharacters(String value) throws UrlSecurityException {
        int i = 0;
        while (i < value.length()) {
            char ch = value.charAt(i);
            if (ch == '\u0000') {
                this.handleNullByte(value, i);
            }
            if (ch == '%' && this.allowPercentEncoding) {
                this.validatePercentEncoding(value, i);
                i += 3;
                continue;
            }
            if (!this.isCharacterAllowed(ch)) {
                this.handleInvalidCharacter(value, ch, i);
            }
            ++i;
        }
    }

    private void handleNullByte(String value, int position) throws UrlSecurityException {
        if (!this.allowNullBytes) {
            throw UrlSecurityException.builder().failureType(UrlSecurityFailureType.NULL_BYTE_INJECTION).validationType(this.validationType).originalInput(value).detail("Null byte detected at position " + position).build();
        }
    }

    private void handleInvalidCharacter(String value, char ch, int position) throws UrlSecurityException {
        UrlSecurityFailureType failureType = this.getFailureTypeForCharacter(ch);
        throw UrlSecurityException.builder().failureType(failureType).validationType(this.validationType).originalInput(value).detail("Invalid character '" + ch + "' (0x" + Integer.toHexString(ch).toUpperCase() + ") at position " + position).build();
    }

    private void validatePercentEncoding(String value, int position) throws UrlSecurityException {
        if (position + 2 >= value.length()) {
            throw UrlSecurityException.builder().failureType(UrlSecurityFailureType.INVALID_ENCODING).validationType(this.validationType).originalInput(value).detail("Incomplete percent encoding at position " + position).build();
        }
        char hex1 = value.charAt(position + 1);
        char hex2 = value.charAt(position + 2);
        if (this.isNotHexDigit(hex1) || this.isNotHexDigit(hex2)) {
            throw UrlSecurityException.builder().failureType(UrlSecurityFailureType.INVALID_ENCODING).validationType(this.validationType).originalInput(value).detail("Invalid hex digits in percent encoding at position " + position).build();
        }
        if (hex1 == '0' && hex2 == '0' && !this.allowNullBytes) {
            throw UrlSecurityException.builder().failureType(UrlSecurityFailureType.NULL_BYTE_INJECTION).validationType(this.validationType).originalInput(value).detail("Encoded null byte (%00) detected at position " + position).build();
        }
    }

    private boolean isNotHexDigit(char ch) {
        return !(ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'F' || ch >= 'a' && ch <= 'f');
    }

    private boolean isCharacterAllowed(char ch) {
        if (ch == '\u0000') {
            return this.allowNullBytes;
        }
        if (ch <= '\u001f') {
            if (this.allowedChars.get(ch)) {
                return true;
            }
            return this.allowControlCharacters;
        }
        if (ch <= '\u007f') {
            return this.allowedChars.get(ch);
        }
        if (ch <= '\u00ff') {
            if (this.validationType == ValidationType.HEADER_NAME || this.validationType == ValidationType.COOKIE_NAME || this.validationType == ValidationType.COOKIE_VALUE) {
                return false;
            }
            return this.allowExtendedAscii || this.allowedChars.get(ch);
        }
        if (ch >= '\u0300' && ch <= '\u036f') {
            return false;
        }
        return this.allowExtendedAscii && this.supportsUnicodeCharacters();
    }

    private UrlSecurityFailureType getFailureTypeForCharacter(char ch) {
        if (ch == '\u0000') {
            return UrlSecurityFailureType.NULL_BYTE_INJECTION;
        }
        if (ch <= '\u001f') {
            if (this.validationType == ValidationType.HEADER_NAME || this.validationType == ValidationType.HEADER_VALUE) {
                return UrlSecurityFailureType.INVALID_CHARACTER;
            }
            if (this.allowedChars.get(ch)) {
                return UrlSecurityFailureType.INVALID_CHARACTER;
            }
            return UrlSecurityFailureType.CONTROL_CHARACTERS;
        }
        return UrlSecurityFailureType.INVALID_CHARACTER;
    }

    private boolean supportsUnicodeCharacters() {
        return switch (this.validationType) {
            default -> throw new MatchException(null, null);
            case ValidationType.BODY -> true;
            case ValidationType.HEADER_VALUE -> true;
            case ValidationType.URL_PATH, ValidationType.PARAMETER_NAME, ValidationType.PARAMETER_VALUE -> false;
            case ValidationType.HEADER_NAME -> false;
            case ValidationType.COOKIE_NAME, ValidationType.COOKIE_VALUE -> false;
        };
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CharacterValidationStage)) {
            return false;
        }
        CharacterValidationStage other = (CharacterValidationStage)o;
        if (this.allowPercentEncoding != other.allowPercentEncoding) {
            return false;
        }
        if (this.allowNullBytes != other.allowNullBytes) {
            return false;
        }
        if (this.allowControlCharacters != other.allowControlCharacters) {
            return false;
        }
        if (this.allowExtendedAscii != other.allowExtendedAscii) {
            return false;
        }
        BitSet this$allowedChars = this.allowedChars;
        BitSet other$allowedChars = other.allowedChars;
        if (this$allowedChars == null ? other$allowedChars != null : !((Object)this$allowedChars).equals(other$allowedChars)) {
            return false;
        }
        ValidationType this$validationType = this.validationType;
        ValidationType other$validationType = other.validationType;
        return !(this$validationType == null ? other$validationType != null : !((Object)((Object)this$validationType)).equals((Object)other$validationType));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.allowPercentEncoding ? 79 : 97);
        result = result * 59 + (this.allowNullBytes ? 79 : 97);
        result = result * 59 + (this.allowControlCharacters ? 79 : 97);
        result = result * 59 + (this.allowExtendedAscii ? 79 : 97);
        BitSet $allowedChars = this.allowedChars;
        result = result * 59 + ($allowedChars == null ? 43 : ((Object)$allowedChars).hashCode());
        ValidationType $validationType = this.validationType;
        result = result * 59 + ($validationType == null ? 43 : ((Object)((Object)$validationType)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CharacterValidationStage(allowedChars=" + String.valueOf(this.allowedChars) + ", validationType=" + String.valueOf((Object)this.validationType) + ", allowPercentEncoding=" + this.allowPercentEncoding + ", allowNullBytes=" + this.allowNullBytes + ", allowControlCharacters=" + this.allowControlCharacters + ", allowExtendedAscii=" + this.allowExtendedAscii + ")";
    }
}

