/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.validation;

import de.cuioss.http.security.core.ValidationType;
import java.util.BitSet;

public final class CharacterValidationConstants {
    public static final BitSet RFC3986_UNRESERVED;
    public static final BitSet RFC3986_PATH_CHARS;
    public static final BitSet RFC3986_QUERY_CHARS;
    public static final BitSet RFC7230_HEADER_CHARS;
    public static final BitSet HTTP_BODY_CHARS;

    private CharacterValidationConstants() {
    }

    public static BitSet getCharacterSet(ValidationType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case ValidationType.URL_PATH -> RFC3986_PATH_CHARS;
            case ValidationType.PARAMETER_NAME, ValidationType.PARAMETER_VALUE -> RFC3986_QUERY_CHARS;
            case ValidationType.HEADER_NAME, ValidationType.HEADER_VALUE -> RFC7230_HEADER_CHARS;
            case ValidationType.BODY -> HTTP_BODY_CHARS;
            case ValidationType.COOKIE_NAME, ValidationType.COOKIE_VALUE -> RFC3986_UNRESERVED;
        };
    }

    static {
        int i;
        int i2;
        BitSet unreserved = new BitSet(256);
        for (i2 = 65; i2 <= 90; ++i2) {
            unreserved.set(i2);
        }
        for (i2 = 97; i2 <= 122; ++i2) {
            unreserved.set(i2);
        }
        for (i2 = 48; i2 <= 57; ++i2) {
            unreserved.set(i2);
        }
        unreserved.set(45);
        unreserved.set(46);
        unreserved.set(95);
        unreserved.set(126);
        RFC3986_UNRESERVED = unreserved;
        BitSet pathChars = new BitSet(256);
        pathChars.or(unreserved);
        pathChars.set(47);
        pathChars.set(64);
        pathChars.set(58);
        "!$&'()*+,;=".chars().forEach(pathChars::set);
        RFC3986_PATH_CHARS = pathChars;
        BitSet queryChars = new BitSet(256);
        queryChars.or(unreserved);
        queryChars.set(63);
        queryChars.set(38);
        queryChars.set(61);
        "!$'()*+,;".chars().forEach(queryChars::set);
        RFC3986_QUERY_CHARS = queryChars;
        BitSet headerChars = new BitSet(256);
        for (int i3 = 32; i3 <= 126; ++i3) {
            headerChars.set(i3);
        }
        headerChars.set(9);
        RFC7230_HEADER_CHARS = headerChars;
        BitSet bodyChars = new BitSet(256);
        for (i = 32; i <= 126; ++i) {
            bodyChars.set(i);
        }
        bodyChars.set(9);
        bodyChars.set(10);
        bodyChars.set(13);
        for (i = 128; i <= 255; ++i) {
            bodyChars.set(i);
        }
        HTTP_BODY_CHARS = bodyChars;
    }
}

