/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.pipeline;

import de.cuioss.http.security.config.SecurityConfiguration;
import de.cuioss.http.security.core.HttpSecurityValidator;
import de.cuioss.http.security.core.ValidationType;
import de.cuioss.http.security.monitoring.SecurityEventCounter;
import de.cuioss.http.security.pipeline.AbstractValidationPipeline;
import de.cuioss.http.security.validation.CharacterValidationStage;
import de.cuioss.http.security.validation.DecodingStage;
import de.cuioss.http.security.validation.LengthValidationStage;
import de.cuioss.http.security.validation.NormalizationStage;
import de.cuioss.http.security.validation.PatternMatchingStage;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

public final class URLPathValidationPipeline
extends AbstractValidationPipeline {
    private static final ValidationType VALIDATION_TYPE = ValidationType.URL_PATH;

    public URLPathValidationPipeline(SecurityConfiguration config, SecurityEventCounter eventCounter) {
        super(URLPathValidationPipeline.createStages(config), Objects.requireNonNull(eventCounter, "EventCounter must not be null"));
    }

    private static List<HttpSecurityValidator> createStages(SecurityConfiguration config) {
        Objects.requireNonNull(config, "Config must not be null");
        return List.of(new LengthValidationStage(config, ValidationType.URL_PATH), new CharacterValidationStage(config, ValidationType.URL_PATH), new PatternMatchingStage(config, ValidationType.URL_PATH), new DecodingStage(config, ValidationType.URL_PATH), new NormalizationStage(config, ValidationType.URL_PATH), new PatternMatchingStage(config, ValidationType.URL_PATH));
    }

    @Override
    public ValidationType getValidationType() {
        return VALIDATION_TYPE;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof URLPathValidationPipeline)) {
            return false;
        }
        URLPathValidationPipeline other = (URLPathValidationPipeline)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof URLPathValidationPipeline;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public String toString() {
        return "URLPathValidationPipeline(super=" + super.toString() + ")";
    }
}

