/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.pipeline;

import de.cuioss.http.security.config.SecurityConfiguration;
import de.cuioss.http.security.core.HttpSecurityValidator;
import de.cuioss.http.security.core.ValidationType;
import de.cuioss.http.security.monitoring.SecurityEventCounter;
import de.cuioss.http.security.pipeline.AbstractValidationPipeline;
import de.cuioss.http.security.validation.CharacterValidationStage;
import de.cuioss.http.security.validation.DecodingStage;
import de.cuioss.http.security.validation.LengthValidationStage;
import de.cuioss.http.security.validation.NormalizationStage;
import de.cuioss.http.security.validation.PatternMatchingStage;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

public final class URLParameterValidationPipeline
extends AbstractValidationPipeline {
    private static final ValidationType VALIDATION_TYPE = ValidationType.PARAMETER_VALUE;

    public URLParameterValidationPipeline(SecurityConfiguration config, SecurityEventCounter eventCounter) {
        super(URLParameterValidationPipeline.createStages(config), Objects.requireNonNull(eventCounter, "EventCounter must not be null"));
    }

    private static List<HttpSecurityValidator> createStages(SecurityConfiguration config) {
        Objects.requireNonNull(config, "Config must not be null");
        return List.of(new LengthValidationStage(config, ValidationType.PARAMETER_VALUE), new CharacterValidationStage(config, ValidationType.PARAMETER_VALUE), new DecodingStage(config, ValidationType.PARAMETER_VALUE), new NormalizationStage(config, ValidationType.PARAMETER_VALUE), new PatternMatchingStage(config, ValidationType.PARAMETER_VALUE));
    }

    @Override
    public ValidationType getValidationType() {
        return VALIDATION_TYPE;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof URLParameterValidationPipeline)) {
            return false;
        }
        URLParameterValidationPipeline other = (URLParameterValidationPipeline)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof URLParameterValidationPipeline;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public String toString() {
        return "URLParameterValidationPipeline(super=" + super.toString() + ")";
    }
}

