/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.pipeline;

import de.cuioss.http.security.config.SecurityConfiguration;
import de.cuioss.http.security.core.HttpSecurityValidator;
import de.cuioss.http.security.core.ValidationType;
import de.cuioss.http.security.monitoring.SecurityEventCounter;
import de.cuioss.http.security.pipeline.HTTPHeaderValidationPipeline;
import de.cuioss.http.security.pipeline.URLParameterValidationPipeline;
import de.cuioss.http.security.pipeline.URLPathValidationPipeline;
import java.util.Objects;

public final class PipelineFactory {
    private PipelineFactory() {
    }

    public static HttpSecurityValidator createUrlPathPipeline(SecurityConfiguration config, SecurityEventCounter eventCounter) {
        return new URLPathValidationPipeline(config, eventCounter);
    }

    public static HttpSecurityValidator createUrlParameterPipeline(SecurityConfiguration config, SecurityEventCounter eventCounter) {
        return new URLParameterValidationPipeline(config, eventCounter);
    }

    public static HttpSecurityValidator createParameterNamePipeline(SecurityConfiguration config, SecurityEventCounter eventCounter) {
        return new URLParameterValidationPipeline(config, eventCounter);
    }

    public static HttpSecurityValidator createHeaderNamePipeline(SecurityConfiguration config, SecurityEventCounter eventCounter) {
        return new HTTPHeaderValidationPipeline(config, eventCounter, ValidationType.HEADER_NAME);
    }

    public static HttpSecurityValidator createHeaderValuePipeline(SecurityConfiguration config, SecurityEventCounter eventCounter) {
        return new HTTPHeaderValidationPipeline(config, eventCounter, ValidationType.HEADER_VALUE);
    }

    public static HttpSecurityValidator createPipeline(ValidationType validationType, SecurityConfiguration config, SecurityEventCounter eventCounter) {
        Objects.requireNonNull(validationType, "ValidationType must not be null");
        Objects.requireNonNull(config, "Config must not be null");
        Objects.requireNonNull(eventCounter, "EventCounter must not be null");
        return switch (validationType) {
            default -> throw new MatchException(null, null);
            case ValidationType.URL_PATH -> PipelineFactory.createUrlPathPipeline(config, eventCounter);
            case ValidationType.PARAMETER_VALUE -> PipelineFactory.createUrlParameterPipeline(config, eventCounter);
            case ValidationType.HEADER_NAME -> PipelineFactory.createHeaderNamePipeline(config, eventCounter);
            case ValidationType.HEADER_VALUE -> PipelineFactory.createHeaderValuePipeline(config, eventCounter);
            case ValidationType.PARAMETER_NAME -> PipelineFactory.createParameterNamePipeline(config, eventCounter);
            case ValidationType.BODY -> throw new IllegalArgumentException("BODY validation pipeline has been removed. HTTP body content validation should be handled at application layer.");
            case ValidationType.COOKIE_NAME, ValidationType.COOKIE_VALUE -> throw new IllegalArgumentException("Cookie validation pipelines are not yet implemented. Supported types: URL_PATH, PARAMETER_VALUE, HEADER_NAME, HEADER_VALUE");
        };
    }

    public static PipelineSet createCommonPipelines(SecurityConfiguration config, SecurityEventCounter eventCounter) {
        Objects.requireNonNull(config, "Config must not be null");
        Objects.requireNonNull(eventCounter, "EventCounter must not be null");
        return new PipelineSet(PipelineFactory.createUrlPathPipeline(config, eventCounter), PipelineFactory.createUrlParameterPipeline(config, eventCounter), PipelineFactory.createHeaderNamePipeline(config, eventCounter), PipelineFactory.createHeaderValuePipeline(config, eventCounter));
    }

    public record PipelineSet(HttpSecurityValidator urlPathPipeline, HttpSecurityValidator urlParameterPipeline, HttpSecurityValidator headerNamePipeline, HttpSecurityValidator headerValuePipeline) {
        public PipelineSet {
            Objects.requireNonNull(urlPathPipeline, "urlPathPipeline must not be null");
            Objects.requireNonNull(urlParameterPipeline, "urlParameterPipeline must not be null");
            Objects.requireNonNull(headerNamePipeline, "headerNamePipeline must not be null");
            Objects.requireNonNull(headerValuePipeline, "headerValuePipeline must not be null");
        }
    }
}

