/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.pipeline;

import de.cuioss.http.security.config.SecurityConfiguration;
import de.cuioss.http.security.core.HttpSecurityValidator;
import de.cuioss.http.security.core.ValidationType;
import de.cuioss.http.security.monitoring.SecurityEventCounter;
import de.cuioss.http.security.pipeline.AbstractValidationPipeline;
import de.cuioss.http.security.validation.CharacterValidationStage;
import de.cuioss.http.security.validation.LengthValidationStage;
import de.cuioss.http.security.validation.NormalizationStage;
import de.cuioss.http.security.validation.PatternMatchingStage;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

public final class HTTPHeaderValidationPipeline
extends AbstractValidationPipeline {
    private final ValidationType validationType;

    public HTTPHeaderValidationPipeline(SecurityConfiguration config, SecurityEventCounter eventCounter, ValidationType validationType) {
        super(HTTPHeaderValidationPipeline.createStages(config, validationType), Objects.requireNonNull(eventCounter, "EventCounter must not be null"));
        Objects.requireNonNull(validationType, "ValidationType must not be null");
        if (!validationType.isHeader()) {
            throw new IllegalArgumentException("ValidationType must be a header type, got: " + String.valueOf((Object)validationType));
        }
        this.validationType = validationType;
    }

    private static List<HttpSecurityValidator> createStages(SecurityConfiguration config, ValidationType validationType) {
        Objects.requireNonNull(config, "Config must not be null");
        Objects.requireNonNull(validationType, "ValidationType must not be null");
        return List.of(new LengthValidationStage(config, validationType), new CharacterValidationStage(config, validationType), new NormalizationStage(config, validationType), new PatternMatchingStage(config, validationType));
    }

    @Override
    public ValidationType getValidationType() {
        return this.validationType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HTTPHeaderValidationPipeline)) {
            return false;
        }
        HTTPHeaderValidationPipeline other = (HTTPHeaderValidationPipeline)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ValidationType this$validationType = this.getValidationType();
        ValidationType other$validationType = other.getValidationType();
        return !(this$validationType == null ? other$validationType != null : !((Object)((Object)this$validationType)).equals((Object)other$validationType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HTTPHeaderValidationPipeline;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ValidationType $validationType = this.getValidationType();
        result = result * 59 + ($validationType == null ? 43 : ((Object)((Object)$validationType)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HTTPHeaderValidationPipeline(super=" + super.toString() + ", validationType=" + String.valueOf((Object)this.getValidationType()) + ")";
    }
}

