/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.pipeline;

import de.cuioss.http.security.core.HttpSecurityValidator;
import de.cuioss.http.security.core.ValidationType;
import de.cuioss.http.security.exceptions.UrlSecurityException;
import de.cuioss.http.security.monitoring.SecurityEventCounter;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public abstract class AbstractValidationPipeline
implements HttpSecurityValidator {
    protected final List<HttpSecurityValidator> stages;
    protected final SecurityEventCounter eventCounter;

    public abstract ValidationType getValidationType();

    @Override
    public Optional<String> validate(@Nullable String value) throws UrlSecurityException {
        if (value == null) {
            return Optional.empty();
        }
        String result = value;
        for (HttpSecurityValidator stage : this.stages) {
            try {
                Optional<String> stageResult = stage.validate(result);
                if (stageResult.isEmpty()) {
                    return Optional.empty();
                }
                result = stageResult.get();
            }
            catch (UrlSecurityException e) {
                this.eventCounter.increment(e.getFailureType());
                throw UrlSecurityException.builder().failureType(e.getFailureType()).validationType(this.getValidationType()).originalInput(value).sanitizedInput(e.getSanitizedInput().orElse(null)).detail(e.getDetail().orElse("Validation failed")).cause(e.getCause()).build();
            }
        }
        return Optional.of(result);
    }

    @Generated
    public AbstractValidationPipeline(List<HttpSecurityValidator> stages, SecurityEventCounter eventCounter) {
        this.stages = stages;
        this.eventCounter = eventCounter;
    }

    @Generated
    public List<HttpSecurityValidator> getStages() {
        return this.stages;
    }

    @Generated
    public SecurityEventCounter getEventCounter() {
        return this.eventCounter;
    }
}

