/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.monitoring;

import de.cuioss.http.security.core.UrlSecurityFailureType;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

public class SecurityEventCounter {
    private final ConcurrentHashMap<UrlSecurityFailureType, AtomicLong> counters = new ConcurrentHashMap();

    public long increment(UrlSecurityFailureType failureType) {
        return this.counters.computeIfAbsent(failureType, k -> new AtomicLong(0L)).incrementAndGet();
    }

    public long incrementBy(UrlSecurityFailureType failureType, long delta) {
        if (delta < 0L) {
            throw new IllegalArgumentException("delta must be non-negative, got: " + delta);
        }
        return this.counters.computeIfAbsent(failureType, k -> new AtomicLong(0L)).addAndGet(delta);
    }

    public long getCount(UrlSecurityFailureType failureType) {
        return Optional.ofNullable(this.counters.get((Object)failureType)).map(AtomicLong::get).orElse(0L);
    }

    public Map<UrlSecurityFailureType, Long> getAllCounts() {
        return this.counters.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, entry -> ((AtomicLong)entry.getValue()).get()));
    }

    public long getTotalCount() {
        return this.counters.values().stream().mapToLong(AtomicLong::get).sum();
    }

    public int getFailureTypeCount() {
        return this.counters.size();
    }

    public boolean hasEvents(UrlSecurityFailureType failureType) {
        return this.getCount(failureType) > 0L;
    }

    public boolean hasAnyEvents() {
        return !this.counters.isEmpty() && this.getTotalCount() > 0L;
    }

    public void reset(UrlSecurityFailureType failureType) {
        AtomicLong counter = this.counters.get((Object)failureType);
        if (counter != null) {
            counter.set(0L);
        }
    }

    public void reset() {
        this.counters.values().forEach(counter -> counter.set(0L));
    }

    public void clear() {
        this.counters.clear();
    }

    public String toString() {
        return "SecurityEventCounter{totalEvents=%d, distinctFailureTypes=%d}".formatted(this.getTotalCount(), this.getFailureTypeCount());
    }
}

