/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.exceptions;

import de.cuioss.http.security.core.UrlSecurityFailureType;
import de.cuioss.http.security.core.ValidationType;
import java.util.Optional;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public class UrlSecurityException
extends RuntimeException {
    private static final Pattern CONTROL_CHARS_PATTERN = Pattern.compile("[\\x00-\\x1F\\x7F]");
    private final UrlSecurityFailureType failureType;
    private final ValidationType validationType;
    private final String originalInput;
    private final @Nullable String sanitizedInput;
    private final @Nullable String detail;

    private UrlSecurityException(UrlSecurityFailureType failureType, ValidationType validationType, String originalInput, @Nullable String sanitizedInput, @Nullable String detail, @Nullable Throwable cause) {
        super(UrlSecurityException.buildMessage(failureType, validationType, originalInput, detail), cause);
        this.failureType = failureType;
        this.validationType = validationType;
        this.originalInput = originalInput;
        this.sanitizedInput = sanitizedInput;
        this.detail = detail;
    }

    public Optional<String> getSanitizedInput() {
        return Optional.ofNullable(this.sanitizedInput);
    }

    public Optional<String> getDetail() {
        return Optional.ofNullable(this.detail);
    }

    private static String buildMessage(UrlSecurityFailureType failureType, ValidationType validationType, String originalInput, @Nullable String detail) {
        StringBuilder sb = new StringBuilder();
        sb.append("Security validation failed [").append((Object)validationType).append("]: ");
        sb.append(failureType.getDescription());
        if (detail != null && !detail.trim().isEmpty()) {
            sb.append(" - ").append(detail);
        }
        String truncatedInput = UrlSecurityException.truncateForLogging(originalInput);
        sb.append(" (input: '").append(truncatedInput).append("')");
        return sb.toString();
    }

    private static String truncateForLogging(@Nullable String input) {
        if (input == null) {
            return "null";
        }
        String safe = CONTROL_CHARS_PATTERN.matcher(input).replaceAll("?");
        if (safe.length() > 200) {
            return safe.substring(0, 200) + "...";
        }
        return safe;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{failureType=" + String.valueOf((Object)this.failureType) + ", validationType=" + String.valueOf((Object)this.validationType) + ", originalInput='" + UrlSecurityException.truncateForLogging(this.originalInput) + "', sanitizedInput='" + (this.sanitizedInput != null ? UrlSecurityException.truncateForLogging(this.sanitizedInput) : null) + "', detail='" + this.detail + "', cause=" + String.valueOf(this.getCause()) + "}";
    }

    @Generated
    public static UrlSecurityExceptionBuilder builder() {
        return new UrlSecurityExceptionBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UrlSecurityException)) {
            return false;
        }
        UrlSecurityException other = (UrlSecurityException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UrlSecurityFailureType this$failureType = this.getFailureType();
        UrlSecurityFailureType other$failureType = other.getFailureType();
        if (this$failureType == null ? other$failureType != null : !((Object)((Object)this$failureType)).equals((Object)other$failureType)) {
            return false;
        }
        ValidationType this$validationType = this.getValidationType();
        ValidationType other$validationType = other.getValidationType();
        if (this$validationType == null ? other$validationType != null : !((Object)((Object)this$validationType)).equals((Object)other$validationType)) {
            return false;
        }
        String this$originalInput = this.getOriginalInput();
        String other$originalInput = other.getOriginalInput();
        if (this$originalInput == null ? other$originalInput != null : !this$originalInput.equals(other$originalInput)) {
            return false;
        }
        Optional<String> this$sanitizedInput = this.getSanitizedInput();
        Optional<String> other$sanitizedInput = other.getSanitizedInput();
        if (this$sanitizedInput == null ? other$sanitizedInput != null : !((Object)this$sanitizedInput).equals(other$sanitizedInput)) {
            return false;
        }
        Optional<String> this$detail = this.getDetail();
        Optional<String> other$detail = other.getDetail();
        return !(this$detail == null ? other$detail != null : !((Object)this$detail).equals(other$detail));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UrlSecurityException;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        UrlSecurityFailureType $failureType = this.getFailureType();
        result = result * 59 + ($failureType == null ? 43 : ((Object)((Object)$failureType)).hashCode());
        ValidationType $validationType = this.getValidationType();
        result = result * 59 + ($validationType == null ? 43 : ((Object)((Object)$validationType)).hashCode());
        String $originalInput = this.getOriginalInput();
        result = result * 59 + ($originalInput == null ? 43 : $originalInput.hashCode());
        Optional<String> $sanitizedInput = this.getSanitizedInput();
        result = result * 59 + ($sanitizedInput == null ? 43 : ((Object)$sanitizedInput).hashCode());
        Optional<String> $detail = this.getDetail();
        result = result * 59 + ($detail == null ? 43 : ((Object)$detail).hashCode());
        return result;
    }

    @Generated
    public UrlSecurityFailureType getFailureType() {
        return this.failureType;
    }

    @Generated
    public ValidationType getValidationType() {
        return this.validationType;
    }

    @Generated
    public String getOriginalInput() {
        return this.originalInput;
    }

    @Generated
    public static class UrlSecurityExceptionBuilder {
        @Generated
        private UrlSecurityFailureType failureType;
        @Generated
        private ValidationType validationType;
        @Generated
        private String originalInput;
        @Generated
        private String sanitizedInput;
        @Generated
        private String detail;
        @Generated
        private Throwable cause;

        @Generated
        UrlSecurityExceptionBuilder() {
        }

        @Generated
        public UrlSecurityExceptionBuilder failureType(UrlSecurityFailureType failureType) {
            this.failureType = failureType;
            return this;
        }

        @Generated
        public UrlSecurityExceptionBuilder validationType(ValidationType validationType) {
            this.validationType = validationType;
            return this;
        }

        @Generated
        public UrlSecurityExceptionBuilder originalInput(String originalInput) {
            this.originalInput = originalInput;
            return this;
        }

        @Generated
        public UrlSecurityExceptionBuilder sanitizedInput(@Nullable String sanitizedInput) {
            this.sanitizedInput = sanitizedInput;
            return this;
        }

        @Generated
        public UrlSecurityExceptionBuilder detail(@Nullable String detail) {
            this.detail = detail;
            return this;
        }

        @Generated
        public UrlSecurityExceptionBuilder cause(@Nullable Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Generated
        public UrlSecurityException build() {
            return new UrlSecurityException(this.failureType, this.validationType, this.originalInput, this.sanitizedInput, this.detail, this.cause);
        }

        @Generated
        public String toString() {
            return "UrlSecurityException.UrlSecurityExceptionBuilder(failureType=" + String.valueOf((Object)this.failureType) + ", validationType=" + String.valueOf((Object)this.validationType) + ", originalInput=" + this.originalInput + ", sanitizedInput=" + this.sanitizedInput + ", detail=" + this.detail + ", cause=" + String.valueOf(this.cause) + ")";
        }
    }
}

