/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.data;

import org.jspecify.annotations.Nullable;

public record URLParameter(@Nullable String name, @Nullable String value) {
    public static URLParameter withEmptyValue(String name) {
        return new URLParameter(name, "");
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasValue() {
        return this.value != null && !this.value.isEmpty();
    }

    public boolean isFlag() {
        return this.hasName() && (this.value == null || this.value.isEmpty());
    }

    public String nameOrDefault(String defaultName) {
        return this.name != null ? this.name : defaultName;
    }

    public String valueOrDefault(String defaultValue) {
        return this.value != null ? this.value : defaultValue;
    }

    public String toParameterString() {
        if (this.name == null) {
            return this.value != null ? "=" + this.value : "";
        }
        if (this.value == null || this.value.isEmpty()) {
            return this.name;
        }
        return this.name + "=" + this.value;
    }

    public URLParameter withName(String newName) {
        return new URLParameter(newName, this.value);
    }

    public URLParameter withValue(String newValue) {
        return new URLParameter(this.name, newValue);
    }
}

