/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.data;

import de.cuioss.http.security.data.AttributeParser;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

public record HTTPBody(@Nullable String content, @Nullable String contentType, @Nullable String encoding) {
    public static HTTPBody of(String content, String contentType) {
        return new HTTPBody(content, contentType, "");
    }

    public static HTTPBody text(String content) {
        return new HTTPBody(content, "text/plain", "");
    }

    public static HTTPBody json(String jsonContent) {
        return new HTTPBody(jsonContent, "application/json", "");
    }

    public static HTTPBody html(String htmlContent) {
        return new HTTPBody(htmlContent, "text/html", "");
    }

    public static HTTPBody form(String formContent) {
        return new HTTPBody(formContent, "application/x-www-form-urlencoded", "");
    }

    public boolean hasContent() {
        return this.content != null && !this.content.isEmpty();
    }

    public boolean hasContentType() {
        return this.contentType != null && !this.contentType.isEmpty();
    }

    public boolean hasEncoding() {
        return this.encoding != null && !this.encoding.isEmpty();
    }

    public boolean isCompressed() {
        return this.hasEncoding();
    }

    public boolean isJson() {
        return this.hasContentType() && this.contentType.toLowerCase().contains("json");
    }

    public boolean isXml() {
        return this.hasContentType() && this.contentType.toLowerCase().contains("xml");
    }

    public boolean isHtml() {
        return this.hasContentType() && this.contentType.toLowerCase().contains("html");
    }

    public boolean isPlainText() {
        return this.hasContentType() && "text/plain".equalsIgnoreCase(this.contentType);
    }

    public boolean isFormData() {
        return this.hasContentType() && (this.contentType.toLowerCase().contains("application/x-www-form-urlencoded") || this.contentType.toLowerCase().contains("multipart/form-data"));
    }

    public boolean isBinary() {
        return this.hasContentType() && (this.contentType.toLowerCase().contains("application/octet-stream") || this.contentType.toLowerCase().contains("image/") || this.contentType.toLowerCase().contains("video/") || this.contentType.toLowerCase().contains("audio/"));
    }

    public int contentLength() {
        return this.content != null ? this.content.length() : 0;
    }

    public Optional<String> getCharset() {
        if (!this.hasContentType()) {
            return Optional.empty();
        }
        return AttributeParser.extractAttributeValue(this.contentType, "charset");
    }

    public String contentOrDefault(String defaultContent) {
        return this.content != null ? this.content : defaultContent;
    }

    public String contentTypeOrDefault(String defaultContentType) {
        return this.contentType != null ? this.contentType : defaultContentType;
    }

    public String encodingOrDefault(String defaultEncoding) {
        return this.encoding != null ? this.encoding : defaultEncoding;
    }

    public HTTPBody withContent(String newContent) {
        return new HTTPBody(newContent, this.contentType, this.encoding);
    }

    public HTTPBody withContentType(String newContentType) {
        return new HTTPBody(this.content, newContentType, this.encoding);
    }

    public HTTPBody withEncoding(String newEncoding) {
        return new HTTPBody(this.content, this.contentType, newEncoding);
    }

    public String contentTruncated(int maxLength) {
        if (this.content == null) {
            return "null";
        }
        if (this.content.length() <= maxLength) {
            return this.content;
        }
        return this.content.substring(0, maxLength) + "...";
    }
}

