/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.data;

import de.cuioss.http.security.config.SecurityConfiguration;
import de.cuioss.http.security.core.ValidationType;
import de.cuioss.http.security.data.AttributeParser;
import de.cuioss.http.security.validation.CharacterValidationStage;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

public record Cookie(@Nullable String name, @Nullable String value, @Nullable String attributes) {
    private static final CharacterValidationStage COOKIE_NAME_VALIDATOR = new CharacterValidationStage(SecurityConfiguration.builder().build(), ValidationType.COOKIE_NAME);

    public static Cookie simple(String name, String value) {
        return new Cookie(name, value, "");
    }

    public static Cookie hostPrefix(String suffix, String value) {
        COOKIE_NAME_VALIDATOR.validate(suffix);
        return new Cookie("__Host-" + suffix, value, "Secure; Path=/; HttpOnly; SameSite=Strict");
    }

    public static Cookie securePrefix(String suffix, String value) {
        COOKIE_NAME_VALIDATOR.validate(suffix);
        return new Cookie("__Secure-" + suffix, value, "Secure; HttpOnly; SameSite=Lax");
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasValue() {
        return this.value != null && !this.value.isEmpty();
    }

    public boolean hasAttributes() {
        return this.attributes != null && !this.attributes.isEmpty();
    }

    public boolean isSecure() {
        return this.hasAttributes() && this.attributes.toLowerCase().contains("secure");
    }

    public boolean isHttpOnly() {
        return this.hasAttributes() && this.attributes.toLowerCase().contains("httponly");
    }

    public Optional<String> getDomain() {
        return this.extractAttributeValue("domain");
    }

    public Optional<String> getPath() {
        return this.extractAttributeValue("path");
    }

    public Optional<String> getSameSite() {
        return this.extractAttributeValue("samesite");
    }

    public Optional<String> getMaxAge() {
        return this.extractAttributeValue("max-age");
    }

    private Optional<String> extractAttributeValue(String attributeName) {
        if (!this.hasAttributes()) {
            return Optional.empty();
        }
        return AttributeParser.extractAttributeValue(this.attributes, attributeName);
    }

    public List<String> getAttributeNames() {
        if (!this.hasAttributes()) {
            return List.of();
        }
        return Arrays.stream(this.attributes.split(";")).map(String::trim).filter(attr -> !attr.isEmpty()).map(attr -> {
            int equalIndex = attr.indexOf(61);
            return equalIndex > 0 ? attr.substring(0, equalIndex).trim() : attr;
        }).toList();
    }

    public String nameOrDefault(String defaultName) {
        return this.name != null ? this.name : defaultName;
    }

    public String valueOrDefault(String defaultValue) {
        return this.value != null ? this.value : defaultValue;
    }

    public String toCookieString() {
        StringBuilder sb = new StringBuilder();
        if (this.name != null) {
            sb.append(this.name);
        }
        sb.append("=");
        if (this.value != null) {
            sb.append(this.value);
        }
        if (this.hasAttributes()) {
            sb.append("; ").append(this.attributes);
        }
        return sb.toString();
    }

    public Cookie withName(String newName) {
        return new Cookie(newName, this.value, this.attributes);
    }

    public Cookie withValue(String newValue) {
        return new Cookie(this.name, newValue, this.attributes);
    }

    public Cookie withAttributes(String newAttributes) {
        return new Cookie(this.name, this.value, newAttributes);
    }
}

