/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.core;

public enum UrlSecurityFailureType {
    INVALID_ENCODING("Invalid URL encoding detected"),
    DOUBLE_ENCODING("Double URL encoding detected"),
    UNICODE_NORMALIZATION_CHANGED("Unicode normalization altered input"),
    PATH_TRAVERSAL_DETECTED("Path traversal pattern detected"),
    DIRECTORY_ESCAPE_ATTEMPT("Directory escape attempt detected"),
    INVALID_CHARACTER("Invalid character detected"),
    NULL_BYTE_INJECTION("Null byte injection detected"),
    CONTROL_CHARACTERS("Control characters detected"),
    PATH_TOO_LONG("Path exceeds maximum length"),
    INPUT_TOO_LONG("Input exceeds maximum length"),
    EXCESSIVE_NESTING("Excessive directory nesting"),
    SUSPICIOUS_PATTERN_DETECTED("Suspicious pattern detected"),
    SUSPICIOUS_PARAMETER_NAME("Suspicious parameter name detected"),
    KNOWN_ATTACK_SIGNATURE("Known attack signature detected"),
    MALFORMED_INPUT("Malformed input structure"),
    INVALID_STRUCTURE("Invalid input structure"),
    PROTOCOL_VIOLATION("Protocol specification violation"),
    RFC_VIOLATION("RFC specification violation"),
    INVALID_IPV6_FORMAT("Invalid IPv6 address format"),
    MALFORMED_URL("Malformed URL structure"),
    INVALID_HOST_FORMAT("Invalid host format"),
    INVALID_URL_FORMAT("Invalid URL format"),
    COOKIE_PREFIX_VIOLATION("Cookie prefix requirements violated"),
    INVALID_INPUT("Invalid input");

    private final String description;

    private UrlSecurityFailureType(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isEncodingIssue() {
        return this == INVALID_ENCODING || this == DOUBLE_ENCODING || this == UNICODE_NORMALIZATION_CHANGED;
    }

    public boolean isPathTraversalAttack() {
        return this == PATH_TRAVERSAL_DETECTED || this == DIRECTORY_ESCAPE_ATTEMPT;
    }

    public boolean isCharacterAttack() {
        return this == INVALID_CHARACTER || this == NULL_BYTE_INJECTION || this == CONTROL_CHARACTERS;
    }

    public boolean isSizeViolation() {
        return this == PATH_TOO_LONG || this == INPUT_TOO_LONG || this == EXCESSIVE_NESTING;
    }

    public boolean isPatternBased() {
        return this == SUSPICIOUS_PATTERN_DETECTED || this == SUSPICIOUS_PARAMETER_NAME || this == KNOWN_ATTACK_SIGNATURE;
    }

    public boolean isStructuralIssue() {
        return this == MALFORMED_INPUT || this == INVALID_STRUCTURE;
    }

    public boolean isProtocolViolation() {
        return this == PROTOCOL_VIOLATION || this == RFC_VIOLATION;
    }

    public boolean isIPv6HostAttack() {
        return this == INVALID_IPV6_FORMAT || this == MALFORMED_URL || this == INVALID_HOST_FORMAT || this == INVALID_URL_FORMAT;
    }

    public boolean isCookieSecurityIssue() {
        return this == COOKIE_PREFIX_VIOLATION || this == INVALID_INPUT;
    }
}

