/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.core;

import de.cuioss.http.security.core.UrlSecurityFailureType;
import de.cuioss.http.security.core.ValidationType;
import de.cuioss.http.security.exceptions.UrlSecurityException;
import java.util.Optional;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;

@FunctionalInterface
public interface HttpSecurityValidator {
    public Optional<String> validate(@Nullable String var1) throws UrlSecurityException;

    default public HttpSecurityValidator andThen(HttpSecurityValidator after) {
        if (after == null) {
            throw new NullPointerException("after validator must not be null");
        }
        return value -> this.validate(value).flatMap(after::validate);
    }

    default public HttpSecurityValidator compose(HttpSecurityValidator before) {
        if (before == null) {
            throw new NullPointerException("before validator must not be null");
        }
        return value -> before.validate(value).flatMap(this::validate);
    }

    default public HttpSecurityValidator when(Predicate<String> predicate) {
        if (predicate == null) {
            throw new NullPointerException("predicate must not be null");
        }
        return value -> {
            if (value == null || !predicate.test(value)) {
                return Optional.ofNullable(value);
            }
            return this.validate(value);
        };
    }

    public static HttpSecurityValidator identity() {
        return Optional::ofNullable;
    }

    public static HttpSecurityValidator reject(UrlSecurityFailureType failureType, ValidationType validationType) {
        if (failureType == null) {
            throw new NullPointerException("failureType must not be null");
        }
        if (validationType == null) {
            throw new NullPointerException("validationType must not be null");
        }
        return value -> {
            throw UrlSecurityException.builder().failureType(failureType).validationType(validationType).originalInput(value != null ? value : "null").detail("Input unconditionally rejected").build();
        };
    }
}

