/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.config;

import de.cuioss.http.security.config.SecurityConfiguration;
import java.util.Set;

public final class SecurityDefaults {
    public static final int MAX_PATH_LENGTH_STRICT = 1024;
    public static final int MAX_PATH_LENGTH_DEFAULT = 4096;
    public static final int MAX_PATH_LENGTH_LENIENT = 8192;
    public static final Set<String> PATH_TRAVERSAL_PATTERNS = Set.of("../", "..\\", "..\\/", "..%2F", "..%5C", "%2E%2E/", "%2e%2e/", "%2E%2E%2F", "%2e%2e%2f", "%2e%2e%5c", "%2E%2E%5C", "%2f%2e%2e", "%5c%2e%2e", "%252e%252e%252f", "%252e%252e%255c", "%252e%252e/", "%252e%252e\\", "....//", "....\\\\", ".%2E/", ".%2e/", "..//", "..\\\\", "%2e%2e//", "%2e%2e\\\\", "..%2f/", "..%5c\\", "..%2f", "..%5c", "/%2e%2e/", "..%c0%af", "..%c1%9c", "%c0%ae%c0%ae%c0%af", "%c1%8s%c1%8s%c1%81");
    public static final Set<String> SUSPICIOUS_PATH_PATTERNS = Set.of("/etc/", "/proc/", "/sys/", "/dev/", "/boot/", "/root/", "\\windows\\", "\\system32\\", "\\users\\", "\\program files\\", "web.xml", "web.config", ".env", ".htaccess", ".htpasswd", "javascript:", "vbscript:", "data:", "file:");
    public static final int MAX_PARAMETER_COUNT_STRICT = 20;
    public static final int MAX_PARAMETER_COUNT_DEFAULT = 100;
    public static final int MAX_PARAMETER_COUNT_LENIENT = 500;
    public static final int MAX_PARAMETER_NAME_LENGTH_STRICT = 64;
    public static final int MAX_PARAMETER_NAME_LENGTH_DEFAULT = 128;
    public static final int MAX_PARAMETER_NAME_LENGTH_LENIENT = 256;
    public static final int MAX_PARAMETER_VALUE_LENGTH_STRICT = 1024;
    public static final int MAX_PARAMETER_VALUE_LENGTH_DEFAULT = 2048;
    public static final int MAX_PARAMETER_VALUE_LENGTH_LENIENT = 8192;
    public static final Set<String> SUSPICIOUS_PARAMETER_NAMES = Set.of("script", "include", "require", "file", "path", "url", "redirect", "forward");
    public static final int MAX_HEADER_COUNT_STRICT = 20;
    public static final int MAX_HEADER_COUNT_DEFAULT = 50;
    public static final int MAX_HEADER_COUNT_LENIENT = 100;
    public static final int MAX_HEADER_NAME_LENGTH_STRICT = 64;
    public static final int MAX_HEADER_NAME_LENGTH_DEFAULT = 128;
    public static final int MAX_HEADER_NAME_LENGTH_LENIENT = 256;
    public static final int MAX_HEADER_VALUE_LENGTH_STRICT = 1024;
    public static final int MAX_HEADER_VALUE_LENGTH_DEFAULT = 2048;
    public static final int MAX_HEADER_VALUE_LENGTH_LENIENT = 8192;
    public static final Set<String> DANGEROUS_HEADER_NAMES = Set.of("X-Debug", "X-Test", "X-Development", "X-Admin", "X-Execute", "X-Command", "X-Shell", "X-Eval", "Proxy-Authorization", "Proxy-Connection");
    public static final Set<String> DEBUG_HEADER_NAMES = Set.of("X-Debug", "X-Trace", "X-Profile", "X-Test-Mode", "X-Development", "X-Internal", "X-System-Info");
    public static final int MAX_COOKIE_COUNT_STRICT = 10;
    public static final int MAX_COOKIE_COUNT_DEFAULT = 20;
    public static final int MAX_COOKIE_COUNT_LENIENT = 50;
    public static final int MAX_COOKIE_NAME_LENGTH_STRICT = 64;
    public static final int MAX_COOKIE_NAME_LENGTH_DEFAULT = 128;
    public static final int MAX_COOKIE_NAME_LENGTH_LENIENT = 256;
    public static final int MAX_COOKIE_VALUE_LENGTH_STRICT = 1024;
    public static final int MAX_COOKIE_VALUE_LENGTH_DEFAULT = 2048;
    public static final int MAX_COOKIE_VALUE_LENGTH_LENIENT = 8192;
    public static final Set<String> SUSPICIOUS_COOKIE_NAMES = Set.of("debug", "test", "admin", "root", "system", "internal", "password", "secret", "token", "key", "auth", "session");
    public static final long MAX_BODY_SIZE_STRICT = 0x100000L;
    public static final long MAX_BODY_SIZE_DEFAULT = 0x500000L;
    public static final long MAX_BODY_SIZE_LENIENT = 0xA00000L;
    public static final Set<String> SAFE_CONTENT_TYPES = Set.of("application/json", "application/xml", "text/plain", "text/html", "application/x-www-form-urlencoded", "multipart/form-data", "text/css", "text/javascript", "application/javascript");
    public static final Set<String> DANGEROUS_CONTENT_TYPES = Set.of("application/octet-stream", "application/x-executable", "application/x-msdownload", "application/x-msdos-program", "application/x-java-archive", "application/java-archive", "text/x-script", "text/x-shellscript", "application/x-sh");
    public static final Set<String> UPLOAD_CONTENT_TYPES = Set.of("multipart/form-data", "application/octet-stream", "image/jpeg", "image/png", "image/gif", "image/webp", "application/pdf", "text/csv", "application/zip");
    public static final char NULL_BYTE = '\u0000';
    public static final Set<Character> PROBLEMATIC_CONTROL_CHARS = Set.of(Character.valueOf('\u0000'), Character.valueOf('\u0001'), Character.valueOf('\u0002'), Character.valueOf('\u0003'), Character.valueOf('\u0004'), Character.valueOf('\u0005'), Character.valueOf('\u0006'), Character.valueOf('\u0007'), Character.valueOf('\b'), Character.valueOf('\f'), Character.valueOf('\u000e'), Character.valueOf('\u000f'), Character.valueOf('\u0010'), Character.valueOf('\u0011'), Character.valueOf('\u0012'), Character.valueOf('\u0013'), Character.valueOf('\u0014'), Character.valueOf('\u0015'), Character.valueOf('\u0016'), Character.valueOf('\u0017'), Character.valueOf('\u0018'), Character.valueOf('\u0019'));
    public static final Set<Character> INJECTION_CHARACTERS = Set.of(Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('\''), Character.valueOf('\"'), Character.valueOf('&'), Character.valueOf(';'), Character.valueOf('|'), Character.valueOf('`'), Character.valueOf('$'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('{'), Character.valueOf('}'));
    public static final Set<String> DOUBLE_ENCODING_PATTERNS = Set.of("%25", "%2525", "%252e", "%252f", "%255c", "%2e%2e", "%2f%2e%2e", "%5c%2e%2e");
    public static final Set<String> UNICODE_NORMALIZATION_FORMS = Set.of("NFC", "NFD", "NFKC", "NFKD");
    public static final SecurityConfiguration STRICT_CONFIGURATION = SecurityConfiguration.builder().maxPathLength(1024).allowPathTraversal(false).allowDoubleEncoding(false).maxParameterCount(20).maxParameterNameLength(64).maxParameterValueLength(1024).maxHeaderCount(20).maxHeaderNameLength(64).maxHeaderValueLength(1024).blockedHeaderNames(DANGEROUS_HEADER_NAMES).maxCookieCount(10).maxCookieNameLength(64).maxCookieValueLength(1024).requireSecureCookies(true).requireHttpOnlyCookies(true).maxBodySize(0x100000L).allowedContentTypes(SAFE_CONTENT_TYPES).allowNullBytes(false).allowControlCharacters(false).allowExtendedAscii(false).normalizeUnicode(true).caseSensitiveComparison(true).failOnSuspiciousPatterns(true).logSecurityViolations(true).build();
    public static final SecurityConfiguration DEFAULT_CONFIGURATION = SecurityConfiguration.builder().maxPathLength(4096).allowPathTraversal(false).allowDoubleEncoding(false).maxParameterCount(100).maxParameterNameLength(128).maxParameterValueLength(2048).maxHeaderCount(50).maxHeaderNameLength(128).maxHeaderValueLength(2048).blockedHeaderNames(DEBUG_HEADER_NAMES).maxCookieCount(20).maxCookieNameLength(128).maxCookieValueLength(2048).requireSecureCookies(false).requireHttpOnlyCookies(false).maxBodySize(0x500000L).blockedContentTypes(DANGEROUS_CONTENT_TYPES).allowNullBytes(false).allowControlCharacters(false).allowExtendedAscii(true).normalizeUnicode(false).caseSensitiveComparison(false).failOnSuspiciousPatterns(false).logSecurityViolations(true).build();
    public static final SecurityConfiguration LENIENT_CONFIGURATION = SecurityConfiguration.builder().maxPathLength(8192).allowPathTraversal(false).allowDoubleEncoding(true).maxParameterCount(500).maxParameterNameLength(256).maxParameterValueLength(8192).maxHeaderCount(100).maxHeaderNameLength(256).maxHeaderValueLength(8192).maxCookieCount(50).maxCookieNameLength(256).maxCookieValueLength(8192).requireSecureCookies(false).requireHttpOnlyCookies(false).maxBodySize(0xA00000L).blockedContentTypes(Set.of("application/x-executable", "application/x-msdos-program")).allowNullBytes(false).allowControlCharacters(true).allowExtendedAscii(true).normalizeUnicode(false).caseSensitiveComparison(false).failOnSuspiciousPatterns(false).logSecurityViolations(true).build();

    private SecurityDefaults() {
    }
}

