/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.config;

import de.cuioss.http.security.config.SecurityConfiguration;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.Nullable;

public class SecurityConfigurationBuilder {
    private int maxPathLength = 4096;
    private boolean allowPathTraversal = false;
    private boolean allowDoubleEncoding = false;
    private int maxParameterCount = 100;
    private int maxParameterNameLength = 128;
    private int maxParameterValueLength = 2048;
    private int maxHeaderCount = 50;
    private int maxHeaderNameLength = 128;
    private int maxHeaderValueLength = 2048;
    private @Nullable Set<String> allowedHeaderNames = null;
    private Set<String> blockedHeaderNames = new HashSet<String>();
    private int maxCookieCount = 20;
    private int maxCookieNameLength = 128;
    private int maxCookieValueLength = 2048;
    private boolean requireSecureCookies = false;
    private boolean requireHttpOnlyCookies = false;
    private long maxBodySize = 0x500000L;
    private @Nullable Set<String> allowedContentTypes = null;
    private Set<String> blockedContentTypes = new HashSet<String>();
    private boolean allowNullBytes = false;
    private boolean allowControlCharacters = false;
    private boolean allowExtendedAscii = true;
    private boolean normalizeUnicode = false;
    private boolean caseSensitiveComparison = false;
    private boolean failOnSuspiciousPatterns = false;
    private boolean logSecurityViolations = true;

    SecurityConfigurationBuilder() {
    }

    public SecurityConfigurationBuilder maxPathLength(int maxLength) {
        if (maxLength <= 0) {
            throw new IllegalArgumentException("maxPathLength must be positive, got: " + maxLength);
        }
        this.maxPathLength = maxLength;
        return this;
    }

    public SecurityConfigurationBuilder allowPathTraversal(boolean allow) {
        this.allowPathTraversal = allow;
        return this;
    }

    public SecurityConfigurationBuilder allowDoubleEncoding(boolean allow) {
        this.allowDoubleEncoding = allow;
        return this;
    }

    public SecurityConfigurationBuilder pathSecurity(int maxLength, boolean allowTraversal) {
        return this.maxPathLength(maxLength).allowPathTraversal(allowTraversal);
    }

    public SecurityConfigurationBuilder maxParameterCount(int maxCount) {
        if (maxCount < 0) {
            throw new IllegalArgumentException("maxParameterCount must be non-negative, got: " + maxCount);
        }
        this.maxParameterCount = maxCount;
        return this;
    }

    public SecurityConfigurationBuilder maxParameterNameLength(int maxLength) {
        if (maxLength <= 0) {
            throw new IllegalArgumentException("maxParameterNameLength must be positive, got: " + maxLength);
        }
        this.maxParameterNameLength = maxLength;
        return this;
    }

    public SecurityConfigurationBuilder maxParameterValueLength(int maxLength) {
        if (maxLength <= 0) {
            throw new IllegalArgumentException("maxParameterValueLength must be positive, got: " + maxLength);
        }
        this.maxParameterValueLength = maxLength;
        return this;
    }

    public SecurityConfigurationBuilder parameterSecurity(int maxCount, int maxNameLength, int maxValueLength) {
        return this.maxParameterCount(maxCount).maxParameterNameLength(maxNameLength).maxParameterValueLength(maxValueLength);
    }

    public SecurityConfigurationBuilder maxHeaderCount(int maxCount) {
        if (maxCount < 0) {
            throw new IllegalArgumentException("maxHeaderCount must be non-negative, got: " + maxCount);
        }
        this.maxHeaderCount = maxCount;
        return this;
    }

    public SecurityConfigurationBuilder maxHeaderNameLength(int maxLength) {
        if (maxLength <= 0) {
            throw new IllegalArgumentException("maxHeaderNameLength must be positive, got: " + maxLength);
        }
        this.maxHeaderNameLength = maxLength;
        return this;
    }

    public SecurityConfigurationBuilder maxHeaderValueLength(int maxLength) {
        if (maxLength <= 0) {
            throw new IllegalArgumentException("maxHeaderValueLength must be positive, got: " + maxLength);
        }
        this.maxHeaderValueLength = maxLength;
        return this;
    }

    public SecurityConfigurationBuilder addAllowedHeaderName(String headerName) {
        Objects.requireNonNull(headerName, "headerName must not be null");
        if (this.allowedHeaderNames == null) {
            this.allowedHeaderNames = new HashSet<String>();
        }
        this.allowedHeaderNames.add(headerName);
        return this;
    }

    public SecurityConfigurationBuilder allowedHeaderNames(@Nullable Set<String> headerNames) {
        this.allowedHeaderNames = headerNames != null ? new HashSet<String>(headerNames) : null;
        return this;
    }

    public SecurityConfigurationBuilder addBlockedHeaderName(String headerName) {
        Objects.requireNonNull(headerName, "headerName must not be null");
        this.blockedHeaderNames.add(headerName);
        return this;
    }

    public SecurityConfigurationBuilder blockedHeaderNames(Set<String> headerNames) {
        Objects.requireNonNull(headerNames, "headerNames must not be null");
        this.blockedHeaderNames = new HashSet<String>(headerNames);
        return this;
    }

    public SecurityConfigurationBuilder headerSecurity(int maxCount, int maxNameLength, int maxValueLength) {
        return this.maxHeaderCount(maxCount).maxHeaderNameLength(maxNameLength).maxHeaderValueLength(maxValueLength);
    }

    public SecurityConfigurationBuilder maxCookieCount(int maxCount) {
        if (maxCount < 0) {
            throw new IllegalArgumentException("maxCookieCount must be non-negative, got: " + maxCount);
        }
        this.maxCookieCount = maxCount;
        return this;
    }

    public SecurityConfigurationBuilder maxCookieNameLength(int maxLength) {
        if (maxLength <= 0) {
            throw new IllegalArgumentException("maxCookieNameLength must be positive, got: " + maxLength);
        }
        this.maxCookieNameLength = maxLength;
        return this;
    }

    public SecurityConfigurationBuilder maxCookieValueLength(int maxLength) {
        if (maxLength <= 0) {
            throw new IllegalArgumentException("maxCookieValueLength must be positive, got: " + maxLength);
        }
        this.maxCookieValueLength = maxLength;
        return this;
    }

    public SecurityConfigurationBuilder requireSecureCookies(boolean require) {
        this.requireSecureCookies = require;
        return this;
    }

    public SecurityConfigurationBuilder requireHttpOnlyCookies(boolean require) {
        this.requireHttpOnlyCookies = require;
        return this;
    }

    public SecurityConfigurationBuilder cookieSecurity(boolean requireSecure, boolean requireHttpOnly, int maxCount, int maxNameLength, int maxValueLength) {
        return this.requireSecureCookies(requireSecure).requireHttpOnlyCookies(requireHttpOnly).maxCookieCount(maxCount).maxCookieNameLength(maxNameLength).maxCookieValueLength(maxValueLength);
    }

    public SecurityConfigurationBuilder maxBodySize(long maxSize) {
        if (maxSize < 0L) {
            throw new IllegalArgumentException("maxBodySize must be non-negative, got: " + maxSize);
        }
        this.maxBodySize = maxSize;
        return this;
    }

    public SecurityConfigurationBuilder addAllowedContentType(String contentType) {
        Objects.requireNonNull(contentType, "contentType must not be null");
        if (this.allowedContentTypes == null) {
            this.allowedContentTypes = new HashSet<String>();
        }
        this.allowedContentTypes.add(contentType);
        return this;
    }

    public SecurityConfigurationBuilder allowedContentTypes(@Nullable Set<String> contentTypes) {
        this.allowedContentTypes = contentTypes != null ? new HashSet<String>(contentTypes) : null;
        return this;
    }

    public SecurityConfigurationBuilder addBlockedContentType(String contentType) {
        Objects.requireNonNull(contentType, "contentType must not be null");
        this.blockedContentTypes.add(contentType);
        return this;
    }

    public SecurityConfigurationBuilder blockedContentTypes(Set<String> contentTypes) {
        Objects.requireNonNull(contentTypes, "contentTypes must not be null");
        this.blockedContentTypes = new HashSet<String>(contentTypes);
        return this;
    }

    public SecurityConfigurationBuilder bodySecurity(long maxSize, @Nullable Set<String> allowedTypes) {
        return this.maxBodySize(maxSize).allowedContentTypes(allowedTypes);
    }

    public SecurityConfigurationBuilder allowNullBytes(boolean allow) {
        this.allowNullBytes = allow;
        return this;
    }

    public SecurityConfigurationBuilder allowControlCharacters(boolean allow) {
        this.allowControlCharacters = allow;
        return this;
    }

    public SecurityConfigurationBuilder allowExtendedAscii(boolean allow) {
        this.allowExtendedAscii = allow;
        return this;
    }

    public SecurityConfigurationBuilder normalizeUnicode(boolean normalize) {
        this.normalizeUnicode = normalize;
        return this;
    }

    public SecurityConfigurationBuilder encoding(boolean allowNulls, boolean allowControls, boolean allowHighBit, boolean normalizeUni) {
        return this.allowNullBytes(allowNulls).allowControlCharacters(allowControls).allowExtendedAscii(allowHighBit).normalizeUnicode(normalizeUni);
    }

    public SecurityConfigurationBuilder caseSensitiveComparison(boolean caseSensitive) {
        this.caseSensitiveComparison = caseSensitive;
        return this;
    }

    public SecurityConfigurationBuilder failOnSuspiciousPatterns(boolean fail) {
        this.failOnSuspiciousPatterns = fail;
        return this;
    }

    public SecurityConfigurationBuilder logSecurityViolations(boolean log) {
        this.logSecurityViolations = log;
        return this;
    }

    public SecurityConfigurationBuilder policies(boolean caseSensitive, boolean failOnSuspicious, boolean logViolations) {
        return this.caseSensitiveComparison(caseSensitive).failOnSuspiciousPatterns(failOnSuspicious).logSecurityViolations(logViolations);
    }

    public SecurityConfiguration build() {
        return new SecurityConfiguration(this.maxPathLength, this.allowPathTraversal, this.allowDoubleEncoding, this.maxParameterCount, this.maxParameterNameLength, this.maxParameterValueLength, this.maxHeaderCount, this.maxHeaderNameLength, this.maxHeaderValueLength, this.allowedHeaderNames, this.blockedHeaderNames, this.maxCookieCount, this.maxCookieNameLength, this.maxCookieValueLength, this.requireSecureCookies, this.requireHttpOnlyCookies, this.maxBodySize, this.allowedContentTypes, this.blockedContentTypes, this.allowNullBytes, this.allowControlCharacters, this.allowExtendedAscii, this.normalizeUnicode, this.caseSensitiveComparison, this.failOnSuspiciousPatterns, this.logSecurityViolations);
    }
}

