/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.config;

import de.cuioss.http.security.config.SecurityConfigurationBuilder;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;

public final class SecurityConfiguration {
    private final int maxPathLength;
    private final boolean allowPathTraversal;
    private final boolean allowDoubleEncoding;
    private final int maxParameterCount;
    private final int maxParameterNameLength;
    private final int maxParameterValueLength;
    private final int maxHeaderCount;
    private final int maxHeaderNameLength;
    private final int maxHeaderValueLength;
    private final @Nullable Set<String> allowedHeaderNames;
    private final Set<String> blockedHeaderNames;
    private final int maxCookieCount;
    private final int maxCookieNameLength;
    private final int maxCookieValueLength;
    private final boolean requireSecureCookies;
    private final boolean requireHttpOnlyCookies;
    private final long maxBodySize;
    private final @Nullable Set<String> allowedContentTypes;
    private final Set<String> blockedContentTypes;
    private final boolean allowNullBytes;
    private final boolean allowControlCharacters;
    private final boolean allowExtendedAscii;
    private final boolean normalizeUnicode;
    private final boolean caseSensitiveComparison;
    private final boolean failOnSuspiciousPatterns;
    private final boolean logSecurityViolations;
    private final @Nullable Set<String> allowedHeaderNamesLowercase;
    private final Set<String> blockedHeaderNamesLowercase;
    private final @Nullable Set<String> allowedContentTypesLowercase;
    private final Set<String> blockedContentTypesLowercase;

    SecurityConfiguration(int maxPathLength, boolean allowPathTraversal, boolean allowDoubleEncoding, int maxParameterCount, int maxParameterNameLength, int maxParameterValueLength, int maxHeaderCount, int maxHeaderNameLength, int maxHeaderValueLength, @Nullable Set<String> allowedHeaderNames, Set<String> blockedHeaderNames, int maxCookieCount, int maxCookieNameLength, int maxCookieValueLength, boolean requireSecureCookies, boolean requireHttpOnlyCookies, long maxBodySize, @Nullable Set<String> allowedContentTypes, Set<String> blockedContentTypes, boolean allowNullBytes, boolean allowControlCharacters, boolean allowExtendedAscii, boolean normalizeUnicode, boolean caseSensitiveComparison, boolean failOnSuspiciousPatterns, boolean logSecurityViolations) {
        if (maxPathLength <= 0) {
            throw new IllegalArgumentException("maxPathLength must be positive, got: " + maxPathLength);
        }
        if (maxParameterCount < 0) {
            throw new IllegalArgumentException("maxParameterCount must be non-negative, got: " + maxParameterCount);
        }
        if (maxParameterNameLength <= 0) {
            throw new IllegalArgumentException("maxParameterNameLength must be positive, got: " + maxParameterNameLength);
        }
        if (maxParameterValueLength <= 0) {
            throw new IllegalArgumentException("maxParameterValueLength must be positive, got: " + maxParameterValueLength);
        }
        if (maxHeaderCount < 0) {
            throw new IllegalArgumentException("maxHeaderCount must be non-negative, got: " + maxHeaderCount);
        }
        if (maxHeaderNameLength <= 0) {
            throw new IllegalArgumentException("maxHeaderNameLength must be positive, got: " + maxHeaderNameLength);
        }
        if (maxHeaderValueLength <= 0) {
            throw new IllegalArgumentException("maxHeaderValueLength must be positive, got: " + maxHeaderValueLength);
        }
        if (maxCookieCount < 0) {
            throw new IllegalArgumentException("maxCookieCount must be non-negative, got: " + maxCookieCount);
        }
        if (maxCookieNameLength <= 0) {
            throw new IllegalArgumentException("maxCookieNameLength must be positive, got: " + maxCookieNameLength);
        }
        if (maxCookieValueLength <= 0) {
            throw new IllegalArgumentException("maxCookieValueLength must be positive, got: " + maxCookieValueLength);
        }
        if (maxBodySize < 0L) {
            throw new IllegalArgumentException("maxBodySize must be non-negative, got: " + maxBodySize);
        }
        this.maxPathLength = maxPathLength;
        this.allowPathTraversal = allowPathTraversal;
        this.allowDoubleEncoding = allowDoubleEncoding;
        this.maxParameterCount = maxParameterCount;
        this.maxParameterNameLength = maxParameterNameLength;
        this.maxParameterValueLength = maxParameterValueLength;
        this.maxHeaderCount = maxHeaderCount;
        this.maxHeaderNameLength = maxHeaderNameLength;
        this.maxHeaderValueLength = maxHeaderValueLength;
        this.maxCookieCount = maxCookieCount;
        this.maxCookieNameLength = maxCookieNameLength;
        this.maxCookieValueLength = maxCookieValueLength;
        this.requireSecureCookies = requireSecureCookies;
        this.requireHttpOnlyCookies = requireHttpOnlyCookies;
        this.maxBodySize = maxBodySize;
        this.allowNullBytes = allowNullBytes;
        this.allowControlCharacters = allowControlCharacters;
        this.allowExtendedAscii = allowExtendedAscii;
        this.normalizeUnicode = normalizeUnicode;
        this.caseSensitiveComparison = caseSensitiveComparison;
        this.failOnSuspiciousPatterns = failOnSuspiciousPatterns;
        this.logSecurityViolations = logSecurityViolations;
        this.allowedHeaderNames = allowedHeaderNames != null ? Set.copyOf(allowedHeaderNames) : null;
        this.blockedHeaderNames = Set.copyOf(blockedHeaderNames);
        this.allowedContentTypes = allowedContentTypes != null ? Set.copyOf(allowedContentTypes) : null;
        this.blockedContentTypes = Set.copyOf(blockedContentTypes);
        if (!caseSensitiveComparison) {
            this.allowedHeaderNamesLowercase = this.allowedHeaderNames != null ? this.allowedHeaderNames.stream().map(String::toLowerCase).collect(Collectors.toUnmodifiableSet()) : null;
            this.blockedHeaderNamesLowercase = this.blockedHeaderNames.stream().map(String::toLowerCase).collect(Collectors.toUnmodifiableSet());
            this.allowedContentTypesLowercase = this.allowedContentTypes != null ? this.allowedContentTypes.stream().map(String::toLowerCase).collect(Collectors.toUnmodifiableSet()) : null;
            this.blockedContentTypesLowercase = this.blockedContentTypes.stream().map(String::toLowerCase).collect(Collectors.toUnmodifiableSet());
        } else {
            this.allowedHeaderNamesLowercase = null;
            this.blockedHeaderNamesLowercase = Set.of();
            this.allowedContentTypesLowercase = null;
            this.blockedContentTypesLowercase = Set.of();
        }
    }

    public static SecurityConfigurationBuilder builder() {
        return new SecurityConfigurationBuilder();
    }

    public static SecurityConfiguration strict() {
        return SecurityConfiguration.builder().maxPathLength(1024).allowPathTraversal(false).allowDoubleEncoding(false).maxParameterCount(50).maxParameterNameLength(100).maxParameterValueLength(1024).maxHeaderCount(50).maxHeaderNameLength(100).maxHeaderValueLength(4096).maxCookieCount(20).maxCookieNameLength(100).maxCookieValueLength(4096).requireSecureCookies(true).requireHttpOnlyCookies(true).maxBodySize(0xA00000L).allowNullBytes(false).allowControlCharacters(false).allowExtendedAscii(false).normalizeUnicode(true).caseSensitiveComparison(true).failOnSuspiciousPatterns(true).logSecurityViolations(true).build();
    }

    public static SecurityConfiguration lenient() {
        return SecurityConfiguration.builder().maxPathLength(8192).allowPathTraversal(true).allowDoubleEncoding(true).maxParameterCount(1000).maxParameterNameLength(512).maxParameterValueLength(8192).maxHeaderCount(200).maxHeaderNameLength(512).maxHeaderValueLength(16384).maxCookieCount(100).maxCookieNameLength(512).maxCookieValueLength(8192).requireSecureCookies(false).requireHttpOnlyCookies(false).maxBodySize(0x6400000L).allowNullBytes(true).allowControlCharacters(true).allowExtendedAscii(true).normalizeUnicode(false).caseSensitiveComparison(false).failOnSuspiciousPatterns(false).logSecurityViolations(false).build();
    }

    public static SecurityConfiguration defaults() {
        return SecurityConfiguration.builder().build();
    }

    public boolean isHeaderAllowed(@Nullable String headerName) {
        return this.isAllowed(headerName, this.allowedHeaderNames, this.blockedHeaderNames, this.allowedHeaderNamesLowercase, this.blockedHeaderNamesLowercase);
    }

    public boolean isContentTypeAllowed(@Nullable String contentType) {
        return this.isAllowed(contentType, this.allowedContentTypes, this.blockedContentTypes, this.allowedContentTypesLowercase, this.blockedContentTypesLowercase);
    }

    private boolean isAllowed(@Nullable String value, @Nullable Set<String> allowedSet, Set<String> blockedSet, @Nullable Set<String> allowedSetLowercase, Set<String> blockedSetLowercase) {
        if (value == null) {
            return false;
        }
        if (this.caseSensitiveComparison) {
            if (blockedSet.contains(value)) {
                return false;
            }
            if (allowedSet != null) {
                return allowedSet.contains(value);
            }
            return true;
        }
        String valueLowercase = value.toLowerCase();
        if (blockedSetLowercase.contains(valueLowercase)) {
            return false;
        }
        if (allowedSetLowercase != null) {
            return allowedSetLowercase.contains(valueLowercase);
        }
        return true;
    }

    public boolean isStrict() {
        return !this.allowPathTraversal && !this.allowDoubleEncoding && !this.allowNullBytes && !this.allowControlCharacters && !this.allowExtendedAscii && this.normalizeUnicode && this.failOnSuspiciousPatterns;
    }

    public boolean isLenient() {
        return this.allowPathTraversal && this.allowDoubleEncoding && this.allowNullBytes && this.allowControlCharacters && this.allowExtendedAscii && !this.normalizeUnicode && !this.failOnSuspiciousPatterns;
    }

    public int maxPathLength() {
        return this.maxPathLength;
    }

    public boolean allowPathTraversal() {
        return this.allowPathTraversal;
    }

    public boolean allowDoubleEncoding() {
        return this.allowDoubleEncoding;
    }

    public int maxParameterCount() {
        return this.maxParameterCount;
    }

    public int maxParameterNameLength() {
        return this.maxParameterNameLength;
    }

    public int maxParameterValueLength() {
        return this.maxParameterValueLength;
    }

    public int maxHeaderCount() {
        return this.maxHeaderCount;
    }

    public int maxHeaderNameLength() {
        return this.maxHeaderNameLength;
    }

    public int maxHeaderValueLength() {
        return this.maxHeaderValueLength;
    }

    public @Nullable Set<String> allowedHeaderNames() {
        return this.allowedHeaderNames;
    }

    public Set<String> blockedHeaderNames() {
        return this.blockedHeaderNames;
    }

    public int maxCookieCount() {
        return this.maxCookieCount;
    }

    public int maxCookieNameLength() {
        return this.maxCookieNameLength;
    }

    public int maxCookieValueLength() {
        return this.maxCookieValueLength;
    }

    public boolean requireSecureCookies() {
        return this.requireSecureCookies;
    }

    public boolean requireHttpOnlyCookies() {
        return this.requireHttpOnlyCookies;
    }

    public long maxBodySize() {
        return this.maxBodySize;
    }

    public @Nullable Set<String> allowedContentTypes() {
        return this.allowedContentTypes;
    }

    public Set<String> blockedContentTypes() {
        return this.blockedContentTypes;
    }

    public boolean allowNullBytes() {
        return this.allowNullBytes;
    }

    public boolean allowControlCharacters() {
        return this.allowControlCharacters;
    }

    public boolean allowExtendedAscii() {
        return this.allowExtendedAscii;
    }

    public boolean normalizeUnicode() {
        return this.normalizeUnicode;
    }

    public boolean caseSensitiveComparison() {
        return this.caseSensitiveComparison;
    }

    public boolean failOnSuspiciousPatterns() {
        return this.failOnSuspiciousPatterns;
    }

    public boolean logSecurityViolations() {
        return this.logSecurityViolations;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SecurityConfiguration)) {
            return false;
        }
        SecurityConfiguration other = (SecurityConfiguration)obj;
        return this.maxPathLength == other.maxPathLength && this.allowPathTraversal == other.allowPathTraversal && this.allowDoubleEncoding == other.allowDoubleEncoding && this.maxParameterCount == other.maxParameterCount && this.maxParameterNameLength == other.maxParameterNameLength && this.maxParameterValueLength == other.maxParameterValueLength && this.maxHeaderCount == other.maxHeaderCount && this.maxHeaderNameLength == other.maxHeaderNameLength && this.maxHeaderValueLength == other.maxHeaderValueLength && this.maxCookieCount == other.maxCookieCount && this.maxCookieNameLength == other.maxCookieNameLength && this.maxCookieValueLength == other.maxCookieValueLength && this.requireSecureCookies == other.requireSecureCookies && this.requireHttpOnlyCookies == other.requireHttpOnlyCookies && this.maxBodySize == other.maxBodySize && this.allowNullBytes == other.allowNullBytes && this.allowControlCharacters == other.allowControlCharacters && this.allowExtendedAscii == other.allowExtendedAscii && this.normalizeUnicode == other.normalizeUnicode && this.caseSensitiveComparison == other.caseSensitiveComparison && this.failOnSuspiciousPatterns == other.failOnSuspiciousPatterns && this.logSecurityViolations == other.logSecurityViolations && Objects.equals(this.allowedHeaderNames, other.allowedHeaderNames) && Objects.equals(this.blockedHeaderNames, other.blockedHeaderNames) && Objects.equals(this.allowedContentTypes, other.allowedContentTypes) && Objects.equals(this.blockedContentTypes, other.blockedContentTypes);
    }

    public int hashCode() {
        return Objects.hash(this.maxPathLength, this.allowPathTraversal, this.allowDoubleEncoding, this.maxParameterCount, this.maxParameterNameLength, this.maxParameterValueLength, this.maxHeaderCount, this.maxHeaderNameLength, this.maxHeaderValueLength, this.allowedHeaderNames, this.blockedHeaderNames, this.maxCookieCount, this.maxCookieNameLength, this.maxCookieValueLength, this.requireSecureCookies, this.requireHttpOnlyCookies, this.maxBodySize, this.allowedContentTypes, this.blockedContentTypes, this.allowNullBytes, this.allowControlCharacters, this.allowExtendedAscii, this.normalizeUnicode, this.caseSensitiveComparison, this.failOnSuspiciousPatterns, this.logSecurityViolations);
    }

    public String toString() {
        return "SecurityConfiguration{maxPathLength=" + this.maxPathLength + ", allowPathTraversal=" + this.allowPathTraversal + ", allowDoubleEncoding=" + this.allowDoubleEncoding + ", maxParameterCount=" + this.maxParameterCount + ", maxParameterNameLength=" + this.maxParameterNameLength + ", maxParameterValueLength=" + this.maxParameterValueLength + ", maxHeaderCount=" + this.maxHeaderCount + ", maxHeaderNameLength=" + this.maxHeaderNameLength + ", maxHeaderValueLength=" + this.maxHeaderValueLength + ", allowedHeaderNames=" + String.valueOf(this.allowedHeaderNames) + ", blockedHeaderNames=" + String.valueOf(this.blockedHeaderNames) + ", maxCookieCount=" + this.maxCookieCount + ", maxCookieNameLength=" + this.maxCookieNameLength + ", maxCookieValueLength=" + this.maxCookieValueLength + ", requireSecureCookies=" + this.requireSecureCookies + ", requireHttpOnlyCookies=" + this.requireHttpOnlyCookies + ", maxBodySize=" + this.maxBodySize + ", allowedContentTypes=" + String.valueOf(this.allowedContentTypes) + ", blockedContentTypes=" + String.valueOf(this.blockedContentTypes) + ", allowNullBytes=" + this.allowNullBytes + ", allowControlCharacters=" + this.allowControlCharacters + ", allowExtendedAscii=" + this.allowExtendedAscii + ", normalizeUnicode=" + this.normalizeUnicode + ", caseSensitiveComparison=" + this.caseSensitiveComparison + ", failOnSuspiciousPatterns=" + this.failOnSuspiciousPatterns + ", logSecurityViolations=" + this.logSecurityViolations + "}";
    }
}

