/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.client.result;

import de.cuioss.http.client.result.HttpErrorCategory;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public sealed interface HttpResult<T> {
    public boolean isSuccess();

    default public boolean isRetryable() {
        return this.getErrorCategory().map(HttpErrorCategory::isRetryable).orElse(false);
    }

    public Optional<T> getContent();

    public Optional<String> getETag();

    public Optional<Integer> getHttpStatus();

    default public Optional<String> getErrorMessage() {
        return Optional.empty();
    }

    default public Optional<Throwable> getCause() {
        return Optional.empty();
    }

    public Optional<HttpErrorCategory> getErrorCategory();

    public <U> HttpResult<U> map(Function<T, U> var1);

    public static <T> HttpResult<T> success(T content, @Nullable String etag, int httpStatus) {
        return new Success<T>(content, etag, httpStatus);
    }

    public static <T> HttpResult<T> failure(String errorMessage, @Nullable Throwable cause, HttpErrorCategory category) {
        return new Failure<Object>(errorMessage, cause, null, category, null, null);
    }

    public static <T> HttpResult<T> failureWithFallback(String errorMessage, @Nullable Throwable cause, @Nullable T fallbackContent, HttpErrorCategory category, @Nullable String cachedEtag, @Nullable Integer httpStatus) {
        return new Failure<T>(errorMessage, cause, fallbackContent, category, cachedEtag, httpStatus);
    }

    public record Success<T>(T content, @Nullable String etag, int httpStatus) implements HttpResult<T>
    {
        @Override
        public boolean isSuccess() {
            return true;
        }

        @Override
        public Optional<T> getContent() {
            return Optional.of(this.content);
        }

        @Override
        public Optional<String> getETag() {
            return Optional.ofNullable(this.etag);
        }

        @Override
        public Optional<Integer> getHttpStatus() {
            return Optional.of(this.httpStatus);
        }

        @Override
        public Optional<HttpErrorCategory> getErrorCategory() {
            return Optional.empty();
        }

        @Override
        public <U> HttpResult<U> map(Function<T, U> mapper) {
            return new Success<U>(mapper.apply(this.content), this.etag, this.httpStatus);
        }
    }

    public record Failure<T>(String errorMessage, @Nullable Throwable cause, @Nullable T fallbackContent, HttpErrorCategory category, @Nullable String etag, @Nullable Integer httpStatus) implements HttpResult<T>
    {
        @Override
        public boolean isSuccess() {
            return false;
        }

        @Override
        public Optional<T> getContent() {
            return Optional.ofNullable(this.fallbackContent);
        }

        @Override
        public Optional<String> getETag() {
            return Optional.ofNullable(this.etag);
        }

        @Override
        public Optional<Integer> getHttpStatus() {
            return Optional.ofNullable(this.httpStatus);
        }

        @Override
        public Optional<String> getErrorMessage() {
            return Optional.of(this.errorMessage);
        }

        @Override
        public Optional<Throwable> getCause() {
            return Optional.ofNullable(this.cause);
        }

        @Override
        public Optional<HttpErrorCategory> getErrorCategory() {
            return Optional.of(this.category);
        }

        @Override
        public <U> HttpResult<U> map(Function<T, U> mapper) {
            T mappedFallback = this.fallbackContent != null ? (T)mapper.apply(this.fallbackContent) : null;
            return new Failure<Object>(this.errorMessage, this.cause, mappedFallback, this.category, this.etag, this.httpStatus);
        }

        @Generated
        public static <T> FailureBuilder<T> builder() {
            return new FailureBuilder();
        }

        @Generated
        public static class FailureBuilder<T> {
            @Generated
            private String errorMessage;
            @Generated
            private Throwable cause;
            @Generated
            private T fallbackContent;
            @Generated
            private HttpErrorCategory category;
            @Generated
            private String etag;
            @Generated
            private Integer httpStatus;

            @Generated
            FailureBuilder() {
            }

            @Generated
            public FailureBuilder<T> errorMessage(String errorMessage) {
                this.errorMessage = errorMessage;
                return this;
            }

            @Generated
            public FailureBuilder<T> cause(@Nullable Throwable cause) {
                this.cause = cause;
                return this;
            }

            @Generated
            public FailureBuilder<T> fallbackContent(@Nullable T fallbackContent) {
                this.fallbackContent = fallbackContent;
                return this;
            }

            @Generated
            public FailureBuilder<T> category(HttpErrorCategory category) {
                this.category = category;
                return this;
            }

            @Generated
            public FailureBuilder<T> etag(@Nullable String etag) {
                this.etag = etag;
                return this;
            }

            @Generated
            public FailureBuilder<T> httpStatus(@Nullable Integer httpStatus) {
                this.httpStatus = httpStatus;
                return this;
            }

            @Generated
            public Failure<T> build() {
                return new Failure<T>(this.errorMessage, this.cause, this.fallbackContent, this.category, this.etag, this.httpStatus);
            }

            @Generated
            public String toString() {
                return "HttpResult.Failure.FailureBuilder(errorMessage=" + this.errorMessage + ", cause=" + String.valueOf(this.cause) + ", fallbackContent=" + String.valueOf(this.fallbackContent) + ", category=" + String.valueOf((Object)this.category) + ", etag=" + this.etag + ", httpStatus=" + this.httpStatus + ")";
            }
        }
    }
}

