/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.client.handler;

import de.cuioss.http.client.HttpLogMessages;
import de.cuioss.tools.collect.CollectionLiterals;
import de.cuioss.tools.logging.CuiLogger;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.jspecify.annotations.Nullable;

public record SecureSSLContextProvider(String minimumTlsVersion) {
    private static final CuiLogger LOGGER = new CuiLogger(SecureSSLContextProvider.class);
    public static final String TLS_V1_2 = "TLSv1.2";
    public static final String TLS_V1_3 = "TLSv1.3";
    public static final String TLS = "TLS";
    public static final String DEFAULT_TLS_VERSION = "TLSv1.2";
    public static final String TLS_V1_0 = "TLSv1.0";
    public static final String TLS_V1_1 = "TLSv1.1";
    public static final String SSL_V3 = "SSLv3";
    public static final Set<String> ALLOWED_TLS_VERSIONS = CollectionLiterals.immutableSet((Object[])new String[]{"TLSv1.2", "TLSv1.3", "TLS"});
    public static final Set<String> FORBIDDEN_TLS_VERSIONS = CollectionLiterals.immutableSet((Object[])new String[]{"TLSv1.0", "TLSv1.1", "SSLv3"});

    public SecureSSLContextProvider() {
        this("TLSv1.2");
    }

    public SecureSSLContextProvider {
        if (!ALLOWED_TLS_VERSIONS.contains(minimumTlsVersion)) {
            throw new IllegalArgumentException("Minimum TLS version must be one of the allowed versions: " + String.valueOf(ALLOWED_TLS_VERSIONS));
        }
    }

    public boolean isSecureTlsVersion(@Nullable String protocol) {
        if (protocol == null) {
            return false;
        }
        if (!ALLOWED_TLS_VERSIONS.contains(protocol)) {
            return false;
        }
        if (TLS_V1_3.equals(this.minimumTlsVersion)) {
            return TLS_V1_3.equals(protocol) || TLS.equals(protocol);
        }
        return true;
    }

    public SSLContext createSecureSSLContext() throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        SSLContext secureContext = SSLContext.getInstance(this.minimumTlsVersion);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)null);
        TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
        secureContext.init(null, trustManagers, new SecureRandom());
        return secureContext;
    }

    public SSLContext getOrCreateSecureSSLContext(@Nullable SSLContext sslContext) {
        try {
            if (sslContext != null) {
                String protocol = sslContext.getProtocol();
                LOGGER.debug("SSL context protocol: %s", new Object[]{protocol});
                if (this.isSecureTlsVersion(protocol)) {
                    LOGGER.debug("Using provided SSL context with protocol: %s", new Object[]{protocol});
                    return sslContext;
                }
                LOGGER.warn(HttpLogMessages.WARN.SSL_INSECURE_PROTOCOL, new Object[]{protocol});
                SSLContext secureContext = this.createSecureSSLContext();
                LOGGER.debug("Created secure SSL context with minimum TLS version: %s", new Object[]{this.minimumTlsVersion});
                return secureContext;
            }
            SSLContext secureContext = this.createSecureSSLContext();
            LOGGER.debug("No SSL context provided, created secure context with minimum TLS version: %s", new Object[]{this.minimumTlsVersion});
            return secureContext;
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new IllegalStateException("Failed to create a secure SSL context", e);
        }
    }
}

