/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.client.handler;

import de.cuioss.http.client.HttpLogMessages;
import de.cuioss.http.client.handler.HttpStatusFamily;
import de.cuioss.http.client.handler.SecureSSLContextProvider;
import de.cuioss.tools.logging.CuiLogger;
import de.cuioss.tools.string.MoreStrings;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public final class HttpHandler {
    private static final CuiLogger LOGGER = new CuiLogger(HttpHandler.class);
    private static final Pattern URL_SCHEME_PATTERN = Pattern.compile("^[a-zA-Z][a-zA-Z0-9+.-]*:.*");
    public static final int DEFAULT_CONNECTION_TIMEOUT_SECONDS = 10;
    public static final int DEFAULT_READ_TIMEOUT_SECONDS = 10;
    private final URI uri;
    private final URL url;
    private final @Nullable SSLContext sslContext;
    private final int connectionTimeoutSeconds;
    private final int readTimeoutSeconds;
    private final HttpClient httpClient;

    private HttpHandler(URI uri, URL url, int connectionTimeoutSeconds, int readTimeoutSeconds) {
        this.uri = uri;
        this.url = url;
        this.sslContext = null;
        this.connectionTimeoutSeconds = connectionTimeoutSeconds;
        this.readTimeoutSeconds = readTimeoutSeconds;
        this.httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(connectionTimeoutSeconds)).build();
    }

    private HttpHandler(URI uri, URL url, SSLContext sslContext, int connectionTimeoutSeconds, int readTimeoutSeconds) {
        this.uri = uri;
        this.url = url;
        this.sslContext = sslContext;
        this.connectionTimeoutSeconds = connectionTimeoutSeconds;
        this.readTimeoutSeconds = readTimeoutSeconds;
        this.httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(connectionTimeoutSeconds)).sslContext(sslContext).build();
    }

    public static HttpHandlerBuilder builder() {
        return new HttpHandlerBuilder();
    }

    public HttpRequest.Builder requestBuilder() {
        return HttpRequest.newBuilder().uri(this.uri).timeout(Duration.ofSeconds(this.readTimeoutSeconds));
    }

    public HttpHandlerBuilder asBuilder() {
        return HttpHandler.builder().connectionTimeoutSeconds(this.connectionTimeoutSeconds).readTimeoutSeconds(this.readTimeoutSeconds).sslContext(this.sslContext);
    }

    public HttpStatusFamily pingHead() {
        return this.pingWithMethod("HEAD", HttpRequest.BodyPublishers.noBody());
    }

    public HttpStatusFamily pingGet() {
        return this.pingWithMethod("GET", HttpRequest.BodyPublishers.noBody());
    }

    private HttpStatusFamily pingWithMethod(String method, HttpRequest.BodyPublisher bodyPublisher) {
        try {
            HttpClient client = this.createHttpClient();
            HttpRequest request = this.requestBuilder().method(method, bodyPublisher).build();
            HttpResponse<Void> response = client.send(request, HttpResponse.BodyHandlers.discarding());
            return HttpStatusFamily.fromStatusCode(response.statusCode());
        }
        catch (IOException e) {
            LOGGER.warn((Throwable)e, HttpLogMessages.WARN.HTTP_PING_IO_ERROR, new Object[]{this.uri, e.getMessage()});
            return HttpStatusFamily.UNKNOWN;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.warn(HttpLogMessages.WARN.HTTP_PING_INTERRUPTED, new Object[]{this.uri, e.getMessage()});
            return HttpStatusFamily.UNKNOWN;
        }
    }

    public HttpClient createHttpClient() {
        return this.httpClient;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpHandler)) {
            return false;
        }
        HttpHandler other = (HttpHandler)o;
        if (this.getConnectionTimeoutSeconds() != other.getConnectionTimeoutSeconds()) {
            return false;
        }
        if (this.getReadTimeoutSeconds() != other.getReadTimeoutSeconds()) {
            return false;
        }
        URI this$uri = this.getUri();
        URI other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !((Object)this$uri).equals(other$uri)) {
            return false;
        }
        URL this$url = this.getUrl();
        URL other$url = other.getUrl();
        if (this$url == null ? other$url != null : !((Object)this$url).equals(other$url)) {
            return false;
        }
        SSLContext this$sslContext = this.getSslContext();
        SSLContext other$sslContext = other.getSslContext();
        if (this$sslContext == null ? other$sslContext != null : !this$sslContext.equals(other$sslContext)) {
            return false;
        }
        HttpClient this$httpClient = this.httpClient;
        HttpClient other$httpClient = other.httpClient;
        return !(this$httpClient == null ? other$httpClient != null : !this$httpClient.equals(other$httpClient));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getConnectionTimeoutSeconds();
        result = result * 59 + this.getReadTimeoutSeconds();
        URI $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : ((Object)$uri).hashCode());
        URL $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : ((Object)$url).hashCode());
        SSLContext $sslContext = this.getSslContext();
        result = result * 59 + ($sslContext == null ? 43 : $sslContext.hashCode());
        HttpClient $httpClient = this.httpClient;
        result = result * 59 + ($httpClient == null ? 43 : $httpClient.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HttpHandler(uri=" + String.valueOf(this.getUri()) + ", url=" + String.valueOf(this.getUrl()) + ", sslContext=" + String.valueOf(this.getSslContext()) + ", connectionTimeoutSeconds=" + this.getConnectionTimeoutSeconds() + ", readTimeoutSeconds=" + this.getReadTimeoutSeconds() + ", httpClient=" + String.valueOf(this.httpClient) + ")";
    }

    @Generated
    public URI getUri() {
        return this.uri;
    }

    @Generated
    public URL getUrl() {
        return this.url;
    }

    @Generated
    public @Nullable SSLContext getSslContext() {
        return this.sslContext;
    }

    @Generated
    public int getConnectionTimeoutSeconds() {
        return this.connectionTimeoutSeconds;
    }

    @Generated
    public int getReadTimeoutSeconds() {
        return this.readTimeoutSeconds;
    }

    public static class HttpHandlerBuilder {
        @Generated
        private HttpClient httpClient;
        private @Nullable URI uri;
        private @Nullable URL url;
        private @Nullable String urlString;
        private @Nullable SSLContext sslContext;
        private @Nullable SecureSSLContextProvider secureSSLContextProvider;
        private @Nullable Integer connectionTimeoutSeconds;
        private @Nullable Integer readTimeoutSeconds;

        public HttpHandlerBuilder uri(String uriString) {
            this.urlString = uriString;
            return this;
        }

        public HttpHandlerBuilder uri(URI uri) {
            this.uri = uri;
            return this;
        }

        public HttpHandlerBuilder url(String urlString) {
            this.urlString = urlString;
            return this;
        }

        public HttpHandlerBuilder url(URL url) {
            this.url = url;
            return this;
        }

        public HttpHandlerBuilder sslContext(@Nullable SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public HttpHandlerBuilder tlsVersions(@Nullable SecureSSLContextProvider secureSSLContextProvider) {
            this.secureSSLContextProvider = secureSSLContextProvider;
            return this;
        }

        public HttpHandlerBuilder connectionTimeoutSeconds(int connectionTimeoutSeconds) {
            this.connectionTimeoutSeconds = connectionTimeoutSeconds;
            return this;
        }

        public HttpHandlerBuilder readTimeoutSeconds(int readTimeoutSeconds) {
            this.readTimeoutSeconds = readTimeoutSeconds;
            return this;
        }

        public HttpHandler build() {
            URL verifiedUrl;
            int actualReadTimeoutSeconds;
            int actualConnectionTimeoutSeconds;
            this.resolveUri();
            int n = actualConnectionTimeoutSeconds = this.connectionTimeoutSeconds != null ? this.connectionTimeoutSeconds : 10;
            if (actualConnectionTimeoutSeconds <= 0) {
                throw new IllegalArgumentException("Connection timeout must be positive");
            }
            int n2 = actualReadTimeoutSeconds = this.readTimeoutSeconds != null ? this.readTimeoutSeconds : 10;
            if (actualReadTimeoutSeconds <= 0) {
                throw new IllegalArgumentException("Read timeout must be positive");
            }
            try {
                verifiedUrl = this.uri.toURL();
            }
            catch (IllegalArgumentException | NullPointerException | MalformedURLException e) {
                throw new IllegalStateException("Failed to convert URI to URL: " + String.valueOf(this.uri), e);
            }
            if ("https".equalsIgnoreCase(this.uri.getScheme())) {
                SecureSSLContextProvider actualSecureSSLContextProvider = this.secureSSLContextProvider != null ? this.secureSSLContextProvider : new SecureSSLContextProvider();
                SSLContext secureContext = actualSecureSSLContextProvider.getOrCreateSecureSSLContext(this.sslContext);
                return new HttpHandler(this.uri, verifiedUrl, secureContext, actualConnectionTimeoutSeconds, actualReadTimeoutSeconds);
            }
            return new HttpHandler(this.uri, verifiedUrl, actualConnectionTimeoutSeconds, actualReadTimeoutSeconds);
        }

        private void resolveUri() {
            if (this.uri != null) {
                return;
            }
            if (this.url != null) {
                try {
                    this.uri = this.url.toURI();
                    return;
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("Invalid URL: " + String.valueOf(this.url), e);
                }
            }
            if (!MoreStrings.isBlank((CharSequence)this.urlString)) {
                Object urlToUse = this.urlString;
                if (!URL_SCHEME_PATTERN.matcher((CharSequence)urlToUse).matches()) {
                    LOGGER.debug("URL missing scheme, prepending https:// to %s", new Object[]{this.urlString});
                    urlToUse = "https://" + (String)urlToUse;
                }
                this.uri = URI.create((String)urlToUse);
                return;
            }
            throw new IllegalArgumentException("URI must not be null or empty.");
        }

        @Generated
        HttpHandlerBuilder() {
        }

        @Generated
        private HttpHandlerBuilder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        @Generated
        public String toString() {
            return "HttpHandler.HttpHandlerBuilder(uri=" + String.valueOf(this.uri) + ", url=" + String.valueOf(this.url) + ", sslContext=" + String.valueOf(this.sslContext) + ", connectionTimeoutSeconds=" + this.connectionTimeoutSeconds + ", readTimeoutSeconds=" + this.readTimeoutSeconds + ", httpClient=" + String.valueOf(this.httpClient) + ")";
        }
    }
}

