/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.client.converter;

import de.cuioss.http.client.converter.HttpContentConverter;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.jspecify.annotations.NonNull;

public abstract class StringContentConverter<T>
implements HttpContentConverter<T> {
    private final Charset charset;

    protected StringContentConverter() {
        this(StandardCharsets.UTF_8);
    }

    protected StringContentConverter(@NonNull Charset charset) {
        this.charset = charset;
    }

    @Override
    public HttpResponse.BodyHandler<?> getBodyHandler() {
        return HttpResponse.BodyHandlers.ofString(this.charset);
    }

    @Override
    public Optional<T> convert(Object rawContent) {
        return this.convertString((String)rawContent);
    }

    protected abstract Optional<T> convertString(String var1);

    public static StringContentConverter<String> identity() {
        return new StringContentConverter<String>(){

            @Override
            protected Optional<String> convertString(String rawContent) {
                return Optional.ofNullable(rawContent);
            }

            @Override
            public @NonNull String emptyValue() {
                return "";
            }
        };
    }
}

