/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.client;

import de.cuioss.http.client.HttpLogMessages;
import de.cuioss.http.client.LoaderStatus;
import de.cuioss.http.client.converter.HttpContentConverter;
import de.cuioss.http.client.handler.HttpHandler;
import de.cuioss.http.client.handler.HttpStatusFamily;
import de.cuioss.http.client.result.HttpErrorCategory;
import de.cuioss.http.client.result.HttpResult;
import de.cuioss.http.client.retry.RetryContext;
import de.cuioss.http.client.retry.RetryStrategy;
import de.cuioss.tools.logging.CuiLogger;
import java.io.IOException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.jspecify.annotations.NonNull;

public class ResilientHttpHandler<T> {
    private static final CuiLogger LOGGER = new CuiLogger(ResilientHttpHandler.class);
    private final HttpHandler httpHandler;
    private final RetryStrategy retryStrategy;
    private final HttpContentConverter<T> contentConverter;
    private final ReentrantLock lock = new ReentrantLock();
    private HttpResult<T> cachedResult;
    private volatile LoaderStatus loaderStatus = LoaderStatus.UNDEFINED;

    public ResilientHttpHandler(@NonNull HttpHandler httpHandler, @NonNull RetryStrategy retryStrategy, @NonNull HttpContentConverter<T> contentConverter) {
        this.httpHandler = httpHandler;
        this.retryStrategy = retryStrategy;
        this.contentConverter = contentConverter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResult<T> load() {
        this.lock.lock();
        try {
            this.loaderStatus = LoaderStatus.LOADING;
            RetryContext retryContext = new RetryContext("ETag-HTTP-Load:" + this.httpHandler.getUri().toString(), 1);
            HttpResult result = this.retryStrategy.execute(this::fetchContentWithCache, retryContext).join();
            this.updateStatusFromResult(result);
            HttpResult httpResult = result;
            return httpResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    private HttpResult<T> handleErrorResult(HttpErrorCategory category) {
        if (this.cachedResult != null && this.cachedResult.getContent().isPresent()) {
            return HttpResult.failureWithFallback("HTTP request failed, using cached content from " + String.valueOf(this.httpHandler.getUrl()), null, this.cachedResult.getContent().orElse(null), category, this.cachedResult.getETag().orElse(null), this.cachedResult.getHttpStatus().orElse(null));
        }
        return HttpResult.failure("HTTP request failed with no cached content available from " + String.valueOf(this.httpHandler.getUrl()), null, category);
    }

    private HttpResult<T> fetchContentWithCache() {
        HttpRequest request = this.buildRequestWithConditionalHeaders();
        try {
            HttpClient client = this.httpHandler.createHttpClient();
            HttpResponse<?> response = client.send(request, this.contentConverter.getBodyHandler());
            return this.processHttpResponse(response);
        }
        catch (IOException e) {
            LOGGER.warn((Throwable)e, HttpLogMessages.WARN.HTTP_FETCH_FAILED, new Object[]{this.httpHandler.getUrl()});
            return this.handleErrorResult(HttpErrorCategory.NETWORK_ERROR);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.warn(HttpLogMessages.WARN.HTTP_FETCH_INTERRUPTED, new Object[]{this.httpHandler.getUrl()});
            return this.handleErrorResult(HttpErrorCategory.NETWORK_ERROR);
        }
    }

    private HttpRequest buildRequestWithConditionalHeaders() {
        HttpRequest.Builder requestBuilder = this.httpHandler.requestBuilder();
        if (this.cachedResult != null) {
            this.cachedResult.getETag().ifPresent(etag -> requestBuilder.header("If-None-Match", (String)etag));
        }
        return requestBuilder.build();
    }

    private HttpResult<T> processHttpResponse(HttpResponse<?> response) {
        HttpStatusFamily statusFamily = HttpStatusFamily.fromStatusCode(response.statusCode());
        if (response.statusCode() == 304) {
            return this.handleNotModifiedResponse();
        }
        if (statusFamily == HttpStatusFamily.SUCCESS) {
            return this.handleSuccessResponse(response);
        }
        return this.handleErrorResponse(response.statusCode(), statusFamily);
    }

    private HttpResult<T> handleNotModifiedResponse() {
        LOGGER.debug("HTTP content not modified (304) for %s", new Object[]{this.httpHandler.getUrl()});
        if (this.cachedResult != null && this.cachedResult.getContent().isPresent()) {
            return HttpResult.success(this.cachedResult.getContent().get(), this.cachedResult.getETag().orElse(null), 304);
        }
        return HttpResult.failure("304 Not Modified but no cached content available", null, HttpErrorCategory.SERVER_ERROR);
    }

    private HttpResult<T> handleSuccessResponse(HttpResponse<?> response) {
        Object rawContent = response.body();
        String etag = response.headers().firstValue("ETag").orElse(null);
        LOGGER.debug("HTTP response received: %s SUCCESS for %s (etag: %s)", new Object[]{response.statusCode(), this.httpHandler.getUrl(), etag});
        Optional<T> contentOpt = this.contentConverter.convert(rawContent);
        if (contentOpt.isPresent()) {
            T content = contentOpt.get();
            HttpResult<T> result = HttpResult.success(content, etag, response.statusCode());
            this.cachedResult = result;
            return result;
        }
        LOGGER.warn(HttpLogMessages.WARN.CONTENT_CONVERSION_FAILED, new Object[]{this.httpHandler.getUrl()});
        return HttpResult.failure("Content conversion failed for " + String.valueOf(this.httpHandler.getUrl()), null, HttpErrorCategory.INVALID_CONTENT);
    }

    private HttpResult<T> handleErrorResponse(int statusCode, HttpStatusFamily statusFamily) {
        LOGGER.warn(HttpLogMessages.WARN.HTTP_STATUS_WARNING, new Object[]{statusCode, statusFamily, this.httpHandler.getUrl()});
        if (statusFamily == HttpStatusFamily.CLIENT_ERROR) {
            return this.handleErrorResult(HttpErrorCategory.CLIENT_ERROR);
        }
        return this.handleErrorResult(HttpErrorCategory.SERVER_ERROR);
    }

    private void updateStatusFromResult(HttpResult<T> result) {
        this.loaderStatus = result.isSuccess() ? LoaderStatus.OK : LoaderStatus.ERROR;
    }

    @Generated
    public LoaderStatus getLoaderStatus() {
        return this.loaderStatus;
    }
}

