/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.generators.url;

import de.cuioss.test.generator.Generators;
import de.cuioss.test.generator.TypedGenerator;

public class ValidURLPathGenerator
implements TypedGenerator<String> {
    private final TypedGenerator<Integer> pathTypeGen = Generators.integers((int)1, (int)7);
    private final TypedGenerator<Integer> apiVersionGen = Generators.integers((int)1, (int)3);
    private final TypedGenerator<Integer> resourceGen = Generators.integers((int)1, (int)5);
    private final TypedGenerator<Integer> actionGen = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Integer> adminActionGen = Generators.integers((int)1, (int)3);
    private final TypedGenerator<Integer> systemPathGen = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Integer> nestedResourceGen = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Boolean> includeIdGen = Generators.booleans();

    public String next() {
        return switch ((Integer)this.pathTypeGen.next()) {
            case 1 -> this.generateApiPath();
            case 2 -> this.generateVersionedApiPath();
            case 3 -> this.generateNestedResourcePath();
            case 4 -> this.generateSystemPath();
            case 5 -> this.generateAuthPath();
            case 6 -> this.generateAdminPath();
            case 7 -> this.generateReportingPath();
            default -> this.generateApiPath();
        };
    }

    private String generateApiPath() {
        String resource = this.generateResource();
        if (((Boolean)this.includeIdGen.next()).booleanValue()) {
            String action = this.generateAction();
            return "/api/" + resource + "/" + this.generateId() + "/" + action;
        }
        return "/api/" + resource;
    }

    private String generateVersionedApiPath() {
        String version = this.generateApiVersion();
        String resource = this.generateResource();
        if (((Boolean)this.includeIdGen.next()).booleanValue()) {
            return "/api/" + version + "/" + resource + "/" + this.generateId();
        }
        return "/api/" + version + "/" + resource;
    }

    private String generateNestedResourcePath() {
        String parentResource = this.generateResource();
        String childResource = this.generateNestedResource();
        return "/api/" + parentResource + "/" + this.generateId() + "/" + childResource;
    }

    private String generateSystemPath() {
        return switch ((Integer)this.systemPathGen.next()) {
            case 1 -> "/health";
            case 2 -> "/metrics";
            case 3 -> "/status";
            case 4 -> "/info";
            default -> "/health";
        };
    }

    private String generateAuthPath() {
        String action = this.generateAction();
        return "/api/auth/" + action;
    }

    private String generateAdminPath() {
        String action = this.generateAdminAction();
        return "/api/admin/" + action;
    }

    private String generateReportingPath() {
        String reportType = switch ((Integer)Generators.integers((int)1, (int)3).next()) {
            case 1 -> "daily";
            case 2 -> "summary";
            case 3 -> "status";
            default -> "daily";
        };
        return "/api/" + this.generateReportCategory() + "/" + reportType;
    }

    private String generateApiVersion() {
        return switch ((Integer)this.apiVersionGen.next()) {
            case 1 -> "v1";
            case 2 -> "v2";
            case 3 -> "v3";
            default -> "v1";
        };
    }

    private String generateResource() {
        return switch ((Integer)this.resourceGen.next()) {
            case 1 -> "users";
            case 2 -> "orders";
            case 3 -> "products";
            case 4 -> "customers";
            case 5 -> "documents";
            default -> "users";
        };
    }

    private String generateAction() {
        return switch ((Integer)this.actionGen.next()) {
            case 1 -> "search";
            case 2 -> "profile";
            case 3 -> "login";
            case 4 -> "logout";
            default -> "search";
        };
    }

    private String generateAdminAction() {
        return switch ((Integer)this.adminActionGen.next()) {
            case 1 -> "dashboard";
            case 2 -> "settings";
            case 3 -> "config";
            default -> "dashboard";
        };
    }

    private String generateNestedResource() {
        return switch ((Integer)this.nestedResourceGen.next()) {
            case 1 -> "items";
            case 2 -> "orders";
            case 3 -> "profile";
            case 4 -> "notifications";
            default -> "items";
        };
    }

    private String generateReportCategory() {
        return switch ((Integer)Generators.integers((int)1, (int)3).next()) {
            case 1 -> "reports";
            case 2 -> "stats";
            case 3 -> "backup";
            default -> "reports";
        };
    }

    private String generateId() {
        return switch ((Integer)Generators.integers((int)1, (int)3).next()) {
            case 1 -> "123";
            case 2 -> "456";
            case 3 -> ((Integer)Generators.integers((int)100, (int)999).next()).toString();
            default -> "123";
        };
    }

    public Class<String> getType() {
        return String.class;
    }
}

