/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.generators.url;

import de.cuioss.test.generator.Generators;
import de.cuioss.test.generator.TypedGenerator;

public class ValidURLParameterStringGenerator
implements TypedGenerator<String> {
    private final TypedGenerator<Integer> parameterTypeSelector = Generators.integers((int)1, (int)8);
    private final TypedGenerator<Integer> wordSelector = Generators.integers((int)1, (int)8);
    private final TypedGenerator<Integer> statusSelector = Generators.integers((int)1, (int)6);
    private final TypedGenerator<Integer> emailNameSelector = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Integer> emailDomainSelector = Generators.integers((int)1, (int)3);

    public String next() {
        return switch ((Integer)this.parameterTypeSelector.next()) {
            case 1 -> this.generateNumericValue();
            case 2 -> this.generateEncodedText();
            case 3 -> this.generateSimpleText();
            case 4 -> this.generateBooleanLike();
            case 5 -> this.generateTimestamp();
            case 6 -> this.generateAlphanumericId();
            case 7 -> this.generateEncodedEmail();
            case 8 -> this.generatePhone();
            default -> throw new IllegalStateException("Invalid parameter type");
        };
    }

    private String generateNumericValue() {
        TypedGenerator numbers = Generators.integers((int)1, (int)1000);
        return String.valueOf(numbers.next());
    }

    private String generateEncodedText() {
        return this.generateWord() + "%20" + this.generateWord();
    }

    private String generateSimpleText() {
        return this.generateWord();
    }

    private String generateBooleanLike() {
        return this.generateStatus();
    }

    private String generateTimestamp() {
        TypedGenerator timestamps = Generators.longs((long)1640995200L, (long)1700000000L);
        return String.valueOf(timestamps.next());
    }

    private String generateAlphanumericId() {
        TypedGenerator alphanumeric = Generators.letterStrings((int)3, (int)6);
        TypedGenerator numbers = Generators.integers((int)100, (int)999);
        return (String)alphanumeric.next() + String.valueOf(numbers.next());
    }

    private String generateEncodedEmail() {
        String name = this.generateEmailName();
        String domain = this.generateEmailDomain();
        return name + "%40" + domain;
    }

    private String generatePhone() {
        TypedGenerator area = Generators.integers((int)100, (int)999);
        TypedGenerator exchange = Generators.integers((int)100, (int)999);
        TypedGenerator number = Generators.integers((int)1000, (int)9999);
        return String.valueOf(area.next()) + "-" + String.valueOf(exchange.next()) + "-" + String.valueOf(number.next());
    }

    private String generateWord() {
        return switch ((Integer)this.wordSelector.next()) {
            case 1 -> "product";
            case 2 -> "user";
            case 3 -> "order";
            case 4 -> "item";
            case 5 -> "data";
            case 6 -> "content";
            case 7 -> "info";
            case 8 -> "system";
            default -> "product";
        };
    }

    private String generateStatus() {
        return switch ((Integer)this.statusSelector.next()) {
            case 1 -> "true";
            case 2 -> "false";
            case 3 -> "yes";
            case 4 -> "no";
            case 5 -> "on";
            case 6 -> "off";
            default -> "true";
        };
    }

    private String generateEmailName() {
        return switch ((Integer)this.emailNameSelector.next()) {
            case 1 -> "john";
            case 2 -> "jane";
            case 3 -> "mike";
            case 4 -> "sara";
            default -> "john";
        };
    }

    private String generateEmailDomain() {
        return switch ((Integer)this.emailDomainSelector.next()) {
            case 1 -> "example.com";
            case 2 -> "test.org";
            case 3 -> "demo.net";
            default -> "example.com";
        };
    }

    public Class<String> getType() {
        return String.class;
    }
}

