/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.generators.url;

import de.cuioss.http.security.data.URLParameter;
import de.cuioss.test.generator.Generators;
import de.cuioss.test.generator.TypedGenerator;

public class ValidURLParameterGenerator
implements TypedGenerator<URLParameter> {
    private final TypedGenerator<Integer> paramTypeGenerator = Generators.integers((int)0, (int)3);
    private final TypedGenerator<Integer> paginationParamGen = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Integer> searchParamGen = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Integer> dataParamGen = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Integer> localeParamGen = Generators.integers((int)1, (int)3);
    private final TypedGenerator<Integer> booleanValueGen = Generators.integers((int)1, (int)2);
    private final TypedGenerator<Integer> sortValueGen = Generators.integers((int)1, (int)2);
    private final TypedGenerator<Integer> formatValueGen = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Integer> languageValueGen = Generators.integers((int)1, (int)5);
    private final TypedGenerator<Integer> statusValueGen = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Integer> numberValues = Generators.integers((int)1, (int)1000);

    public URLParameter next() {
        int type = (Integer)this.paramTypeGenerator.next();
        String name = switch (type) {
            case 0 -> this.generatePaginationParameterName();
            case 1 -> this.generateSearchParameterName();
            case 2 -> this.generateDataParameterName();
            case 3 -> this.generateLocaleParameterName();
            default -> this.generatePaginationParameterName();
        };
        String value = this.generateLegitimateValue();
        return new URLParameter(name, value);
    }

    private String generatePaginationParameterName() {
        return switch ((Integer)this.paginationParamGen.next()) {
            case 1 -> "page";
            case 2 -> "size";
            case 3 -> "sort";
            case 4 -> "filter";
            default -> "page";
        };
    }

    private String generateSearchParameterName() {
        return switch ((Integer)this.searchParamGen.next()) {
            case 1 -> "search";
            case 2 -> "category";
            case 3 -> "type";
            case 4 -> "status";
            default -> "search";
        };
    }

    private String generateDataParameterName() {
        return switch ((Integer)this.dataParamGen.next()) {
            case 1 -> "id";
            case 2 -> "limit";
            case 3 -> "offset";
            case 4 -> "format";
            default -> "id";
        };
    }

    private String generateLocaleParameterName() {
        return switch ((Integer)this.localeParamGen.next()) {
            case 1 -> "lang";
            case 2 -> "version";
            case 3 -> "timestamp";
            default -> "lang";
        };
    }

    private String generateLegitimateValue() {
        int valueType = (Integer)Generators.integers((int)0, (int)6).next();
        return switch (valueType) {
            case 0 -> this.generateNumberValue();
            case 1 -> this.generateBooleanValue();
            case 2 -> this.generateSortValue();
            case 3 -> this.generateFormatValue();
            case 4 -> this.generateLanguageValue();
            case 5 -> this.generateStatusValue();
            case 6 -> this.generateTestValue();
            default -> this.generateNumberValue();
        };
    }

    private String generateNumberValue() {
        return String.valueOf(this.numberValues.next());
    }

    private String generateBooleanValue() {
        return switch ((Integer)this.booleanValueGen.next()) {
            case 1 -> "true";
            case 2 -> "false";
            default -> "true";
        };
    }

    private String generateSortValue() {
        return switch ((Integer)this.sortValueGen.next()) {
            case 1 -> "asc";
            case 2 -> "desc";
            default -> "asc";
        };
    }

    private String generateFormatValue() {
        return switch ((Integer)this.formatValueGen.next()) {
            case 1 -> "json";
            case 2 -> "xml";
            case 3 -> "csv";
            case 4 -> "html";
            default -> "json";
        };
    }

    private String generateLanguageValue() {
        return switch ((Integer)this.languageValueGen.next()) {
            case 1 -> "en";
            case 2 -> "de";
            case 3 -> "fr";
            case 4 -> "es";
            case 5 -> "ja";
            default -> "en";
        };
    }

    private String generateStatusValue() {
        return switch ((Integer)this.statusValueGen.next()) {
            case 1 -> "active";
            case 2 -> "inactive";
            case 3 -> "pending";
            case 4 -> "deleted";
            default -> "active";
        };
    }

    private String generateTestValue() {
        int testType = (Integer)Generators.integers((int)0, (int)3).next();
        return switch (testType) {
            case 0 -> "test";
            case 1 -> "example";
            case 2 -> "demo";
            case 3 -> "sample";
            default -> "test";
        };
    }

    public Class<URLParameter> getType() {
        return URLParameter.class;
    }
}

