/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.generators.url;

import de.cuioss.test.generator.Generators;
import de.cuioss.test.generator.TypedGenerator;

public class ValidURLGenerator
implements TypedGenerator<String> {
    private final TypedGenerator<Integer> pathTypeGen = Generators.integers((int)1, (int)7);
    private final TypedGenerator<Integer> sortTypeGen = Generators.integers((int)1, (int)2);
    private final TypedGenerator<Boolean> paramGen = Generators.booleans();
    private final TypedGenerator<Integer> pageGen = Generators.integers((int)1, (int)100);

    public String next() {
        Object path = this.generateValidPath();
        if (((Boolean)this.paramGen.next()).booleanValue()) {
            if (((String)path).contains("?")) {
                path = (String)path + "&page=" + String.valueOf(this.pageGen.next());
                path = (String)path + "&sort=" + this.generateSortOption();
            } else {
                path = (String)path + "?page=" + String.valueOf(this.pageGen.next());
                path = (String)path + "&sort=" + this.generateSortOption();
            }
        }
        if (((String)path).length() > 4096) {
            path = ((String)path).substring(0, 4096);
        }
        return path;
    }

    private String generateValidPath() {
        return switch ((Integer)this.pathTypeGen.next()) {
            case 1 -> "/api/v1/users";
            case 2 -> "/static/css/style.css";
            case 3 -> "/index.html";
            case 4 -> "/docs/guide.pdf";
            case 5 -> "/search?q=test&limit=10";
            case 6 -> this.generateProductPath();
            case 7 -> "/admin/dashboard";
            default -> "/index.html";
        };
    }

    private String generateProductPath() {
        boolean useTestPattern;
        boolean bl = useTestPattern = (Integer)Generators.integers((int)1, (int)2).next() == 1;
        if (useTestPattern) {
            return "/products/123/reviews";
        }
        return "/products/" + String.valueOf(Generators.integers((int)1, (int)999).next()) + "/reviews";
    }

    private String generateSortOption() {
        return switch ((Integer)this.sortTypeGen.next()) {
            case 1 -> "asc";
            case 2 -> "desc";
            default -> "asc";
        };
    }

    public Class<String> getType() {
        return String.class;
    }
}

