/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.generators.url;

import de.cuioss.test.generator.Generators;
import de.cuioss.test.generator.TypedGenerator;
import java.util.Arrays;
import java.util.List;

public class URLLengthLimitAttackGenerator
implements TypedGenerator<String> {
    private static final List<String> BASE_PATTERNS = Arrays.asList("/api", "/search", "/data", "/resource", "/service", "/endpoint", "/handler", "/process", "/action", "/request");
    private final AttackTypeSelector attackTypeSelector = new AttackTypeSelector(13);

    public String next() {
        String basePattern = BASE_PATTERNS.get(this.hashBasedSelection(BASE_PATTERNS.size()));
        return switch (this.attackTypeSelector.nextAttackType()) {
            case 0 -> this.createBasicLengthOverflow(basePattern);
            case 1 -> this.createPathComponentOverflow(basePattern);
            case 2 -> this.createQueryParameterOverflow(basePattern);
            case 3 -> this.createFragmentOverflow(basePattern);
            case 4 -> this.createHostnameOverflow(basePattern);
            case 5 -> this.createRepeatedParameterAttack(basePattern);
            case 6 -> this.createDeepPathNesting(basePattern);
            case 7 -> this.createLongParameterNames(basePattern);
            case 8 -> this.createLongParameterValues(basePattern);
            case 9 -> this.createMixedLengthAttacks(basePattern);
            case 10 -> this.createBufferOverflowPatterns(basePattern);
            case 11 -> this.createMemoryExhaustionAttack(basePattern);
            case 12 -> this.createAlgorithmicComplexity(basePattern);
            default -> this.createBasicLengthOverflow(basePattern);
        };
    }

    private String createBasicLengthOverflow(String pattern) {
        int attackType = this.hashBasedSelection(8);
        return switch (attackType) {
            case 0 -> pattern + "?" + (String)Generators.letterStrings((int)1030, (int)1050).next();
            case 1 -> pattern + "/" + (String)Generators.letterStrings((int)1025, (int)1040).next();
            case 2 -> pattern + "?param=" + (String)Generators.letterStrings((int)4100, (int)4150).next();
            case 3 -> pattern + "/" + (String)Generators.letterStrings((int)4097, (int)4120).next();
            case 4 -> pattern + "?" + (String)Generators.letterStrings((int)8200, (int)8250).next();
            case 5 -> pattern + "/" + (String)Generators.letterStrings((int)8193, (int)8210).next();
            case 6 -> pattern + "/" + (String)Generators.letterStrings((int)512, (int)512).next() + "/" + (String)Generators.letterStrings((int)512, (int)512).next() + "?" + (String)Generators.letterStrings((int)512, (int)512).next();
            case 7 -> pattern + "?field=" + (String)Generators.letterStrings((int)2050, (int)2100).next();
            default -> pattern + "?" + (String)Generators.letterStrings((int)1030, (int)1050).next();
        };
    }

    private String createPathComponentOverflow(String pattern) {
        int attackType = this.hashBasedSelection(8);
        return switch (attackType) {
            case 0 -> pattern + "/" + (String)Generators.strings((String)"segment/", (int)150, (int)180).next() + "file";
            case 1 -> pattern + "/" + (String)Generators.letterStrings((int)1030, (int)1050).next() + "/normal";
            case 2 -> pattern + "/path_" + (String)Generators.letterStrings((int)1000, (int)1020).next() + "/data";
            case 3 -> "/" + (String)Generators.letterStrings((int)800, (int)850).next() + pattern + "/file";
            case 4 -> pattern + "/dir_" + (String)Generators.letterStrings((int)500, (int)520).next() + "/file_" + (String)Generators.letterStrings((int)500, (int)520).next();
            case 5 -> pattern + "/very_long_directory_name_" + (String)Generators.letterStrings((int)950, (int)980).next();
            case 6 -> pattern + "/component" + (String)Generators.letterStrings((int)400, (int)420).next() + "/subdir" + (String)Generators.letterStrings((int)400, (int)420).next() + "/file";
            case 7 -> pattern + "/" + (String)Generators.letterStrings((int)4100, (int)4150).next() + "/end";
            default -> pattern + "/" + (String)Generators.letterStrings((int)1030, (int)1050).next();
        };
    }

    private String createQueryParameterOverflow(String pattern) {
        int attackType = this.hashBasedSelection(8);
        return switch (attackType) {
            case 0 -> pattern + "?param=" + (String)Generators.letterStrings((int)900, (int)950).next();
            case 1 -> pattern + "?data=" + (String)Generators.letterStrings((int)500, (int)520).next() + "&info=" + (String)Generators.letterStrings((int)500, (int)520).next();
            case 2 -> pattern + "?query=" + (String)Generators.letterStrings((int)3800, (int)3900).next();
            case 3 -> pattern + "?search=" + (String)Generators.strings((String)"term ", (int)200, (int)250).next();
            case 4 -> pattern + "?content=" + (String)Generators.letterStrings((int)900, (int)950).next() + "&type=json";
            case 5 -> pattern + "?" + (String)Generators.strings((String)"input=value123&", (int)50, (int)80).next();
            case 6 -> pattern + "?buffer=" + (String)Generators.letterStrings((int)7800, (int)7900).next();
            case 7 -> pattern + "?payload=" + (String)Generators.letterStrings((int)1030, (int)1080).next() + "&extra=data";
            default -> pattern + "?param=" + (String)Generators.letterStrings((int)1030, (int)1050).next();
        };
    }

    private String createFragmentOverflow(String pattern) {
        int attackType = this.hashBasedSelection(8);
        return switch (attackType) {
            case 0 -> pattern + "#" + (String)Generators.letterStrings((int)500, (int)550).next();
            case 1 -> pattern + "?param=value#" + (String)Generators.letterStrings((int)800, (int)850).next();
            case 2 -> pattern + "/path#section" + (String)Generators.letterStrings((int)400, (int)450).next();
            case 3 -> pattern + "#anchor_" + (String)Generators.letterStrings((int)600, (int)650).next();
            case 4 -> pattern + "?data=test#" + (String)Generators.letterStrings((int)900, (int)950).next();
            case 5 -> pattern + "#" + (String)Generators.strings((String)"part_", (int)60, (int)80).next();
            case 6 -> pattern + "#" + (String)Generators.letterStrings((int)3800, (int)3900).next();
            case 7 -> pattern + "/resource?id=123#content_" + (String)Generators.letterStrings((int)700, (int)750).next();
            default -> pattern + "#" + (String)Generators.letterStrings((int)500, (int)550).next();
        };
    }

    private String createHostnameOverflow(String pattern) {
        int attackType = this.hashBasedSelection(8);
        return switch (attackType) {
            case 0 -> "https://" + (String)Generators.letterStrings((int)250, (int)253).next() + ".com" + pattern;
            case 1 -> "https://" + (String)Generators.letterStrings((int)60, (int)63).next() + "." + (String)Generators.letterStrings((int)60, (int)63).next() + ".com" + pattern;
            case 2 -> "https://" + (String)Generators.strings((String)"subdomain.", (int)15, (int)25).next() + "example.com" + pattern;
            case 3 -> "https://" + (String)Generators.letterStrings((int)100, (int)120).next() + ".evil.com" + pattern;
            case 4 -> "https://" + (String)Generators.strings((String)"sub", (int)50, (int)80).next() + ".domain.com" + pattern;
            case 5 -> "https://" + (String)Generators.letterStrings((int)80, (int)100).next() + ".attacker.org" + pattern;
            case 6 -> "https://" + (String)Generators.letterStrings((int)150, (int)200).next() + ".malicious.net" + pattern;
            case 7 -> "https://" + (String)Generators.strings((String)"long", (int)30, (int)50).next() + ".test.com" + pattern;
            default -> "https://" + (String)Generators.letterStrings((int)100, (int)120).next() + ".com" + pattern;
        };
    }

    private String createRepeatedParameterAttack(String pattern) {
        int attackType = this.hashBasedSelection(8);
        return switch (attackType) {
            case 0 -> pattern + "?" + (String)Generators.strings((String)"param=value&", (int)30, (int)50).next();
            case 1 -> pattern + "?" + (String)Generators.strings((String)"data=test&", (int)40, (int)60).next();
            case 2 -> pattern + "?" + (String)Generators.strings((String)"field=info&", (int)25, (int)35).next();
            case 3 -> pattern + "?" + (String)Generators.strings((String)("item=" + (String)Generators.letterStrings((int)20, (int)30).next() + "&"), (int)15, (int)25).next();
            case 4 -> pattern + "?" + (String)Generators.strings((String)"query=search&", (int)35, (int)55).next();
            case 5 -> pattern + "?" + (String)Generators.strings((String)("param" + (String)Generators.letterStrings((int)10, (int)15).next() + "=value&"), (int)20, (int)30).next();
            case 6 -> pattern + "?" + (String)Generators.strings((String)"test=data&", (int)60, (int)90).next();
            case 7 -> pattern + "?" + (String)Generators.strings((String)("key=value" + (String)Generators.letterStrings((int)5, (int)10).next() + "&"), (int)25, (int)40).next();
            default -> pattern + "?" + (String)Generators.strings((String)"param=value&", (int)30, (int)50).next();
        };
    }

    private String createDeepPathNesting(String pattern) {
        int attackType = this.hashBasedSelection(8);
        return switch (attackType) {
            case 0 -> "/" + (String)Generators.strings((String)"dir/", (int)40, (int)60).next() + pattern.substring(1);
            case 1 -> "/" + (String)Generators.strings((String)"level/", (int)50, (int)70).next() + "file";
            case 2 -> pattern + "/" + (String)Generators.strings((String)"sub/", (int)30, (int)50).next() + "resource";
            case 3 -> "/" + (String)Generators.strings((String)"path/", (int)45, (int)65).next() + "endpoint";
            case 4 -> "/" + (String)Generators.strings((String)"deep/", (int)20, (int)30).next() + (String)Generators.strings((String)"very/", (int)20, (int)30).next() + "nested/" + pattern.substring(1);
            case 5 -> "/" + (String)Generators.strings((String)("dir" + this.hashBasedSelection(100) + "/"), (int)35, (int)55).next() + "target";
            case 6 -> "/" + (String)Generators.strings((String)"A/", (int)80, (int)120).next() + "final";
            case 7 -> "/" + (String)Generators.strings((String)"folder/subfolder/", (int)25, (int)35).next() + "destination";
            default -> "/" + (String)Generators.strings((String)"dir/", (int)40, (int)60).next() + pattern.substring(1);
        };
    }

    private String createLongParameterNames(String pattern) {
        int attackType = this.hashBasedSelection(8);
        return switch (attackType) {
            case 0 -> pattern + "?" + (String)Generators.letterStrings((int)900, (int)950).next() + "=value";
            case 1 -> pattern + "?param_" + (String)Generators.letterStrings((int)800, (int)850).next() + "=data";
            case 2 -> pattern + "?" + (String)Generators.letterStrings((int)700, (int)750).next() + "=test&normal=ok";
            case 3 -> pattern + "?field_name_" + (String)Generators.letterStrings((int)600, (int)650).next() + "=content";
            case 4 -> pattern + "?" + (String)Generators.letterStrings((int)3800, (int)3900).next() + "=info";
            case 5 -> pattern + "?" + (String)Generators.strings((String)("parameter_" + (String)Generators.letterStrings((int)20, (int)30).next() + "=value&"), (int)10, (int)15).next();
            case 6 -> pattern + "?" + (String)Generators.letterStrings((int)1030, (int)1080).next() + "=result";
            case 7 -> pattern + "?query_string_parameter_name_" + (String)Generators.letterStrings((int)500, (int)550).next() + "=search";
            default -> pattern + "?" + (String)Generators.letterStrings((int)900, (int)950).next() + "=value";
        };
    }

    private String createLongParameterValues(String pattern) {
        int attackType = this.hashBasedSelection(8);
        return switch (attackType) {
            case 0 -> pattern + "?data=" + (String)Generators.letterStrings((int)1030, (int)1080).next();
            case 1 -> pattern + "?content=" + (String)Generators.letterStrings((int)4100, (int)4150).next();
            case 2 -> pattern + "?payload=" + (String)Generators.letterStrings((int)8200, (int)8250).next();
            case 3 -> pattern + "?info=" + (String)Generators.letterStrings((int)2000, (int)2100).next();
            case 4 -> pattern + "?search=" + (String)Generators.strings((String)"query ", (int)150, (int)200).next();
            case 5 -> pattern + "?input=" + (String)Generators.letterStrings((int)3000, (int)3200).next();
            case 6 -> pattern + "?field=value_" + (String)Generators.letterStrings((int)900, (int)950).next();
            case 7 -> pattern + "?buffer=" + (String)Generators.letterStrings((int)7800, (int)7900).next();
            default -> pattern + "?data=" + (String)Generators.letterStrings((int)1030, (int)1080).next();
        };
    }

    private String createMixedLengthAttacks(String pattern) {
        int attackType = this.hashBasedSelection(8);
        return switch (attackType) {
            case 0 -> "/" + (String)Generators.letterStrings((int)300, (int)350).next() + pattern + "?param=" + (String)Generators.letterStrings((int)300, (int)350).next() + "#" + (String)Generators.letterStrings((int)300, (int)350).next();
            case 1 -> pattern + "/" + (String)Generators.letterStrings((int)500, (int)550).next() + "?" + (String)Generators.letterStrings((int)400, (int)450).next() + "=value";
            case 2 -> "/" + (String)Generators.strings((String)"path/", (int)15, (int)25).next() + pattern.substring(1) + "?data=" + (String)Generators.letterStrings((int)800, (int)850).next();
            case 3 -> pattern + "/" + (String)Generators.letterStrings((int)400, (int)450).next() + "/" + (String)Generators.letterStrings((int)400, (int)450).next() + "?query=" + (String)Generators.letterStrings((int)600, (int)650).next();
            case 4 -> "/" + (String)Generators.letterStrings((int)800, (int)850).next() + "?" + (String)Generators.strings((String)("param" + (String)Generators.letterStrings((int)15, (int)20).next() + "=" + (String)Generators.letterStrings((int)15, (int)20).next() + "&"), (int)8, (int)12).next();
            case 5 -> pattern + "/segment_" + (String)Generators.letterStrings((int)400, (int)450).next() + "?field_" + (String)Generators.letterStrings((int)200, (int)250).next() + "=" + (String)Generators.letterStrings((int)400, (int)450).next() + "#anchor_" + (String)Generators.letterStrings((int)200, (int)250).next();
            case 6 -> "/" + (String)Generators.strings((String)"dir/", (int)30, (int)50).next() + "resource?buffer=" + (String)Generators.letterStrings((int)600, (int)650).next();
            case 7 -> "https://" + (String)Generators.letterStrings((int)80, (int)100).next() + ".example.com" + pattern + "/" + (String)Generators.letterStrings((int)300, (int)350).next() + "?data=" + (String)Generators.letterStrings((int)400, (int)450).next();
            default -> pattern + "/" + (String)Generators.letterStrings((int)400, (int)450).next() + "?param=" + (String)Generators.letterStrings((int)400, (int)450).next();
        };
    }

    private String createBufferOverflowPatterns(String pattern) {
        int attackType = this.hashBasedSelection(8);
        return switch (attackType) {
            case 0 -> pattern + "?" + (String)Generators.letterStrings((int)8200, (int)8300).next();
            case 1 -> pattern + "/" + (String)Generators.letterStrings((int)4100, (int)4200).next() + "?data=" + (String)Generators.letterStrings((int)4100, (int)4200).next();
            case 2 -> pattern + "?buffer=" + (String)Generators.letterStrings((int)9000, (int)9500).next();
            case 3 -> "/" + (String)Generators.letterStrings((int)2000, (int)2100).next() + pattern + "?payload=" + (String)Generators.letterStrings((int)6000, (int)6500).next();
            case 4 -> pattern + "?" + (String)Generators.strings((String)("overflow" + (String)Generators.letterStrings((int)20, (int)30).next() + "=data&"), (int)30, (int)50).next();
            case 5 -> pattern + "/" + (String)Generators.letterStrings((int)8300, (int)8400).next();
            case 6 -> pattern + "?input=" + (String)Generators.letterStrings((int)10000, (int)12000).next();
            case 7 -> pattern + "#" + (String)Generators.letterStrings((int)7000, (int)7500).next();
            default -> pattern + "?" + (String)Generators.letterStrings((int)8200, (int)8300).next();
        };
    }

    private String createMemoryExhaustionAttack(String pattern) {
        int attackType = this.hashBasedSelection(8);
        return switch (attackType) {
            case 0 -> pattern + "?memory=" + (String)Generators.letterStrings((int)12000, (int)15000).next();
            case 1 -> pattern + "/" + (String)Generators.letterStrings((int)4000, (int)4500).next() + "?data=" + (String)Generators.letterStrings((int)4000, (int)4500).next();
            case 2 -> pattern + "?" + (String)Generators.strings((String)("param" + this.hashBasedSelection(100) + "=" + (String)Generators.letterStrings((int)20, (int)30).next() + "&"), (int)100, (int)200).next();
            case 3 -> pattern + "?exhaustion=" + (String)Generators.letterStrings((int)20000, (int)25000).next();
            case 4 -> "/" + (String)Generators.letterStrings((int)6000, (int)8000).next() + pattern;
            case 5 -> pattern + "?large_data=" + (String)Generators.strings((String)("chunk" + (String)Generators.letterStrings((int)50, (int)100).next()), (int)50, (int)100).next();
            case 6 -> pattern + "#" + (String)Generators.letterStrings((int)10000, (int)15000).next();
            case 7 -> pattern + "?payload=" + (String)Generators.letterStrings((int)30000, (int)35000).next();
            default -> pattern + "?memory=" + (String)Generators.letterStrings((int)12000, (int)15000).next();
        };
    }

    private String createAlgorithmicComplexity(String pattern) {
        int attackType = this.hashBasedSelection(8);
        return switch (attackType) {
            case 0 -> pattern + "?" + (String)Generators.strings((String)"a=b&", (int)200, (int)400).next();
            case 1 -> pattern + "/" + (String)Generators.strings((String)"x/", (int)150, (int)300).next() + "target";
            case 2 -> "/" + (String)Generators.strings((String)"../", (int)100, (int)200).next() + pattern;
            case 3 -> pattern + "?" + (String)Generators.strings((String)("param" + this.hashBasedSelection(100) + "=value" + this.hashBasedSelection(100) + "&"), (int)50, (int)100).next();
            case 4 -> pattern + "/" + (String)Generators.strings((String)("segment" + this.hashBasedSelection(50)), (int)80, (int)150).next();
            case 5 -> pattern + "?regex=" + (String)Generators.strings((String)"(a+)+", (int)30, (int)60).next();
            case 6 -> pattern + "/" + (String)Generators.strings((String)("a" + (String)Generators.strings((String)"/b", (int)20, (int)40).next()), (int)15, (int)30).next();
            case 7 -> pattern + "?" + (String)Generators.strings((String)"key=value&", (int)150, (int)300).next();
            default -> pattern + "?" + (String)Generators.strings((String)"a=b&", (int)200, (int)400).next();
        };
    }

    public Class<String> getType() {
        return String.class;
    }

    private int hashBasedSelection(int bound) {
        return Math.abs((int)((long)this.hashCode() + System.nanoTime())) % bound;
    }

    private static class AttackTypeSelector {
        private final int maxTypes;
        private int currentType = 0;

        AttackTypeSelector(int maxTypes) {
            this.maxTypes = maxTypes;
        }

        int nextAttackType() {
            int type = this.currentType;
            this.currentType = (this.currentType + 1) % this.maxTypes;
            return type;
        }
    }
}

