/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.generators.url;

import de.cuioss.test.generator.Generators;
import de.cuioss.test.generator.TypedGenerator;

public class PathTraversalURLGenerator
implements TypedGenerator<String> {
    private final TypedGenerator<Integer> encodingTypeGen = Generators.integers((int)1, (int)6);
    private final TypedGenerator<Integer> depthGen = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Integer> apiPathSelector = Generators.integers((int)1, (int)10);
    private final TypedGenerator<Integer> targetSelector = Generators.integers((int)1, (int)10);
    private final TypedGenerator<Boolean> mixedEncodingGen = Generators.booleans();

    public String next() {
        return switch ((Integer)this.encodingTypeGen.next()) {
            case 1 -> this.generateBasicEncodedTraversal();
            case 2 -> this.generateWindowsStyleTraversal();
            case 3 -> this.generateDoubleEncodedTraversal();
            case 4 -> this.generateMixedEncodingTraversal();
            case 5 -> this.generateLowercaseEncodedTraversal();
            case 6 -> this.generateMultipleDepthTraversal();
            default -> this.generateBasicEncodedTraversal();
        };
    }

    private String generateBasicEncodedTraversal() {
        String apiPath = this.generateApiPath();
        String target = this.generateTarget();
        int depth = (Integer)this.depthGen.next();
        StringBuilder pattern = new StringBuilder("/" + apiPath + "/");
        for (int i = 0; i < depth; ++i) {
            pattern.append("%2E%2E/");
        }
        pattern.append(target);
        return pattern.toString();
    }

    private String generateWindowsStyleTraversal() {
        String apiPath = this.generateApiPath();
        String target = this.generateTarget();
        int depth = (Integer)this.depthGen.next();
        StringBuilder pattern = new StringBuilder("/" + apiPath + "/");
        for (int i = 0; i < depth; ++i) {
            pattern.append("%2E%2E%5C");
        }
        pattern.append(target);
        return pattern.toString();
    }

    private String generateDoubleEncodedTraversal() {
        String apiPath = this.generateApiPath();
        String target = this.generateTarget();
        int depth = (Integer)this.depthGen.next();
        StringBuilder pattern = new StringBuilder("/" + apiPath + "/");
        for (int i = 0; i < depth; ++i) {
            pattern.append("%252e%252e%252f");
        }
        pattern.append(target);
        return pattern.toString();
    }

    private String generateMixedEncodingTraversal() {
        String apiPath = this.generateApiPath();
        String target = this.generateTarget();
        int depth = (Integer)this.depthGen.next();
        StringBuilder pattern = new StringBuilder("/" + apiPath + "/");
        for (int i = 0; i < depth; ++i) {
            if (((Boolean)this.mixedEncodingGen.next()).booleanValue()) {
                pattern.append("%2E%2E/");
                continue;
            }
            pattern.append("../");
        }
        if (((Boolean)this.mixedEncodingGen.next()).booleanValue()) {
            pattern.append(target.replace("/", "%2f"));
        } else {
            pattern.append(target);
        }
        return pattern.toString();
    }

    private String generateLowercaseEncodedTraversal() {
        String apiPath = this.generateApiPath();
        String target = this.generateTarget();
        int depth = (Integer)this.depthGen.next();
        StringBuilder pattern = new StringBuilder("/" + apiPath + "/");
        for (int i = 0; i < depth; ++i) {
            pattern.append("%2e%2e/");
        }
        pattern.append(target);
        return pattern.toString();
    }

    private String generateMultipleDepthTraversal() {
        String apiPath = this.generateApiPath();
        String target = this.generateTarget();
        StringBuilder pattern = new StringBuilder("/" + apiPath + "/users/");
        int deepDepth = (Integer)Generators.integers((int)3, (int)6).next();
        for (int i = 0; i < deepDepth; ++i) {
            pattern.append("%2E%2E%2F");
        }
        pattern.append(target);
        return pattern.toString();
    }

    private String generateApiPath() {
        return switch ((Integer)this.apiPathSelector.next()) {
            case 1 -> "api";
            case 2 -> "files";
            case 3 -> "admin";
            case 4 -> "users";
            case 5 -> "docs";
            case 6 -> "backup";
            case 7 -> "upload";
            case 8 -> "download";
            case 9 -> "data";
            case 10 -> "content";
            default -> "api";
        };
    }

    private String generateTarget() {
        return switch ((Integer)this.targetSelector.next()) {
            case 1 -> "admin";
            case 2 -> "etc/passwd";
            case 3 -> "config";
            case 4 -> "windows";
            case 5 -> "etc/shadow";
            case 6 -> "etc/hosts";
            case 7 -> "var/log";
            case 8 -> "system32";
            case 9 -> "root";
            case 10 -> "root/.ssh";
            default -> "etc/passwd";
        };
    }

    public Class<String> getType() {
        return String.class;
    }
}

